/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.settings;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.maven.api.annotations.Generated;
import org.apache.maven.api.annotations.Nonnull;
import org.apache.maven.settings.Activation;
import org.apache.maven.settings.BaseObject;
import org.apache.maven.settings.IdentifiableBase;
import org.apache.maven.settings.Repository;
import org.apache.maven.settings.WrapperList;
import org.apache.maven.settings.WrapperProperties;

@Generated
public class Profile
extends IdentifiableBase
implements Serializable,
Cloneable {
    public Profile() {
        this(org.apache.maven.api.settings.Profile.newInstance());
    }

    public Profile(org.apache.maven.api.settings.Profile delegate) {
        this(delegate, (BaseObject)null);
    }

    public Profile(org.apache.maven.api.settings.Profile delegate, BaseObject parent) {
        super((org.apache.maven.api.settings.IdentifiableBase)delegate, parent);
    }

    @Override
    public Profile clone() {
        return new Profile(this.getDelegate());
    }

    public org.apache.maven.api.settings.Profile getDelegate() {
        return (org.apache.maven.api.settings.Profile)super.getDelegate();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !(o instanceof Profile)) {
            return false;
        }
        Profile that = (Profile)o;
        return Objects.equals(this.delegate, that.delegate);
    }

    @Override
    public int hashCode() {
        return this.getDelegate().hashCode();
    }

    public Activation getActivation() {
        return this.getDelegate().getActivation() != null ? new Activation(this.getDelegate().getActivation(), (BaseObject)this) : null;
    }

    public void setActivation(Activation activation) {
        if (!Objects.equals(activation, this.getActivation())) {
            if (activation != null) {
                this.update(this.getDelegate().withActivation(activation.getDelegate()));
                activation.childrenTracking = this::replace;
            } else {
                this.update(this.getDelegate().withActivation(null));
            }
        }
    }

    @Nonnull
    public Properties getProperties() {
        return new WrapperProperties(() -> this.getDelegate().getProperties(), this::setProperties);
    }

    public void setProperties(Properties properties) {
        Map<String, String> map = properties.entrySet().stream().collect(Collectors.toMap(e -> e.getKey().toString(), e -> e.getValue().toString()));
        if (!Objects.equals(map, this.getDelegate().getProperties())) {
            this.update(this.getDelegate().withProperties(map));
        }
    }

    public void addProperty(String key, String value) {
        this.getProperties().put(key, value);
    }

    @Nonnull
    public List<Repository> getRepositories() {
        return new WrapperList<Repository, org.apache.maven.api.settings.Repository>(() -> this.getDelegate().getRepositories(), l -> this.update(this.getDelegate().withRepositories((Collection)l)), d -> new Repository((org.apache.maven.api.settings.Repository)d, (BaseObject)this), Repository::getDelegate);
    }

    public void setRepositories(List<Repository> repositories) {
        if (repositories == null) {
            repositories = Collections.emptyList();
        }
        if (!Objects.equals(repositories, this.getRepositories())) {
            this.update(this.getDelegate().withRepositories((Collection)repositories.stream().map(c -> c.getDelegate()).collect(Collectors.toList())));
            repositories.forEach(e -> {
                e.childrenTracking = this::replace;
            });
        }
    }

    public void addRepository(Repository repository) {
        this.update(this.getDelegate().withRepositories((Collection)Stream.concat(this.getDelegate().getRepositories().stream(), Stream.of(repository.getDelegate())).collect(Collectors.toList())));
        repository.childrenTracking = this::replace;
    }

    public void removeRepository(Repository repository) {
        this.update(this.getDelegate().withRepositories((Collection)this.getDelegate().getRepositories().stream().filter(e -> !Objects.equals(e, repository)).collect(Collectors.toList())));
        repository.childrenTracking = null;
    }

    @Nonnull
    public List<Repository> getPluginRepositories() {
        return new WrapperList<Repository, org.apache.maven.api.settings.Repository>(() -> this.getDelegate().getPluginRepositories(), l -> this.update(this.getDelegate().withPluginRepositories((Collection)l)), d -> new Repository((org.apache.maven.api.settings.Repository)d, (BaseObject)this), Repository::getDelegate);
    }

    public void setPluginRepositories(List<Repository> pluginRepositories) {
        if (pluginRepositories == null) {
            pluginRepositories = Collections.emptyList();
        }
        if (!Objects.equals(pluginRepositories, this.getPluginRepositories())) {
            this.update(this.getDelegate().withPluginRepositories((Collection)pluginRepositories.stream().map(c -> c.getDelegate()).collect(Collectors.toList())));
            pluginRepositories.forEach(e -> {
                e.childrenTracking = this::replace;
            });
        }
    }

    public void addPluginRepository(Repository pluginRepository) {
        this.update(this.getDelegate().withPluginRepositories((Collection)Stream.concat(this.getDelegate().getPluginRepositories().stream(), Stream.of(pluginRepository.getDelegate())).collect(Collectors.toList())));
        pluginRepository.childrenTracking = this::replace;
    }

    public void removePluginRepository(Repository pluginRepository) {
        this.update(this.getDelegate().withPluginRepositories((Collection)this.getDelegate().getPluginRepositories().stream().filter(e -> !Objects.equals(e, pluginRepository)).collect(Collectors.toList())));
        pluginRepository.childrenTracking = null;
    }

    @Override
    protected boolean replace(Object oldDelegate, Object newDelegate) {
        if (super.replace(oldDelegate, newDelegate)) {
            return true;
        }
        if (oldDelegate == this.getDelegate().getActivation()) {
            this.update(this.getDelegate().withActivation((org.apache.maven.api.settings.Activation)newDelegate));
            return true;
        }
        if (this.getDelegate().getRepositories().contains(oldDelegate)) {
            ArrayList list = new ArrayList(this.getDelegate().getRepositories());
            list.replaceAll(d -> d == oldDelegate ? (org.apache.maven.api.settings.Repository)newDelegate : d);
            this.update(this.getDelegate().withRepositories(list));
            return true;
        }
        if (this.getDelegate().getPluginRepositories().contains(oldDelegate)) {
            ArrayList list = new ArrayList(this.getDelegate().getPluginRepositories());
            list.replaceAll(d -> d == oldDelegate ? (org.apache.maven.api.settings.Repository)newDelegate : d);
            this.update(this.getDelegate().withPluginRepositories(list));
            return true;
        }
        return false;
    }

    public static List<org.apache.maven.api.settings.Profile> profileToApiV4(List<Profile> list) {
        return list != null ? new WrapperList<org.apache.maven.api.settings.Profile, Profile>(list, Profile::getDelegate, Profile::new) : null;
    }

    public static List<Profile> profileToApiV3(List<org.apache.maven.api.settings.Profile> list) {
        return list != null ? new WrapperList<Profile, org.apache.maven.api.settings.Profile>(list, Profile::new, Profile::getDelegate) : null;
    }
}

