/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.contrib.server.session.proxyprotocolv2.exception;

import org.apache.sshd.server.session.ServerSession;
import org.slf4j.Logger;

public final class ProxyProtocolException
extends Exception {
    public static final int PROXY_PROTOCOL_VERSION_2 = 2;
    private static final int MAX_FAMILY_CODE = 3;
    private static final long serialVersionUID = -7349477687125144605L;

    private ProxyProtocolException(String message) {
        super(message);
    }

    public static ProxyProtocolException buildVersionOrCommand(Logger log, ServerSession session, byte value) {
        byte valueLow = (byte)(value & 0xF);
        byte valueHeight = (byte)(value >> 4);
        if (valueHeight != 2) {
            if (log.isDebugEnabled()) {
                log.debug("readProxyV2Header(session={}) mismatched version in proxy header: expected={}, actual={}", new Object[]{session, Integer.toHexString(2), Integer.toHexString(valueHeight)});
            }
            return new ProxyProtocolException("Invalid version " + valueHeight);
        }
        if (log.isDebugEnabled()) {
            log.debug("readProxyV2Header(session={}) unassigned command in proxy header: actual={}", (Object)session, (Object)Integer.toHexString(valueLow));
        }
        return new ProxyProtocolException("Unassigned command " + valueLow);
    }

    public static ProxyProtocolException buildFamilyAndTransport(Logger log, ServerSession session, byte value) {
        byte valueLow = (byte)(value & 0xF);
        byte valueHeight = (byte)(value >> 4);
        if (valueHeight > 3) {
            if (log.isDebugEnabled()) {
                log.debug("readProxyV2Header(session={}) unspecified family in proxy header: actual={}", (Object)session, (Object)Integer.toHexString(valueHeight));
            }
            return new ProxyProtocolException("Unspecified family " + valueHeight);
        }
        if (log.isDebugEnabled()) {
            log.debug("readProxyV2Header(session={}) unspecified transport in proxy header: actual={}", (Object)session, (Object)Integer.toHexString(valueLow));
        }
        return new ProxyProtocolException("Unspecified transport " + valueLow);
    }
}

