/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.cdi.impl;

import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.InjectionTarget;
import javax.faces.context.ExternalContext;
import org.apache.myfaces.cdi.util.CDIUtils;
import org.apache.myfaces.spi.InjectionProvider;
import org.apache.myfaces.spi.InjectionProviderException;

public class CDIAnnotationInjectionProvider
extends InjectionProvider {
    private BeanManager beanManager;

    public CDIAnnotationInjectionProvider(ExternalContext externalContext) {
        this.beanManager = CDIUtils.getBeanManager(externalContext);
    }

    @Override
    public Object inject(Object instance) throws InjectionProviderException {
        AnnotatedType annoType = this.beanManager.createAnnotatedType(instance.getClass());
        InjectionTarget target = this.beanManager.createInjectionTarget(annoType);
        CreationalContext creationalContext = this.beanManager.createCreationalContext(null);
        target.inject(instance, creationalContext);
        return creationalContext;
    }

    @Override
    public void postConstruct(Object instance, Object creationMetaData) throws InjectionProviderException {
        AnnotatedType annoType = this.beanManager.createAnnotatedType(instance.getClass());
        InjectionTarget target = this.beanManager.createInjectionTarget(annoType);
        target.postConstruct(instance);
    }

    @Override
    public void preDestroy(Object instance, Object creationMetaData) throws InjectionProviderException {
        if (creationMetaData instanceof CreationalContext) {
            AnnotatedType annoType = this.beanManager.createAnnotatedType(instance.getClass());
            InjectionTarget target = this.beanManager.createInjectionTarget(annoType);
            target.preDestroy(instance);
            ((CreationalContext)creationMetaData).release();
        }
    }
}

