/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.cdi.util;

import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.Set;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.Typed;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;

@Typed
public final class BeanProvider {
    private BeanProvider() {
    }

    public static <T> T getContextualReference(BeanManager beanManager, Class<T> type, boolean optional, Annotation ... qualifiers) {
        Set beans = beanManager.getBeans(type, qualifiers);
        if (beans == null || beans.isEmpty()) {
            if (optional) {
                return null;
            }
            throw new IllegalStateException("Could not find beans for Type=" + type + " and qualifiers:" + Arrays.toString(qualifiers));
        }
        return BeanProvider.getContextualReference(type, beanManager, beans);
    }

    private static <T> T getContextualReference(Class<T> type, BeanManager beanManager, Set<Bean<?>> beans) {
        Bean bean = beanManager.resolve(beans);
        CreationalContext creationalContext = beanManager.createCreationalContext((Contextual)bean);
        Object result = beanManager.getReference(bean, type, creationalContext);
        return (T)result;
    }
}

