/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.config;

import jakarta.faces.event.ComponentSystemEvent;
import jakarta.faces.event.PostAddToViewEvent;
import jakarta.faces.event.PostRenderViewEvent;
import jakarta.faces.event.PostValidateEvent;
import jakarta.faces.event.PreRenderComponentEvent;
import jakarta.faces.event.PreRenderViewEvent;
import jakarta.faces.event.PreValidateEvent;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;

public class NamedEventManager {
    private HashMap<String, Collection<Class<? extends ComponentSystemEvent>>> events = new HashMap();

    public NamedEventManager() {
        this.addNamedEvent("postAddToView", PostAddToViewEvent.class);
        this.addNamedEvent("preRenderView", PreRenderViewEvent.class);
        this.addNamedEvent("preRenderComponent", PreRenderComponentEvent.class);
        this.addNamedEvent("preValidate", PreValidateEvent.class);
        this.addNamedEvent("postValidate", PostValidateEvent.class);
        this.addNamedEvent("postRenderView", PostRenderViewEvent.class);
    }

    public void addNamedEvent(String shortName, Class<? extends ComponentSystemEvent> cls) {
        Collection<Class<? extends ComponentSystemEvent>> eventList;
        String key = shortName;
        if (shortName == null) {
            key = this.getFixedName(cls);
        }
        if ((eventList = this.events.get(key)) == null) {
            eventList = new LinkedList<Class<? extends ComponentSystemEvent>>();
            this.events.put(key, eventList);
        }
        eventList.add(cls);
    }

    public Collection<Class<? extends ComponentSystemEvent>> getNamedEvent(String shortName) {
        return this.events.get(shortName);
    }

    private String getFixedName(Class<? extends ComponentSystemEvent> cls) {
        StringBuilder result = new StringBuilder();
        String className = cls.getSimpleName();
        if (className.toLowerCase().endsWith("event")) {
            className = className.substring(0, result.length() - 5);
        }
        if (cls.getPackage() != null) {
            result.append(cls.getPackage().getName());
            result.append('.');
        }
        result.append(className);
        return result.toString();
    }
}

