/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.extensions.cdi.scripting.impl;

import java.lang.annotation.Annotation;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import org.apache.myfaces.extensions.cdi.core.api.provider.BeanManagerProvider;
import org.apache.myfaces.extensions.cdi.scripting.api.LanguageManager;
import org.apache.myfaces.extensions.cdi.scripting.api.language.Language;
import org.apache.myfaces.extensions.cdi.scripting.impl.spi.LanguageBean;
import org.apache.myfaces.extensions.cdi.scripting.impl.util.ExceptionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ApplicationScoped
public class DefaultLanguageManager
implements LanguageManager {
    private static final long serialVersionUID = 7133935225989053503L;
    private ConcurrentHashMap<Class<? extends Language>, Language> languageCache;

    protected DefaultLanguageManager() {
    }

    public String getLanguageName(Class<? extends Language> languageType) {
        Language language = this.languageCache.get(languageType);
        if (language == null) {
            throw ExceptionUtils.noScriptingLanguageAvailableFor(languageType);
        }
        return language.getName();
    }

    @PostConstruct
    protected void init() {
        if (this.languageCache != null) {
            return;
        }
        this.languageCache = new ConcurrentHashMap();
        BeanManager beanManager = BeanManagerProvider.getInstance().getBeanManager();
        Set foundBeans = beanManager.getBeans(LanguageBean.class, new Annotation[0]);
        if (foundBeans.isEmpty()) {
            throw ExceptionUtils.noScriptingLanguageAvailable();
        }
        for (Bean languageBean : foundBeans) {
            CreationalContext creationalContext;
            LanguageBean currentBean = (LanguageBean)languageBean.create(creationalContext = beanManager.createCreationalContext((Contextual)languageBean));
            if (currentBean == null) continue;
            if (this.languageCache.containsKey(currentBean.getId())) {
                throw ExceptionUtils.ambiguousLanguageDefinition(currentBean.getId(), this.languageCache.get(currentBean.getId()), currentBean);
            }
            this.languageCache.put(currentBean.getId(), currentBean);
        }
    }
}

