/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.extensions.cdi.message.api;

import java.util.Arrays;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import org.apache.myfaces.extensions.cdi.message.api.Message;
import org.apache.myfaces.extensions.cdi.message.api.MessageContext;
import org.apache.myfaces.extensions.cdi.message.api.MessageFilter;
import org.apache.myfaces.extensions.cdi.message.api.MessageHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractMessageHandler
implements MessageHandler {
    private Set<MessageFilter> messageFilters = new CopyOnWriteArraySet<MessageFilter>();

    @Override
    public void addMessage(MessageContext messageContext, Message message) {
        if (this.isMessageAllowed(messageContext, message)) {
            this.processMessage(messageContext, message);
        }
    }

    protected abstract void processMessage(MessageContext var1, Message var2);

    @Override
    public void addMessageFilter(MessageFilter ... messageFilters) {
        this.messageFilters.addAll(Arrays.asList(messageFilters));
    }

    @Override
    public Set<MessageFilter> getMessageFilters() {
        return Collections.unmodifiableSet(this.messageFilters);
    }

    private boolean isMessageAllowed(MessageContext messageContext, Message message) {
        for (MessageFilter messageFilter : this.messageFilters) {
            if (messageFilter.processMessage(messageContext, message)) continue;
            return false;
        }
        return true;
    }
}

