/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.extensions.cdi.core.impl;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.Typed;
import javax.enterprise.inject.spi.Extension;
import javax.enterprise.inject.spi.ProcessAnnotatedType;
import javax.interceptor.Interceptor;
import org.apache.myfaces.extensions.cdi.core.api.activation.Deactivatable;
import org.apache.myfaces.extensions.cdi.core.api.projectstage.ProjectStage;
import org.apache.myfaces.extensions.cdi.core.api.startup.CodiStartupBroadcaster;
import org.apache.myfaces.extensions.cdi.core.impl.util.ClassDeactivation;

public class CodiDeactivatorExtension
implements Extension,
Deactivatable {
    private Logger logger = Logger.getLogger(CodiDeactivatorExtension.class.getName());

    public void filter(@Observes ProcessAnnotatedType processAnnotatedType) {
        if (!this.isActivated()) {
            return;
        }
        CodiStartupBroadcaster.broadcastStartup();
        this.filterInterceptors(processAnnotatedType);
        this.filterProjectStageClasses(processAnnotatedType);
    }

    protected void filterInterceptors(ProcessAnnotatedType processAnnotatedType) {
        if (processAnnotatedType.getAnnotatedType().isAnnotationPresent(Interceptor.class) && !ClassDeactivation.isClassActivated(processAnnotatedType.getAnnotatedType().getJavaClass())) {
            processAnnotatedType.veto();
        }
    }

    protected void filterProjectStageClasses(ProcessAnnotatedType processAnnotatedType) {
        if (!ClassDeactivation.isClassActivated(ProjectStage.class)) {
            return;
        }
        Class beanClass = processAnnotatedType.getAnnotatedType().getJavaClass();
        if (ProjectStage.class.isAssignableFrom(beanClass) && !beanClass.isAnnotationPresent(Typed.class)) {
            if (this.logger.isLoggable(Level.FINE)) {
                this.logger.fine(beanClass.getName() + " is no normal CDI bean and it isn't annotated with @Typed()" + " so an automatic veto has to be done. " + "If there is a problem, it's possible to deactivate this automatic veto. " + "In such a case please check the documentation or contact the community.");
            }
            processAnnotatedType.veto();
        }
    }

    public boolean isActivated() {
        return ClassDeactivation.isClassActivated(this.getClass());
    }
}

