/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.extensions.cdi.core.impl.resource.bundle;

import java.lang.annotation.Annotation;
import java.util.Set;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.context.Dependent;
import javax.enterprise.inject.Produces;
import javax.enterprise.inject.spi.InjectionPoint;
import org.apache.myfaces.extensions.cdi.core.api.resource.bundle.Bundle;
import org.apache.myfaces.extensions.cdi.core.api.resource.bundle.ResourceBundle;
import org.apache.myfaces.extensions.cdi.core.impl.resource.bundle.DefaultResourceBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ApplicationScoped
public class ResourceBundleProducer {
    @Produces
    @Dependent
    protected ResourceBundle injectableResourceBundle(InjectionPoint injectionPoint) {
        Bundle bundle = ResourceBundleProducer.getBundleClass(injectionPoint.getAnnotated().getAnnotations());
        if (bundle != null) {
            Class bundleClass = bundle.value();
            if (bundleClass != null && !Class.class.getName().equals(bundleClass.getName())) {
                return this.createDefaultResourceBundle().useBundle(bundleClass);
            }
            if (!"".equals(bundle.name())) {
                return this.createDefaultResourceBundle().useBundle(bundle.name());
            }
        }
        return this.createDefaultResourceBundle();
    }

    private static Bundle getBundleClass(Set<Annotation> qualifiers) {
        for (Annotation qualifier : qualifiers) {
            if (!Bundle.class.isAssignableFrom(qualifier.annotationType())) continue;
            return (Bundle)qualifier;
        }
        return null;
    }

    protected ResourceBundle createDefaultResourceBundle() {
        return new DefaultResourceBundle();
    }
}

