/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.extensions.cdi.message.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.myfaces.extensions.cdi.message.api.Default;
import org.apache.myfaces.extensions.cdi.message.api.Formatter;
import org.apache.myfaces.extensions.cdi.message.api.Localizable;
import org.apache.myfaces.extensions.cdi.message.api.Message;
import org.apache.myfaces.extensions.cdi.message.api.MessageBuilder;
import org.apache.myfaces.extensions.cdi.message.api.MessageContext;
import org.apache.myfaces.extensions.cdi.message.api.MessageContextConfigAware;
import org.apache.myfaces.extensions.cdi.message.api.MessageFactory;
import org.apache.myfaces.extensions.cdi.message.api.MessageInterpolator;
import org.apache.myfaces.extensions.cdi.message.api.MessageResolver;
import org.apache.myfaces.extensions.cdi.message.api.NamedArgument;
import org.apache.myfaces.extensions.cdi.message.api.payload.ArgumentDescriptor;
import org.apache.myfaces.extensions.cdi.message.api.payload.MessagePayload;
import org.apache.myfaces.extensions.cdi.message.api.payload.MessagePayloadKey;
import org.apache.myfaces.extensions.cdi.message.api.payload.MessageSeverity;
import org.apache.myfaces.extensions.cdi.message.impl.DefaultMessage;
import org.apache.myfaces.extensions.cdi.message.impl.DefaultMessageFactory;
import org.apache.myfaces.extensions.cdi.message.impl.DefaultNamedArgument;
import org.apache.myfaces.extensions.cdi.message.impl.UnmodifiableMessageContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class DefaultMessageBuilder
implements MessageBuilder {
    private static final long serialVersionUID = 892218539314030675L;
    private ArrayList<Serializable> argumentList;
    private HashSet<NamedArgument> namedArguments;
    private MessageContext messageContext;
    private HashMap<Class, MessagePayload> messagePayload;
    private String messageDescriptor;
    private MessageFactory messageFactory;

    protected DefaultMessageBuilder() {
    }

    public DefaultMessageBuilder(MessageContext messageContext, MessageFactory messageFactory) {
        this.reset();
        this.messageContext = new UnmodifiableMessageContext(messageContext.cloneContext());
        this.messageFactory = messageFactory != null ? messageFactory : new DefaultMessageFactory();
    }

    public MessageBuilder payload(MessagePayload ... messagePayload) {
        for (MessagePayload payload : messagePayload) {
            Class key = payload.getClass();
            if (payload.getClass().isAnnotationPresent(MessagePayloadKey.class)) {
                key = payload.getClass().getAnnotation(MessagePayloadKey.class).value();
            }
            this.messagePayload.put(key, payload);
        }
        return this;
    }

    public MessageBuilder text(String messageDescriptor) {
        this.messageDescriptor = messageDescriptor;
        return this;
    }

    public MessageBuilder argument(Serializable ... arguments) {
        for (Serializable argument : arguments) {
            if (argument instanceof NamedArgument) {
                this.namedArguments.add((NamedArgument)argument);
                continue;
            }
            this.argumentList.add(argument);
        }
        return this;
    }

    public MessageBuilder namedArgument(String name, Serializable value) {
        this.namedArguments.add(new DefaultNamedArgument(name, value));
        return this;
    }

    public Message add() {
        Message result = this.create();
        this.messageContext.addMessage(this.messageContext, result);
        return result;
    }

    private Message buildMessage() {
        if (this.messageDescriptor == null) {
            throw new IllegalStateException("messageDescriptor is missing");
        }
        Message result = this.createNewMessage();
        if (result instanceof MessageContextConfigAware && this.messageContext != null) {
            ((MessageContextConfigAware)result).setMessageContextConfig(this.messageContext.config());
        }
        this.addArguments(result);
        this.addPayload(result);
        return result;
    }

    private Message createNewMessage() {
        if (this.messageFactory != null) {
            return this.messageFactory.create(this.messageDescriptor, this.getMessageSeverity());
        }
        return new DefaultMessage(this.messageDescriptor, this.getMessageSeverity(), new Serializable[0]);
    }

    private MessagePayload getMessageSeverity() {
        MessagePayload severity = this.messagePayload.get(MessageSeverity.class);
        if (severity == null) {
            severity = MessageSeverity.INFO;
        }
        return severity;
    }

    private void addArguments(Message result) {
        if (!this.argumentList.isEmpty()) {
            result.addArgument(this.argumentList.toArray(new Serializable[this.argumentList.size()]));
        }
        if (!this.namedArguments.isEmpty()) {
            result.addArgument(this.namedArguments.toArray(new Serializable[this.namedArguments.size()]));
        }
    }

    private void addPayload(Message result) {
        for (Map.Entry<Class, MessagePayload> entry : this.messagePayload.entrySet()) {
            if (MessageSeverity.class.equals((Object)entry.getKey())) continue;
            result.addPayload(entry.getKey(), entry.getValue());
        }
    }

    protected void reset() {
        this.messageDescriptor = null;
        this.messagePayload = new HashMap();
        this.argumentList = new ArrayList();
        this.namedArguments = new HashSet();
    }

    public Message create() {
        Message result = this.buildMessage();
        this.reset();
        return result;
    }

    public String toText() {
        Message baseMessage = this.buildMessage();
        return this.getMessageText(baseMessage);
    }

    private String getMessageText(Message baseMessage) {
        MessageInterpolator messageInterpolator;
        String message = baseMessage.getDescriptor();
        MessageResolver messageResolver = this.messageContext.config().getMessageResolver();
        if (messageResolver != null) {
            message = this.resolveMessage(messageResolver, baseMessage);
        }
        if ((messageInterpolator = this.messageContext.config().getMessageInterpolator()) != null && message != null) {
            return this.checkedResult(this.interpolateMessage(messageInterpolator, message, this.restoreArguments(baseMessage, this.messageContext)), baseMessage);
        }
        return this.checkedResult(message, baseMessage);
    }

    private String checkedResult(String result, Message baseMessage) {
        if (result == null || this.isKey(baseMessage.getDescriptor()) || this.isKeyWithoutMarkers(result, baseMessage)) {
            String oldTemplate = this.extractTemplate(baseMessage.getDescriptor());
            if (result == null || result.equals(oldTemplate)) {
                return "???" + oldTemplate + "???" + this.getArguments(baseMessage);
            }
        }
        return result;
    }

    private boolean isKeyWithoutMarkers(String result, Message baseMessage) {
        return !result.contains(" ") && result.endsWith(baseMessage.getDescriptor());
    }

    private String getArguments(Message message) {
        StringBuffer result = new StringBuffer();
        Serializable[] arguments = message.getArguments();
        if (arguments == null || arguments.length == 0) {
            return "";
        }
        for (int i = 0; i < arguments.length; ++i) {
            if (i == 0) {
                result.append(" (");
            } else {
                result.append(",");
            }
            Serializable argument = arguments[i];
            Formatter formatter = this.messageContext.config().getFormatterFactory().findFormatter(argument.getClass());
            if (formatter != null && !this.isDefaultFormatter(formatter.getClass())) {
                result.append(formatter.format(this.messageContext, (Object)argument));
                continue;
            }
            if (argument instanceof Localizable) {
                result.append(((Localizable)argument).toString(this.messageContext));
                continue;
            }
            if (formatter != null) {
                result.append(formatter.format(this.messageContext, (Object)argument));
                continue;
            }
            result.append(argument.toString());
        }
        result.append(')');
        return result.toString();
    }

    private Serializable[] restoreArguments(Message baseMessage, MessageContext messageContext) {
        if (messageContext == null || baseMessage.getArguments() == null) {
            return baseMessage.getArguments();
        }
        ArrayList<Serializable> result = new ArrayList<Serializable>(baseMessage.getArguments().length);
        for (Serializable argument : baseMessage.getArguments()) {
            if (this.isNumberedArgumentValueALazyArgument(argument)) {
                this.resolveAndProcessLazyNumberedArgument(messageContext, result, (String)((Object)argument));
                continue;
            }
            if (argument instanceof NamedArgument && this.isNamedArgumentValueALazyArgument((NamedArgument)argument)) {
                this.resolveAndProcessLazyNamedArgument(messageContext, result, (NamedArgument)argument);
                continue;
            }
            result.add(argument);
        }
        return result.toArray(new Serializable[result.size()]);
    }

    private boolean isNumberedArgumentValueALazyArgument(Serializable argument) {
        return argument instanceof String && this.isKey((String)((Object)argument));
    }

    private boolean isNamedArgumentValueALazyArgument(NamedArgument namedArgument) {
        return namedArgument.getValue() instanceof String && this.isKey((String)((Object)namedArgument.getValue()));
    }

    private void resolveAndProcessLazyNumberedArgument(MessageContext messageContext, List<Serializable> result, String argument) {
        String resolvedArgumentValue = this.resolveValueOfArgumentDescriptor(messageContext, argument);
        result.add((Serializable)((Object)resolvedArgumentValue));
    }

    private void resolveAndProcessLazyNamedArgument(MessageContext messageContext, List<Serializable> result, NamedArgument argument) {
        String namedArgumentValue = (String)((Object)argument.getValue());
        String resolvedNamedArgumentValue = this.resolveValueOfArgumentDescriptor(messageContext, namedArgumentValue);
        result.add((Serializable)((Object)new DefaultNamedArgument(argument.getName(), (Serializable)((Object)resolvedNamedArgumentValue))));
    }

    private String resolveValueOfArgumentDescriptor(MessageContext messageContext, String argumentAsKey) {
        return messageContext.message().text(argumentAsKey).payload(new MessagePayload[]{ArgumentDescriptor.PAYLOAD}).toText();
    }

    private boolean isDefaultFormatter(Class<? extends Formatter> formatterClass) {
        return formatterClass.isAnnotationPresent(Default.class);
    }

    private String extractTemplate(String template) {
        String result = this.getEscapedTemplate(template);
        if (this.isKey(result)) {
            result = this.extractTemplateKey(result);
        }
        return result;
    }

    private boolean isKey(String key) {
        return key.startsWith("{") && key.endsWith("}");
    }

    private String extractTemplateKey(String key) {
        return key.substring(1, key.length() - 1);
    }

    private String resolveMessage(MessageResolver messageResolver, Message baseMessage) {
        return messageResolver.getMessage(this.messageContext, baseMessage.getDescriptor(), baseMessage.getPayload());
    }

    private String interpolateMessage(MessageInterpolator messageInterpolator, String messageDescriptor, Serializable ... arguments) {
        return messageInterpolator.interpolate(this.messageContext, this.getEscapedTemplate(messageDescriptor), arguments);
    }

    private String getEscapedTemplate(String messageDescriptor) {
        if (messageDescriptor.startsWith("\\{")) {
            return messageDescriptor.substring(1);
        }
        return messageDescriptor;
    }

    protected MessageContext getMessageContext() {
        return this.messageContext;
    }

    protected void setMessageFactory(MessageFactory messageFactory) {
        this.messageFactory = messageFactory;
    }
}

