/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.extensions.cdi.jsf.impl.security;

import java.lang.annotation.Annotation;
import java.util.List;
import javax.enterprise.inject.spi.BeanManager;
import javax.faces.application.ViewHandler;
import javax.faces.application.ViewHandlerWrapper;
import javax.faces.component.UIViewRoot;
import javax.faces.context.FacesContext;
import org.apache.myfaces.extensions.cdi.core.api.activation.Deactivatable;
import org.apache.myfaces.extensions.cdi.core.api.config.view.ViewConfig;
import org.apache.myfaces.extensions.cdi.core.api.provider.BeanManagerProvider;
import org.apache.myfaces.extensions.cdi.core.api.security.AccessDecisionVoterContext;
import org.apache.myfaces.extensions.cdi.core.api.security.AccessDeniedException;
import org.apache.myfaces.extensions.cdi.core.impl.util.ClassDeactivation;
import org.apache.myfaces.extensions.cdi.core.impl.util.CodiUtils;
import org.apache.myfaces.extensions.cdi.core.impl.util.SecurityUtils;
import org.apache.myfaces.extensions.cdi.jsf.api.config.JsfModuleConfig;
import org.apache.myfaces.extensions.cdi.jsf.api.config.view.Page;
import org.apache.myfaces.extensions.cdi.jsf.api.config.view.ViewConfigDescriptor;
import org.apache.myfaces.extensions.cdi.jsf.impl.config.view.ViewConfigCache;
import org.apache.myfaces.extensions.cdi.jsf.impl.config.view.spi.EditableViewConfigDescriptor;

public class SecurityAwareViewHandler
extends ViewHandlerWrapper
implements Deactivatable {
    private ViewHandler wrapped;
    private volatile BeanManager beanManager;
    private final boolean deactivated;

    public SecurityAwareViewHandler(ViewHandler wrapped) {
        this.wrapped = wrapped;
        this.deactivated = !this.isActivated();
    }

    public ViewHandler getWrapped() {
        return this.wrapped;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UIViewRoot createView(FacesContext context, String viewId) {
        UIViewRoot result = this.wrapped.createView(context, viewId);
        if (this.deactivated) {
            return result;
        }
        UIViewRoot originalViewRoot = context.getViewRoot();
        context.setViewRoot(result);
        try {
            ViewConfigDescriptor entry = ViewConfigCache.getViewConfigDescriptor(result.getViewId());
            if (entry != null) {
                this.lazyInit();
                AccessDecisionVoterContext voterContext = (AccessDecisionVoterContext)CodiUtils.getContextualReferenceByClass((BeanManager)this.beanManager, AccessDecisionVoterContext.class, (boolean)true, (Annotation[])new Annotation[0]);
                Class<? extends ViewConfig> errorView = null;
                if (entry instanceof EditableViewConfigDescriptor) {
                    errorView = ((EditableViewConfigDescriptor)entry).getErrorView();
                }
                SecurityUtils.invokeVoters(null, (BeanManager)this.beanManager, (AccessDecisionVoterContext)voterContext, (List)entry.getAccessDecisionVoters(), errorView);
            }
        }
        catch (AccessDeniedException accessDeniedException) {
            Class errorView;
            ViewConfigDescriptor errorViewDescriptor = ViewConfigCache.getViewConfigDescriptor(accessDeniedException.getErrorView());
            if (errorViewDescriptor != null && errorViewDescriptor.getNavigationMode() == Page.NavigationMode.REDIRECT && ((JsfModuleConfig)CodiUtils.getContextualReferenceByClass((BeanManager)this.beanManager, JsfModuleConfig.class, (Annotation[])new Annotation[0])).isAlwaysUseNavigationHandlerOnSecurityViolation()) {
                org.apache.myfaces.extensions.cdi.jsf.impl.util.SecurityUtils.tryToHandleSecurityViolation((RuntimeException)((Object)accessDeniedException));
                errorView = errorViewDescriptor.getViewConfig();
            } else {
                errorView = org.apache.myfaces.extensions.cdi.jsf.impl.util.SecurityUtils.handleSecurityViolationWithoutNavigation((RuntimeException)((Object)accessDeniedException));
            }
            UIViewRoot uIViewRoot = this.wrapped.createView(context, ViewConfigCache.getViewConfigDescriptor(errorView).getViewId());
            return uIViewRoot;
        }
        finally {
            if (originalViewRoot != null) {
                context.setViewRoot(originalViewRoot);
            }
        }
        return result;
    }

    private void lazyInit() {
        if (this.beanManager == null) {
            this.init();
        }
    }

    private synchronized void init() {
        if (this.beanManager == null) {
            this.beanManager = BeanManagerProvider.getInstance().getBeanManager();
        }
    }

    public boolean isActivated() {
        return ClassDeactivation.isClassActivated(((Object)((Object)this)).getClass());
    }
}

