/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.extensions.cdi.core.impl;

import java.util.Map;
import java.util.logging.Level;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.spi.BeanManager;
import javax.inject.Inject;
import org.apache.myfaces.extensions.cdi.core.api.CodiInformation;
import org.apache.myfaces.extensions.cdi.core.api.config.CodiConfig;
import org.apache.myfaces.extensions.cdi.core.api.projectstage.ProjectStage;
import org.apache.myfaces.extensions.cdi.core.api.provider.BeanManagerProvider;
import org.apache.myfaces.extensions.cdi.core.api.startup.event.StartupEvent;
import org.apache.myfaces.extensions.cdi.core.api.util.ClassUtils;
import org.apache.myfaces.extensions.cdi.core.impl.AbstractStartupObserver;

@ApplicationScoped
public class CoreStartupObserver
extends AbstractStartupObserver {
    @Inject
    protected ProjectStage projectStage;

    protected CoreStartupObserver() {
    }

    protected void logCoreConfiguration(@Observes StartupEvent startupEvent) {
        if (!this.codiCoreConfig.isConfigurationLoggingEnabled()) {
            return;
        }
        try {
            String applicationParameters;
            String cdiVersion = this.detectActiveCdiVersion();
            StringBuilder info = new StringBuilder("[Started] MyFaces CODI (Extensions CDI) Core");
            info.append(this.getCodiCoreInformation());
            info.append(this.separator);
            if (cdiVersion != null) {
                info.append(cdiVersion);
                info.append(this.separator);
            }
            info.append(this.separator);
            info.append("project-stage: ");
            info.append(this.projectStage.toString());
            info.append(this.separator);
            info.append("project-stage class: ");
            info.append(this.projectStage.getClass().getName());
            info.append(this.separator);
            info.append(this.separator);
            String systemProperties = this.getSystemPropertiesForCodi();
            if (systemProperties != null) {
                info.append("system-properties:");
                info.append(this.separator);
                info.append(systemProperties);
            }
            if ((applicationParameters = this.getApplicationParameters(startupEvent)) != null) {
                info.append("application-parameters:");
                info.append(this.separator);
                info.append(applicationParameters);
            }
            info.append(this.getConfigInfo((CodiConfig)this.codiCoreConfig));
            this.logger.info(info.toString());
        }
        catch (Exception e) {
            this.logger.log(Level.WARNING, "Core-Module couldn't log the current configuration.Startup will continue!", e);
        }
    }

    private String getSystemPropertiesForCodi() {
        StringBuilder info = new StringBuilder("");
        for (Map.Entry<Object, Object> property : System.getProperties().entrySet()) {
            if (!(property.getKey() instanceof String) || !((String)property.getKey()).startsWith("org.apache.myfaces.extensions.cdi")) continue;
            info.append("   name:\t").append(property.getKey());
            info.append(this.separator);
            info.append("   value:\t").append(property.getValue());
            info.append(this.separator);
            info.append(this.separator);
        }
        String result = info.toString();
        if ("".equals(result)) {
            return null;
        }
        return result;
    }

    private String getApplicationParameters(StartupEvent startupEvent) {
        StringBuilder info = new StringBuilder("");
        for (Map.Entry contextParam : startupEvent.getApplicationParameters().entrySet()) {
            info.append("   name:\t").append((String)contextParam.getKey());
            info.append(this.separator);
            info.append("   value:\t").append(contextParam.getValue());
            info.append(this.separator);
            info.append(this.separator);
        }
        String result = info.toString();
        if ("".equals(result)) {
            return null;
        }
        return result;
    }

    private String detectActiveCdiVersion() {
        BeanManager cdiClass = BeanManagerProvider.getInstance().getBeanManager();
        if (cdiClass == null) {
            return null;
        }
        String version = ClassUtils.getJarVersion(cdiClass.getClass());
        String description = "Used CDI implementation: ";
        if (cdiClass.getClass().getName().startsWith("org.apache")) {
            return description + "OpenWebBeans v" + version;
        }
        if (cdiClass.getClass().getName().startsWith("org.jboss")) {
            return description + "Weld v" + version;
        }
        return null;
    }

    private String getCodiCoreInformation() {
        String version = CodiInformation.VERSION;
        if (version != null && !version.startsWith("null")) {
            String revision = CodiInformation.REVISION;
            if (version.endsWith("-SNAPSHOT") && revision != null && !revision.startsWith("null")) {
                version = version.replace("-SNAPSHOT", " r");
            } else {
                revision = "";
            }
            return " v" + version + revision;
        }
        return "";
    }
}

