/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.extensions.cdi.core.impl.scope.conversation;

import java.lang.annotation.Annotation;
import java.util.HashSet;
import java.util.Set;
import javax.enterprise.context.spi.Context;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.PassivationCapable;
import org.apache.myfaces.extensions.cdi.core.api.config.CodiCoreConfig;
import org.apache.myfaces.extensions.cdi.core.api.config.view.DefaultErrorView;
import org.apache.myfaces.extensions.cdi.core.api.provider.BeanManagerProvider;
import org.apache.myfaces.extensions.cdi.core.api.security.AccessDeniedException;
import org.apache.myfaces.extensions.cdi.core.api.security.SecurityViolation;
import org.apache.myfaces.extensions.cdi.core.api.security.event.InvalidBeanCreationEvent;
import org.apache.myfaces.extensions.cdi.core.impl.scope.conversation.AbstractGroupedConversationContext;
import org.apache.myfaces.extensions.cdi.core.impl.util.CodiUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConversationContextAdapter
implements Context {
    private final Class<? extends Annotation> scopeType;
    private final AbstractGroupedConversationContext conversationContext;
    private BeanManager beanManager;
    private Boolean invalidBeanCreationEventEnabled;

    public ConversationContextAdapter(Class<? extends Annotation> scope, AbstractGroupedConversationContext conversationContext, BeanManager beanManager) {
        this.scopeType = scope;
        this.conversationContext = conversationContext;
        this.beanManager = beanManager;
    }

    public Class<? extends Annotation> getScope() {
        return this.scopeType;
    }

    public <T> T get(Contextual<T> component, CreationalContext<T> creationalContext) {
        if (component instanceof PassivationCapable && !(component instanceof Bean)) {
            component = BeanManagerProvider.getInstance().getBeanManager().getPassivationCapableBean(((PassivationCapable)component).getId());
        }
        if (component instanceof Bean) {
            this.checkForInvalidBeanAccess((Bean)component);
            return this.conversationContext.create(component, creationalContext);
        }
        Class<?> invalidComponentClass = component.create(creationalContext).getClass();
        throw new IllegalStateException(invalidComponentClass + " is no valid conversation scoped bean");
    }

    public <T> T get(Contextual<T> component) {
        if (component == null) {
            return null;
        }
        if (component instanceof PassivationCapable && !(component instanceof Bean)) {
            component = BeanManagerProvider.getInstance().getBeanManager().getPassivationCapableBean(((PassivationCapable)component).getId());
        }
        if (component instanceof Bean) {
            return this.conversationContext.resolve((Bean)component);
        }
        throw new IllegalStateException(component.getClass() + " is no valid conversation scoped bean");
    }

    public boolean isActive() {
        return this.conversationContext.isActive();
    }

    private <T> void checkForInvalidBeanAccess(Bean<T> bean) {
        this.lazyInit();
        if (!this.invalidBeanCreationEventEnabled.booleanValue()) {
            return;
        }
        Set<SecurityViolation> violations = this.conversationContext.checkPermission(bean);
        HashSet<SecurityViolation> violationsToThrow = new HashSet<SecurityViolation>();
        for (SecurityViolation securityViolation : violations) {
            InvalidBeanCreationEvent invalidBeanCreationEvent = new InvalidBeanCreationEvent(securityViolation);
            this.beanManager.fireEvent((Object)invalidBeanCreationEvent, new Annotation[0]);
            if (!invalidBeanCreationEvent.isThrowSecurityViolation()) continue;
            violationsToThrow.add(securityViolation);
        }
        if (!violationsToThrow.isEmpty()) {
            throw new AccessDeniedException(violationsToThrow, DefaultErrorView.class);
        }
    }

    private void lazyInit() {
        if (this.invalidBeanCreationEventEnabled == null) {
            this.init();
        }
    }

    private synchronized void init() {
        if (this.invalidBeanCreationEventEnabled == null) {
            CodiCoreConfig codiCoreConfig = CodiUtils.getContextualReferenceByClass(this.beanManager, CodiCoreConfig.class, new Annotation[0]);
            this.invalidBeanCreationEventEnabled = codiCoreConfig.isInvalidBeanCreationEventEnabled();
        }
    }
}

