/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.extensions.cdi.core.api.startup;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.myfaces.extensions.cdi.core.api.provider.ServiceProvider;
import org.apache.myfaces.extensions.cdi.core.api.provider.ServiceProviderContext;
import org.apache.myfaces.extensions.cdi.core.api.startup.event.StartupEventBroadcaster;
import org.apache.myfaces.extensions.cdi.core.api.tools.InvocationOrderComparator;
import org.apache.myfaces.extensions.cdi.core.api.util.ClassUtils;

public abstract class CodiStartupBroadcaster {
    private static volatile Map<ClassLoader, Boolean> initialized = new HashMap<ClassLoader, Boolean>();
    private static Map<ClassLoader, List<Class<? extends StartupEventBroadcaster>>> broadcasterFilter = new ConcurrentHashMap<ClassLoader, List<Class<? extends StartupEventBroadcaster>>>();

    private CodiStartupBroadcaster() {
    }

    public static void broadcastStartup() {
        ClassLoader classLoader = ClassUtils.getClassLoader(null);
        if (!initialized.containsKey(classLoader)) {
            CodiStartupBroadcaster.invokeStartupEventBroadcaster(classLoader);
        }
    }

    private static synchronized void invokeStartupEventBroadcaster(final ClassLoader classLoader) {
        if (initialized.containsKey(classLoader)) {
            return;
        }
        List<StartupEventBroadcaster> startupEventBroadcasterList = ServiceProvider.loadServices(StartupEventBroadcaster.class, new ServiceProviderContext(){

            public ClassLoader getClassLoader() {
                return classLoader;
            }
        });
        List<Class<? extends StartupEventBroadcaster>> filter = broadcasterFilter.get(classLoader);
        if (filter == null) {
            filter = new CopyOnWriteArrayList<Class<? extends StartupEventBroadcaster>>();
            broadcasterFilter.put(classLoader, filter);
        }
        ArrayList<StartupEventBroadcaster> broadcasters = new ArrayList<StartupEventBroadcaster>();
        for (StartupEventBroadcaster startupEventBroadcaster : startupEventBroadcasterList) {
            if (filter.contains(startupEventBroadcaster.getClass())) continue;
            filter.add(startupEventBroadcaster.getClass());
            broadcasters.add(startupEventBroadcaster);
        }
        Collections.sort(broadcasters, new InvocationOrderComparator());
        for (StartupEventBroadcaster startupEventBroadcaster : broadcasters) {
            startupEventBroadcaster.broadcastStartup();
        }
        initialized.put(classLoader, Boolean.TRUE);
    }
}

