/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.extensions.cdi.jpa.impl.transaction;

import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.context.Dependent;
import javax.enterprise.inject.Default;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.inject.Inject;
import javax.interceptor.InvocationContext;
import javax.persistence.EntityManager;
import javax.persistence.EntityTransaction;
import org.apache.myfaces.extensions.cdi.core.impl.util.AnyLiteral;
import org.apache.myfaces.extensions.cdi.jpa.api.Transactional;
import org.apache.myfaces.extensions.cdi.jpa.impl.PersistenceHelper;
import org.apache.myfaces.extensions.cdi.jpa.impl.spi.PersistenceStrategy;
import org.apache.myfaces.extensions.cdi.jpa.impl.transaction.context.TransactionBeanStorage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Dependent
public class TransactionalInterceptorStrategy
implements PersistenceStrategy {
    private static final long serialVersionUID = -1432802805095533499L;
    private static final Logger LOGGER = Logger.getLogger(TransactionalInterceptorStrategy.class.getName());
    @Inject
    private BeanManager beanManager;
    private static transient ThreadLocal<HashMap<String, AtomicInteger>> refCounterMaps = new ThreadLocal();
    private static transient ThreadLocal<HashMap<String, EntityManager>> ems = new ThreadLocal();

    public Object execute(InvocationContext invocationContext) throws Exception {
        boolean commitFailed22;
        Object object;
        Exception firstException;
        String qualifierKey;
        block30: {
            String previousTransactionKey;
            block29: {
                Transactional transactionalAnnotation = this.extractTransactionalAnnotation(invocationContext);
                Class<? extends Annotation> qualifierClass = this.getTransactionQualifier(transactionalAnnotation);
                qualifierKey = qualifierClass.getName();
                int transactionLayer = this.incrementRefCounter(qualifierKey);
                if (transactionLayer == 0) {
                    if (TransactionBeanStorage.getStorage() == null) {
                        TransactionBeanStorage.activateNewStorage();
                    }
                    TransactionBeanStorage.getStorage().startTransactionScope(qualifierKey);
                }
                previousTransactionKey = TransactionBeanStorage.getStorage().activateTransactionScope(qualifierKey);
                EntityManager entityManager = this.resolveEntityManagerForQualifier(qualifierClass);
                if (entityManager == null) {
                    entityManager = PersistenceHelper.tryToFindEntityManagerReference(invocationContext.getTarget());
                }
                this.storeEntityManagerForQualifier(qualifierKey, entityManager);
                EntityTransaction transaction = entityManager.getTransaction();
                firstException = null;
                try {
                    if (!transaction.isActive()) {
                        transaction.begin();
                    }
                    object = invocationContext.proceed();
                    Object var17_13 = null;
                    commitFailed22 = false;
                    if (!this.isOutermostInterceptor()) break block29;
                    if (firstException != null) break block30;
                }
                catch (Exception e) {
                    try {
                        firstException = e;
                        if (this.isOutermostInterceptor()) {
                            HashMap<String, EntityManager> emsEntries = ems.get();
                            for (Map.Entry<String, EntityManager> emsEntry : emsEntries.entrySet()) {
                                EntityManager em = emsEntry.getValue();
                                transaction = em.getTransaction();
                                if (transaction == null || !transaction.isActive()) continue;
                                try {
                                    transaction.rollback();
                                }
                                catch (Exception eRollback) {
                                    if (!LOGGER.isLoggable(Level.SEVERE)) continue;
                                    LOGGER.log(Level.SEVERE, "Got additional Exception while subsequently rolling back other SQL transactions", eRollback);
                                }
                            }
                            ems.remove();
                        }
                        e = this.prepareException(e);
                        throw e;
                    }
                    catch (Throwable throwable) {
                        Object var17_14 = null;
                        boolean commitFailed22 = false;
                        if (this.isOutermostInterceptor()) {
                            if (firstException == null) {
                                for (EntityManager entityManager2 : ems.get().values()) {
                                    transaction = entityManager2.getTransaction();
                                    if (transaction == null || !transaction.isActive()) continue;
                                    try {
                                        if (commitFailed22) continue;
                                        entityManager2.flush();
                                    }
                                    catch (Exception e2) {
                                        firstException = e2;
                                        commitFailed22 = true;
                                        break;
                                    }
                                }
                                for (Map.Entry entry : ems.get().entrySet()) {
                                    EntityManager em = (EntityManager)entry.getValue();
                                    transaction = em.getTransaction();
                                    if (transaction == null || !transaction.isActive()) continue;
                                    try {
                                        if (!commitFailed22) {
                                            transaction.commit();
                                            continue;
                                        }
                                        transaction.rollback();
                                    }
                                    catch (Exception e3) {
                                        firstException = e3;
                                        commitFailed22 = true;
                                    }
                                }
                                ems.remove();
                                ems.set(null);
                                refCounterMaps.set(null);
                                refCounterMaps.remove();
                                TransactionBeanStorage oldStorage = TransactionBeanStorage.getStorage();
                                TransactionBeanStorage.resetStorage();
                                oldStorage.endAllTransactionScopes();
                            }
                        } else {
                            TransactionBeanStorage.getStorage().activateTransactionScope(previousTransactionKey);
                        }
                        this.decrementRefCounter(qualifierKey);
                        if (commitFailed22) {
                            throw firstException;
                        }
                        throw throwable;
                    }
                }
                for (EntityManager entityManager3 : ems.get().values()) {
                    transaction = entityManager3.getTransaction();
                    if (transaction == null || !transaction.isActive()) continue;
                    try {
                        if (commitFailed22) continue;
                        entityManager3.flush();
                    }
                    catch (Exception e2) {
                        firstException = e2;
                        commitFailed22 = true;
                        break;
                    }
                }
                for (Map.Entry entry : ems.get().entrySet()) {
                    EntityManager em = (EntityManager)entry.getValue();
                    transaction = em.getTransaction();
                    if (transaction == null || !transaction.isActive()) continue;
                    try {
                        if (!commitFailed22) {
                            transaction.commit();
                            continue;
                        }
                        transaction.rollback();
                    }
                    catch (Exception e3) {
                        firstException = e3;
                        commitFailed22 = true;
                    }
                }
                ems.remove();
                ems.set(null);
                refCounterMaps.set(null);
                refCounterMaps.remove();
                TransactionBeanStorage oldStorage = TransactionBeanStorage.getStorage();
                TransactionBeanStorage.resetStorage();
                oldStorage.endAllTransactionScopes();
                break block30;
            }
            TransactionBeanStorage.getStorage().activateTransactionScope(previousTransactionKey);
        }
        this.decrementRefCounter(qualifierKey);
        if (commitFailed22) {
            throw firstException;
        }
        return object;
    }

    private EntityManager resolveEntityManagerForQualifier(Class<? extends Annotation> qualifierClass) {
        Bean<EntityManager> entityManagerBean = this.resolveEntityManagerBean(qualifierClass);
        if (entityManagerBean == null) {
            return null;
        }
        return (EntityManager)this.beanManager.getReference(entityManagerBean, EntityManager.class, this.beanManager.createCreationalContext(entityManagerBean));
    }

    private void storeEntityManagerForQualifier(String qualifierKey, EntityManager entityManager) {
        if (ems.get() == null) {
            ems.set(new HashMap());
        }
        ems.get().put(qualifierKey, entityManager);
    }

    protected Exception prepareException(Exception e) {
        return e;
    }

    private boolean isOutermostInterceptor() {
        HashMap<String, AtomicInteger> refCounterMap = refCounterMaps.get();
        return refCounterMap == null || refCounterMap.size() == 1 && refCounterMap.values().iterator().next().get() == 1;
    }

    private int incrementRefCounter(String qualifierKey) {
        AtomicInteger refCounter;
        HashMap<String, AtomicInteger> refCounterMap = refCounterMaps.get();
        if (refCounterMap == null) {
            refCounterMap = new HashMap();
            refCounterMaps.set(refCounterMap);
        }
        if ((refCounter = refCounterMap.get(qualifierKey)) == null) {
            refCounter = new AtomicInteger(0);
            refCounterMap.put(qualifierKey, refCounter);
        }
        return refCounter.incrementAndGet() - 1;
    }

    private int decrementRefCounter(String qualifierKey) {
        HashMap<String, AtomicInteger> refCounterMap = refCounterMaps.get();
        if (refCounterMap == null) {
            return 0;
        }
        AtomicInteger refCounter = refCounterMap.get(qualifierKey);
        if (refCounter == null) {
            return 0;
        }
        int layer = refCounter.decrementAndGet();
        if (layer == 0) {
            refCounterMap.remove(qualifierKey);
        }
        if (refCounterMap.size() == 0) {
            refCounterMaps.set(null);
            refCounterMaps.remove();
        }
        return layer;
    }

    protected Transactional extractTransactionalAnnotation(InvocationContext context) {
        Transactional transactionalAnnotation = context.getMethod().getAnnotation(Transactional.class);
        if (transactionalAnnotation == null) {
            transactionalAnnotation = context.getTarget().getClass().getAnnotation(Transactional.class);
        }
        if (transactionalAnnotation == null) {
            transactionalAnnotation = context.getTarget().getClass().getSuperclass().getAnnotation(Transactional.class);
        }
        return transactionalAnnotation;
    }

    protected Class<? extends Annotation> getTransactionQualifier(Transactional transactionalAnnotation) {
        Class qualifierClass = Default.class;
        if (transactionalAnnotation != null) {
            qualifierClass = transactionalAnnotation.qualifier();
        }
        return qualifierClass;
    }

    protected Bean<EntityManager> resolveEntityManagerBean(Class<? extends Annotation> qualifierClass) {
        HashSet entityManagerBeans = this.beanManager.getBeans(EntityManager.class, new Annotation[]{new AnyLiteral()});
        if (entityManagerBeans == null) {
            entityManagerBeans = new HashSet();
        }
        for (Bean currentEntityManagerBean : entityManagerBeans) {
            Set foundQualifierAnnotations = currentEntityManagerBean.getQualifiers();
            for (Annotation currentQualifierAnnotation : foundQualifierAnnotations) {
                if (!currentQualifierAnnotation.annotationType().equals(qualifierClass)) continue;
                return currentEntityManagerBean;
            }
        }
        return null;
    }
}

