/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.extensions.validator.trinidad;

import javax.faces.FactoryFinder;
import javax.faces.context.FacesContext;
import javax.faces.event.PhaseEvent;
import javax.faces.event.PhaseId;
import javax.faces.event.PhaseListener;
import javax.faces.render.RenderKit;
import javax.faces.render.RenderKitFactory;
import org.apache.myfaces.extensions.validator.internal.UsageCategory;
import org.apache.myfaces.extensions.validator.internal.UsageInformation;
import org.apache.myfaces.extensions.validator.trinidad.renderkit.ExtValTrinidadRenderKit;

@UsageInformation(value={UsageCategory.INTERNAL})
public class ExtValTrinidadValidationPhaseListener
implements PhaseListener {
    private static final long serialVersionUID = 9109721831864146165L;

    public void afterPhase(PhaseEvent event) {
    }

    public void beforePhase(PhaseEvent event) {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        RenderKitFactory renderKitFactory = this.getRenderKitFactory();
        String renderKitId = this.getRenderKitId(facesContext);
        if (this.isIncompatibleRenderKit(renderKitId)) {
            this.changeRenderKit(facesContext, renderKitFactory, renderKitId);
        }
    }

    private String getRenderKitId(FacesContext facesContext) {
        return facesContext.getViewRoot().getRenderKitId();
    }

    private RenderKitFactory getRenderKitFactory() {
        return (RenderKitFactory)FactoryFinder.getFactory((String)"javax.faces.render.RenderKitFactory");
    }

    private boolean isIncompatibleRenderKit(String renderKitId) {
        return !"EXTVAL_TRINIDAD_RENDERKIT".equals(renderKitId);
    }

    private void changeRenderKit(FacesContext facesContext, RenderKitFactory renderKitFactory, String renderKitId) {
        RenderKit renderKit = renderKitFactory.getRenderKit(FacesContext.getCurrentInstance(), renderKitId);
        renderKitFactory.addRenderKit("EXTVAL_TRINIDAD_RENDERKIT", (RenderKit)new ExtValTrinidadRenderKit(renderKit));
        facesContext.getViewRoot().setRenderKitId("EXTVAL_TRINIDAD_RENDERKIT");
    }

    public PhaseId getPhaseId() {
        return PhaseId.RENDER_RESPONSE;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        return o instanceof ExtValTrinidadValidationPhaseListener;
    }

    public int hashCode() {
        return super.hashCode();
    }
}

