/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.test.mock.lifecycle;

import java.util.Iterator;
import java.util.Map;
import javax.el.ValueExpression;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.myfaces.test.mock.lifecycle.RestoreViewSupport;

public class DefaultRestoreViewSupport
implements RestoreViewSupport {
    private static final String JAVAX_SERVLET_INCLUDE_SERVLET_PATH = "javax.servlet.include.servlet_path";
    private static final String JAVAX_SERVLET_INCLUDE_PATH_INFO = "javax.servlet.include.path_info";
    private final Log log = LogFactory.getLog(DefaultRestoreViewSupport.class);

    public void processComponentBinding(FacesContext facesContext, UIComponent component) {
        ValueExpression binding = component.getValueExpression("binding");
        if (binding != null) {
            binding.setValue(facesContext.getELContext(), (Object)component);
        }
        Iterator iter = component.getFacetsAndChildren();
        while (iter.hasNext()) {
            this.processComponentBinding(facesContext, (UIComponent)iter.next());
        }
    }

    public String calculateViewId(FacesContext facesContext) {
        ExternalContext externalContext = facesContext.getExternalContext();
        Map requestMap = externalContext.getRequestMap();
        String viewId = (String)requestMap.get(JAVAX_SERVLET_INCLUDE_PATH_INFO);
        boolean traceEnabled = this.log.isTraceEnabled();
        if (viewId != null) {
            if (traceEnabled) {
                this.log.trace((Object)("Calculated viewId '" + viewId + "' from request param '" + JAVAX_SERVLET_INCLUDE_PATH_INFO + "'"));
            }
        } else {
            viewId = externalContext.getRequestPathInfo();
            if (viewId != null && traceEnabled) {
                this.log.trace((Object)("Calculated viewId '" + viewId + "' from request path info"));
            }
        }
        if (viewId == null && (viewId = (String)requestMap.get(JAVAX_SERVLET_INCLUDE_SERVLET_PATH)) != null && traceEnabled) {
            this.log.trace((Object)("Calculated viewId '" + viewId + "' from request param '" + JAVAX_SERVLET_INCLUDE_SERVLET_PATH + "'"));
        }
        if (viewId == null && (viewId = externalContext.getRequestServletPath()) != null && traceEnabled) {
            this.log.trace((Object)("Calculated viewId '" + viewId + "' from request servlet path"));
        }
        if (viewId == null) {
            throw new FacesException("Could not determine view id.");
        }
        return viewId;
    }

    public boolean isPostback(FacesContext facesContext) {
        return true;
    }
}

