/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.internal.layout;

public final class MathUtils {
    public static final double EPSILON = 1.0E-7;

    private MathUtils() {
    }

    public static void adjustRemainders(double[] list, double biasParameter) {
        double bias = biasParameter;
        for (double ignored : list) {
            double lastBias = bias < 0.0 ? MathUtils.findAndAdjustMaxRemainder(list) : MathUtils.findAndAdjustMinRemainder(list);
            if (MathUtils.isZero(lastBias)) break;
            bias += lastBias;
        }
        assert (MathUtils.isZero(bias));
    }

    public static double findAndAdjustMaxRemainder(double[] list) {
        double max = 0.0;
        Integer indexOfMax = null;
        for (int i = 0; i < list.length; ++i) {
            double remainder = MathUtils.remainder(list[i]);
            if (!(remainder > max + 1.0E-7)) continue;
            max = remainder;
            indexOfMax = i;
        }
        if (indexOfMax != null) {
            int n = indexOfMax;
            list[n] = list[n] + (1.0 - max);
            return 1.0 - max;
        }
        return 0.0;
    }

    public static double findAndAdjustMinRemainder(double[] list) {
        double min = 1.0;
        Integer indexOfMin = null;
        for (int i = 0; i < list.length; ++i) {
            double remainder = MathUtils.remainder(list[i]);
            if (remainder == 0.0 || !(remainder < min - 1.0E-7)) continue;
            min = remainder;
            indexOfMin = i;
        }
        if (indexOfMin != null) {
            int n = indexOfMin;
            list[n] = list[n] - min;
            return -min;
        }
        return 0.0;
    }

    public static double remainder(double v) {
        return v - Math.floor(v);
    }

    public static boolean isZero(double factor) {
        return Math.abs(factor) < 1.0E-7;
    }

    public static boolean isNotZero(double factor) {
        return Math.abs(factor) >= 1.0E-7;
    }

    public static boolean isInteger(double value) {
        return MathUtils.isZero(value - (double)Math.round(value));
    }

    public static boolean isNotInteger(double value) {
        return MathUtils.isNotZero(value - (double)Math.round(value));
    }
}

