/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package org.apache.myfaces.tobago.event;

import org.apache.myfaces.tobago.internal.component.AbstractUIPopup;
import org.apache.myfaces.tobago.util.ComponentUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import javax.el.ValueExpression;
import javax.faces.component.StateHolder;
import javax.faces.component.UIComponent;
import javax.faces.component.UIComponentBase;
import javax.faces.context.FacesContext;
import javax.faces.event.ActionEvent;


public class ValueExpressionPopupActionListener extends AbstractPopupActionListener implements StateHolder {

  private static final Logger LOG = LoggerFactory.getLogger(ValueExpressionPopupActionListener.class);

  private ValueExpression popupIdExpression;

  public ValueExpressionPopupActionListener(final ValueExpression expression) {
    popupIdExpression = expression;
  }

  /**
   * @deprecated Since 2.0.0, please use the other constructor with explicit type
   */
  @Deprecated
  public ValueExpressionPopupActionListener(final Object expression) {
    popupIdExpression = (ValueExpression) expression;
  }

  /**
   * No-arg constructor used during restoreState
   */
  public ValueExpressionPopupActionListener() {
  }

  @Override
  protected AbstractUIPopup getPopup(final ActionEvent actionEvent) {
    final String id = (String) popupIdExpression.getValue(FacesContext.getCurrentInstance().getELContext());
    final UIComponent popup = ComponentUtils.findComponent(actionEvent.getComponent(), id);
    if (popup instanceof AbstractUIPopup) {
      return (AbstractUIPopup) popup;
    } else {
      LOG.error("Found no popup for \""
          + popupIdExpression.getExpressionString() + "\" := \""
          + id + "\"! Search base componentId : "
          + actionEvent.getComponent().getClientId(FacesContext.getCurrentInstance()));
      return null;
    }
  }

  public boolean isTransient() {
    return false;
  }

  public void restoreState(final FacesContext context, final Object state) {
    final Object[] values = (Object[]) state;
    popupIdExpression = (ValueExpression) UIComponentBase.restoreAttachedState(context, values[0]);
  }

  public Object saveState(final FacesContext context) {
    final Object[] values = new Object[1];
    values[0] = UIComponentBase.saveAttachedState(context, popupIdExpression);
    return values;
  }


  public void setTransient(final boolean newTransientValue) {
    // ignore
  }
}
