/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tomahawk.application.jsp;

import java.io.IOException;
import java.util.List;
import java.util.Locale;
import javax.faces.FacesException;
import javax.faces.application.ViewHandler;
import javax.faces.component.UIViewRoot;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.myfaces.shared_tomahawk.webapp.webxml.ServletMapping;
import org.apache.myfaces.shared_tomahawk.webapp.webxml.WebXml;
import org.apache.tiles.TilesContainer;
import org.apache.tiles.TilesException;
import org.apache.tiles.access.TilesAccess;
import org.apache.tiles.factory.TilesContainerFactory;

public class JspTilesTwoViewHandlerImpl
extends ViewHandler {
    private ViewHandler _viewHandler;
    private static final Log log = LogFactory.getLog((Class)JspTilesTwoViewHandlerImpl.class);
    private static final String TILES_DEF_EXT = ".tiles";
    private String tilesExtension = ".tiles";

    public JspTilesTwoViewHandlerImpl(ViewHandler viewHandler) {
        this._viewHandler = viewHandler;
    }

    private void initContainer(ExternalContext context) {
        if (TilesAccess.getContainer((Object)context.getContext()) == null) {
            try {
                TilesContainerFactory factory = TilesContainerFactory.getFactory((Object)context.getContext());
                TilesContainer container = factory.createTilesContainer(context.getContext());
                TilesAccess.setContainer((Object)context.getContext(), (TilesContainer)container);
            }
            catch (Exception e) {
                throw new FacesException("Error reading tiles definitions : " + e.getMessage(), (Throwable)e);
            }
        }
    }

    public void renderView(FacesContext facesContext, UIViewRoot viewToRender) throws IOException, FacesException {
        if (viewToRender == null) {
            log.fatal((Object)"viewToRender must not be null");
            throw new NullPointerException("viewToRender must not be null");
        }
        ExternalContext externalContext = facesContext.getExternalContext();
        String viewId = this.deriveViewId(externalContext, viewToRender.getViewId());
        if (viewId == null) {
            this._viewHandler.renderView(facesContext, viewToRender);
            return;
        }
        this.initContainer(externalContext);
        String tilesId = this.deriveTileFromViewId(viewId);
        TilesContainer container = TilesAccess.getContainer((Object)externalContext.getContext());
        Object[] requestObjects = new Object[]{externalContext.getRequest(), externalContext.getResponse()};
        if (container.isValidDefinition(tilesId, requestObjects)) {
            this.setViewId(viewToRender, viewId, facesContext);
            this.renderTilesView(externalContext, requestObjects, container, viewToRender, viewId, tilesId);
        } else {
            this._viewHandler.renderView(facesContext, viewToRender);
        }
    }

    private void renderTilesView(ExternalContext externalContext, Object[] requestObjects, TilesContainer container, UIViewRoot viewToRender, String viewId, String tilesId) {
        this.handleCharacterEncoding(viewId, externalContext, viewToRender);
        container.startContext(requestObjects);
        try {
            container.render(tilesId, requestObjects);
        }
        catch (TilesException e) {
            throw new FacesException((Throwable)e);
        }
        finally {
            container.endContext(requestObjects);
        }
        this.handleCharacterEncodingPostDispatch(externalContext);
    }

    private void setViewId(UIViewRoot viewToRender, String viewId, FacesContext facesContext) {
        viewToRender.setViewId(viewId);
        if (facesContext.getViewRoot() != null) {
            facesContext.getViewRoot().setViewId(viewId);
        }
    }

    private String deriveTileFromViewId(String viewId) {
        String tilesId = viewId;
        int idx = tilesId.lastIndexOf(46);
        tilesId = idx > 0 ? tilesId.substring(0, idx) + this.tilesExtension : tilesId + this.tilesExtension;
        return tilesId;
    }

    private String deriveViewId(ExternalContext externalContext, String viewId) {
        String suffix;
        ServletMapping servletMapping = JspTilesTwoViewHandlerImpl.getServletMapping(externalContext);
        String defaultSuffix = externalContext.getInitParameter("javax.faces.DEFAULT_SUFFIX");
        String string = suffix = defaultSuffix != null ? defaultSuffix : ".jsp";
        if (servletMapping.isExtensionMapping()) {
            if (!viewId.endsWith(suffix)) {
                int dot = viewId.lastIndexOf(46);
                if (dot == -1) {
                    if (log.isTraceEnabled()) {
                        log.trace((Object)("Current viewId has no extension, appending default suffix " + suffix));
                    }
                    return viewId + suffix;
                }
                if (log.isTraceEnabled()) {
                    log.trace((Object)("Replacing extension of current viewId by suffix " + suffix));
                }
                return viewId.substring(0, dot) + suffix;
            }
            return viewId;
        }
        if (!viewId.endsWith(suffix)) {
            return null;
        }
        return viewId;
    }

    private void handleCharacterEncodingPostDispatch(ExternalContext externalContext) {
        if (externalContext.getRequest() instanceof HttpServletRequest) {
            HttpServletResponse response = (HttpServletResponse)externalContext.getResponse();
            HttpServletRequest request = (HttpServletRequest)externalContext.getRequest();
            HttpSession session = request.getSession(false);
            if (session != null) {
                session.setAttribute("javax.faces.request.charset", (Object)response.getCharacterEncoding());
            }
        }
    }

    private void handleCharacterEncoding(String viewId, ExternalContext externalContext, UIViewRoot viewToRender) {
        if (log.isTraceEnabled()) {
            log.trace((Object)("Dispatching to " + viewId));
        }
        if (externalContext.getResponse() instanceof ServletResponse) {
            ServletResponse response = (ServletResponse)externalContext.getResponse();
            response.setLocale(viewToRender.getLocale());
        }
    }

    private static ServletMapping getServletMapping(ExternalContext externalContext) {
        String servletPath = externalContext.getRequestServletPath();
        String requestPathInfo = externalContext.getRequestPathInfo();
        WebXml webxml = WebXml.getWebXml(externalContext);
        List mappings = webxml.getFacesServletMappings();
        boolean isExtensionMapping = requestPathInfo == null;
        int size = mappings.size();
        for (int i = 0; i < size; ++i) {
            String extension;
            ServletMapping servletMapping = (ServletMapping)mappings.get(i);
            if (servletMapping.isExtensionMapping() != isExtensionMapping) continue;
            String urlpattern = servletMapping.getUrlPattern();
            if (!(isExtensionMapping ? servletPath.endsWith(extension = urlpattern.substring(1, urlpattern.length())) : servletPath.equals(urlpattern = urlpattern.substring(0, urlpattern.length() - 2)))) continue;
            return servletMapping;
        }
        log.error((Object)("could not find pathMapping for servletPath = " + servletPath + " requestPathInfo = " + requestPathInfo));
        throw new IllegalArgumentException("could not find pathMapping for servletPath = " + servletPath + " requestPathInfo = " + requestPathInfo);
    }

    public Locale calculateLocale(FacesContext context) {
        return this._viewHandler.calculateLocale(context);
    }

    public String calculateRenderKitId(FacesContext context) {
        return this._viewHandler.calculateRenderKitId(context);
    }

    public UIViewRoot createView(FacesContext context, String viewId) {
        return this._viewHandler.createView(context, viewId);
    }

    public String getActionURL(FacesContext context, String viewId) {
        return this._viewHandler.getActionURL(context, viewId);
    }

    public String getResourceURL(FacesContext context, String path) {
        return this._viewHandler.getResourceURL(context, path);
    }

    public UIViewRoot restoreView(FacesContext context, String viewId) {
        return this._viewHandler.restoreView(context, viewId);
    }

    public void writeState(FacesContext context) throws IOException {
        this._viewHandler.writeState(context);
    }
}

