/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.renderkit.core.xhtml;

import java.io.IOException;
import java.util.List;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.apache.myfaces.trinidad.bean.FacesBean;
import org.apache.myfaces.trinidad.bean.PropertyKey;
import org.apache.myfaces.trinidad.component.core.layout.CorePanelHeader;
import org.apache.myfaces.trinidad.context.RenderingContext;
import org.apache.myfaces.trinidad.skin.Icon;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.OutputUtils;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.XhtmlConstants;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.XhtmlRenderer;

public class PanelHeaderRenderer
extends XhtmlRenderer {
    private PropertyKey _sizeKey;
    private PropertyKey _messageTypeKey;
    private PropertyKey _textKey;
    private PropertyKey _iconKey;
    public static final Object HEADER_NEST_LEVEL = new Object();
    public static final Object HEADER_SIZE = new Object();
    private static final String _INFORMATION_KEY = "af_panelHeader.INFORMATION";
    private static final String _WARNING_KEY = "af_panelHeader.WARNING";
    private static final String _ERROR_KEY = "af_panelHeader.ERROR";
    private static final String _CONFIRMATION_KEY = "af_panelHeader.CONFIRMATION";
    private static final String _PROCESSING_KEY = "af_panelHeader.PROCESSING";

    public PanelHeaderRenderer() {
        this(CorePanelHeader.TYPE);
    }

    protected PanelHeaderRenderer(FacesBean.Type type) {
        super(type);
    }

    protected void findTypeConstants(FacesBean.Type type) {
        super.findTypeConstants(type);
        this._textKey = type.findKey("text");
        this._iconKey = type.findKey("icon");
        this._sizeKey = type.findKey("size");
        this._messageTypeKey = type.findKey("messageType");
    }

    public boolean getRendersChildren() {
        return true;
    }

    protected void encodeAll(FacesContext context, RenderingContext arc, UIComponent component, FacesBean bean) throws IOException {
        boolean nesting;
        Number oldSize = PanelHeaderRenderer.getContextHeaderSize(arc, null);
        int nestLevel = PanelHeaderRenderer.getHeaderNestLevel(arc);
        int size = this._getAndStoreSize(arc, bean);
        String messageType = this.getMessageType(bean);
        String text = this.getText(arc, bean, messageType);
        List<String> headerElementList = XhtmlConstants.HEADER_ELEMENTS;
        String headerElement = headerElementList.get(Math.min(size, headerElementList.size() - 1));
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("div", component);
        this.renderId(context, component);
        this.renderAllAttributes(context, arc, bean);
        boolean bl = nesting = nestLevel > 0 && !Boolean.FALSE.equals(arc.getSkin().getProperty((Object)"af|panelHeader-tr-indent-content"));
        if (nesting) {
            PanelHeaderRenderer.renderStyleClass((FacesContext)context, (RenderingContext)arc, (String)"p_OraHeaderNest");
        }
        writer.startElement(headerElement, null);
        PanelHeaderRenderer.renderStyleClass((FacesContext)context, (RenderingContext)arc, (String)"af|panelHeader");
        this.renderIcon(context, arc, component, bean, messageType);
        boolean isError = "error".equals(messageType);
        if (isError) {
            writer.startElement("span", null);
            PanelHeaderRenderer.renderStyleClass((FacesContext)context, (RenderingContext)arc, (String)"af|panelHeader::error");
        }
        if (text != null) {
            writer.writeText((Object)text, "text");
        }
        if (isError) {
            writer.endElement("span");
        }
        writer.endElement(headerElement);
        PanelHeaderRenderer.incrementHeaderNestLevel(arc);
        if (this.shouldRenderChildren(bean)) {
            this.encodeAllChildren(context, component);
        }
        PanelHeaderRenderer.decrementHeaderNestLevel(arc);
        writer.endElement("div");
        if (nesting && PanelHeaderRenderer.isIE((RenderingContext)arc)) {
            writer.startElement("div", component);
            writer.writeAttribute("style", (Object)"clear:both", null);
            writer.endElement("div");
        }
        PanelHeaderRenderer.setContextHeaderSize(arc, oldSize);
    }

    protected void renderIcon(FacesContext context, RenderingContext arc, UIComponent component, FacesBean bean, String messageType) throws IOException {
        if (messageType != null && !"none".equals(messageType)) {
            Icon icon;
            String iconName = this.getMessageIconName(messageType);
            if (iconName != null && (icon = arc.getIcon(iconName)) != null) {
                OutputUtils.renderIcon(context, arc, icon, "", null);
            }
        } else {
            String iconUri = this.getIconUri(bean);
            if (iconUri != null) {
                ResponseWriter writer = context.getResponseWriter();
                writer.startElement("img", null);
                OutputUtils.renderAltAndTooltipForImage(context, arc, "");
                PanelHeaderRenderer.renderStyleClass((FacesContext)context, (RenderingContext)arc, (String)"af|panelHeader::icon-style");
                this.renderEncodedResourceURI(context, "src", iconUri);
                writer.endElement("img");
            }
        }
    }

    protected String getText(RenderingContext arc, FacesBean bean, String messageType) {
        String text = PanelHeaderRenderer.toString((Object)bean.getProperty(this._textKey));
        if (text != null) {
            return text;
        }
        if (messageType == null) {
            return null;
        }
        String key = null;
        if ("error".equals(messageType)) {
            key = _ERROR_KEY;
        } else if ("warning".equals(messageType)) {
            key = _WARNING_KEY;
        } else if ("info".equals(messageType)) {
            key = _INFORMATION_KEY;
        } else if ("confirmation".equals(messageType)) {
            key = _CONFIRMATION_KEY;
        } else if ("processing".equals(messageType)) {
            key = _PROCESSING_KEY;
        } else {
            return null;
        }
        return arc.getTranslatedString(key);
    }

    protected String getIconUri(FacesBean bean) {
        if (this._iconKey == null) {
            return null;
        }
        return PanelHeaderRenderer.toResourceUri((FacesContext)FacesContext.getCurrentInstance(), (Object)bean.getProperty(this._iconKey));
    }

    protected Number getSize(FacesBean bean) {
        if (this._sizeKey == null) {
            return null;
        }
        return (Number)bean.getProperty(this._sizeKey);
    }

    protected String getMessageType(FacesBean bean) {
        if (this._messageTypeKey == null) {
            return null;
        }
        return PanelHeaderRenderer.toString((Object)bean.getProperty(this._messageTypeKey));
    }

    protected boolean shouldRenderChildren(FacesBean bean) {
        return true;
    }

    protected static Number getContextHeaderSize(RenderingContext arc, Number defaultValue) {
        Number number = (Number)arc.getProperties().get(HEADER_SIZE);
        if (number == null) {
            number = defaultValue;
        }
        return number;
    }

    protected static void setContextHeaderSize(RenderingContext arc, Number size) {
        arc.getProperties().put(HEADER_SIZE, size);
    }

    protected static int getHeaderNestLevel(RenderingContext arc) {
        Number n = (Number)arc.getProperties().get(HEADER_NEST_LEVEL);
        if (n == null) {
            return 0;
        }
        return n.intValue();
    }

    protected static void incrementHeaderNestLevel(RenderingContext arc) throws IOException {
        arc.getProperties().put(HEADER_NEST_LEVEL, PanelHeaderRenderer.getHeaderNestLevel(arc) + 1);
    }

    protected static void decrementHeaderNestLevel(RenderingContext arc) throws IOException {
        int headerNestLevel = PanelHeaderRenderer.getHeaderNestLevel(arc);
        assert (headerNestLevel > 0) : "cannot decrement header nest level";
        arc.getProperties().put(HEADER_NEST_LEVEL, headerNestLevel - 1);
    }

    protected String getMessageIconName(String messageType) {
        String iconName = null;
        if ("error".equals(messageType)) {
            iconName = "af|panelHeader::error-icon";
        } else if ("warning".equals(messageType)) {
            iconName = "af|panelHeader::warning-icon";
        } else if ("info".equals(messageType)) {
            iconName = "af|panelHeader::info-icon";
        } else if ("confirmation".equals(messageType)) {
            iconName = "af|panelHeader::confirmation-icon";
        } else if ("processing".equals(messageType)) {
            iconName = "af|panelHeader::processing-icon";
        }
        assert (iconName != null || "none".equals(messageType));
        return iconName;
    }

    private int _getAndStoreSize(RenderingContext arc, FacesBean bean) {
        Number sizeNumber = this.getSize(bean);
        if (sizeNumber != null && sizeNumber.intValue() >= 0) {
            PanelHeaderRenderer.setContextHeaderSize(arc, sizeNumber);
            return sizeNumber.intValue();
        }
        sizeNumber = PanelHeaderRenderer.getContextHeaderSize(arc, null);
        int size = sizeNumber == null ? 0 : sizeNumber.intValue() + 1;
        PanelHeaderRenderer.setContextHeaderSize(arc, size);
        return size;
    }
}

