/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cairo;

import io.questdb.cairo.AbstractIntervalDataFrameCursor;
import io.questdb.cairo.BinarySearch;
import io.questdb.cairo.TableReader;
import io.questdb.cairo.sql.DataFrame;
import io.questdb.cairo.vm.api.MemoryR;
import io.questdb.griffin.model.RuntimeIntrinsicIntervalModel;

public class IntervalFwdDataFrameCursor
extends AbstractIntervalDataFrameCursor {
    public IntervalFwdDataFrameCursor(RuntimeIntrinsicIntervalModel intervals, int timestampIndex) {
        super(intervals, timestampIndex);
    }

    @Override
    public DataFrame next() {
        while (this.intervalsLo < this.intervalsHi && this.partitionLo < this.partitionHi) {
            long rowCount = this.reader.openPartition(this.partitionLo);
            if (rowCount > 0L) {
                long hi;
                MemoryR column = this.reader.getColumn(TableReader.getPrimaryColumnIndex(this.reader.getColumnBase(this.partitionLo), this.timestampIndex));
                long intervalLo = this.intervals.getQuick(this.intervalsLo * 2);
                long intervalHi = this.intervals.getQuick(this.intervalsLo * 2 + 1);
                long partitionTimestampLo = column.getLong(0L);
                if (partitionTimestampLo > intervalHi) {
                    ++this.intervalsLo;
                    continue;
                }
                long partitionTimestampHi = column.getLong((rowCount - 1L) * 8L);
                if (partitionTimestampHi < intervalLo) {
                    this.partitionLimit = 0L;
                    ++this.partitionLo;
                    continue;
                }
                long lo = partitionTimestampLo < intervalLo ? BinarySearch.find(column, intervalLo - 1L, this.partitionLimit, rowCount - 1L, 1) + 1L : 0L;
                if (lo < (hi = partitionTimestampHi > intervalHi ? BinarySearch.find(column, intervalHi, lo, rowCount - 1L, 1) + 1L : rowCount)) {
                    this.dataFrame.partitionIndex = this.partitionLo++;
                    this.dataFrame.rowLo = lo;
                    this.dataFrame.rowHi = hi;
                    this.sizeSoFar += hi - lo;
                    if (hi == rowCount) {
                        this.partitionLimit = 0L;
                    } else {
                        this.partitionLimit = hi;
                        ++this.intervalsLo;
                    }
                    return this.dataFrame;
                }
                this.partitionLimit = hi;
                ++this.intervalsLo;
                continue;
            }
            ++this.partitionLo;
        }
        return null;
    }

    @Override
    public void toTop() {
        super.toTop();
        this.partitionLimit = 0L;
    }
}

