/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.rnd;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.cairo.sql.SymbolTableSource;
import io.questdb.griffin.FunctionFactory;
import io.questdb.griffin.PlanSink;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.SymbolFunction;
import io.questdb.griffin.engine.functions.rnd.RndStringListFunctionFactory;
import io.questdb.std.IntList;
import io.questdb.std.ObjList;
import io.questdb.std.Rnd;
import io.questdb.std.Sinkable;

public class RndSymbolListFunctionFactory
implements FunctionFactory {
    @Override
    public String getSignature() {
        return "rnd_symbol(V)";
    }

    @Override
    public Function newInstance(int position, ObjList<Function> args, IntList argPositions, CairoConfiguration configuration, SqlExecutionContext sqlExecutionContext) throws SqlException {
        if (args == null || args.size() == 0) {
            throw SqlException.$(position, "function rnd_symbol expects arguments but has none");
        }
        ObjList<String> symbols = new ObjList<String>(args.size());
        RndStringListFunctionFactory.copyConstants(args, argPositions, symbols);
        return new Func(symbols);
    }

    private static final class Func
    extends SymbolFunction
    implements Function {
        private final int count;
        private final ObjList<String> symbols;
        private Rnd rnd;

        public Func(ObjList<String> symbols) {
            this.symbols = symbols;
            this.count = symbols.size();
        }

        @Override
        public int getInt(Record rec) {
            return this.next();
        }

        @Override
        public CharSequence getSymbol(Record rec) {
            return this.symbols.getQuick(this.next());
        }

        @Override
        public CharSequence getSymbolB(Record rec) {
            return this.getSymbol(rec);
        }

        @Override
        public void init(SymbolTableSource symbolTableSource, SqlExecutionContext executionContext) {
            this.rnd = executionContext.getRandom();
        }

        @Override
        public boolean isSymbolTableStatic() {
            return false;
        }

        @Override
        public void toPlan(PlanSink sink) {
            sink.val("rnd_symbol(").val((Sinkable)this.symbols).val(')');
        }

        @Override
        public CharSequence valueBOf(int key) {
            return this.valueOf(key);
        }

        @Override
        public CharSequence valueOf(int symbolKey) {
            return this.symbols.getQuick(symbolKey);
        }

        private int next() {
            return Math.abs(this.rnd.nextPositiveInt() % this.count);
        }
    }
}

