/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.join;

import io.questdb.cairo.AbstractRecordCursorFactory;
import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.ColumnTypes;
import io.questdb.cairo.RecordSink;
import io.questdb.cairo.map.Map;
import io.questdb.cairo.map.MapFactory;
import io.questdb.cairo.map.MapKey;
import io.questdb.cairo.map.MapRecord;
import io.questdb.cairo.map.MapValue;
import io.questdb.cairo.map.RecordValueSink;
import io.questdb.cairo.sql.Record;
import io.questdb.cairo.sql.RecordCursor;
import io.questdb.cairo.sql.RecordCursorFactory;
import io.questdb.cairo.sql.RecordMetadata;
import io.questdb.griffin.PlanSink;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.join.AbstractJoinCursor;
import io.questdb.griffin.engine.join.JoinRecordMetadata;
import io.questdb.griffin.engine.join.NullRecordFactory;
import io.questdb.griffin.engine.join.OuterJoinRecord;
import io.questdb.griffin.model.JoinContext;
import io.questdb.std.IntList;
import io.questdb.std.Misc;

public class AsOfJoinRecordCursorFactory
extends AbstractRecordCursorFactory {
    private final IntList columnIndex;
    private final AsOfJoinRecordCursor cursor;
    private final JoinContext joinContext;
    private final RecordCursorFactory masterFactory;
    private final RecordSink masterKeySink;
    private final RecordCursorFactory slaveFactory;
    private final RecordSink slaveKeySink;

    public AsOfJoinRecordCursorFactory(CairoConfiguration configuration, RecordMetadata metadata, RecordCursorFactory masterFactory, RecordCursorFactory slaveFactory, ColumnTypes mapKeyTypes, ColumnTypes mapValueTypes, ColumnTypes slaveColumnTypes, RecordSink masterKeySink, RecordSink slaveKeySink, int columnSplit, RecordValueSink slaveValueSink, IntList columnIndex, JoinContext joinContext) {
        super(metadata);
        this.masterFactory = masterFactory;
        this.slaveFactory = slaveFactory;
        Map joinKeyMap = MapFactory.createMap(configuration, mapKeyTypes, mapValueTypes);
        this.masterKeySink = masterKeySink;
        this.slaveKeySink = slaveKeySink;
        this.cursor = new AsOfJoinRecordCursor(columnSplit, joinKeyMap, NullRecordFactory.getInstance(slaveColumnTypes), masterFactory.getMetadata().getTimestampIndex(), slaveFactory.getMetadata().getTimestampIndex(), slaveValueSink);
        this.columnIndex = columnIndex;
        this.joinContext = joinContext;
    }

    @Override
    public RecordCursor getCursor(SqlExecutionContext executionContext) throws SqlException {
        RecordCursor masterCursor = this.masterFactory.getCursor(executionContext);
        RecordCursor slaveCursor = null;
        try {
            slaveCursor = this.slaveFactory.getCursor(executionContext);
            this.cursor.of(masterCursor, slaveCursor);
            return this.cursor;
        }
        catch (Throwable e) {
            Misc.free(slaveCursor);
            Misc.free(masterCursor);
            Misc.free(this.cursor);
            throw e;
        }
    }

    @Override
    public boolean hasDescendingOrder() {
        return this.masterFactory.hasDescendingOrder();
    }

    @Override
    public boolean recordCursorSupportsRandomAccess() {
        return false;
    }

    @Override
    public void toPlan(PlanSink sink) {
        sink.type("AsOf Join");
        sink.attr("condition").val(this.joinContext);
        sink.child(this.masterFactory);
        sink.child(this.slaveFactory);
    }

    @Override
    protected void _close() {
        this.cursor.close();
        ((JoinRecordMetadata)this.getMetadata()).close();
        this.masterFactory.close();
        this.slaveFactory.close();
    }

    private class AsOfJoinRecordCursor
    extends AbstractJoinCursor {
        private final Map joinKeyMap;
        private final int masterTimestampIndex;
        private final OuterJoinRecord record;
        private final int slaveTimestampIndex;
        private final RecordValueSink valueSink;
        private boolean danglingSlaveRecord;
        private boolean isOpen;
        private Record masterRecord;
        private Record slaveRecord;
        private long slaveTimestamp;

        public AsOfJoinRecordCursor(int columnSplit, Map joinKeyMap, Record nullRecord, int masterTimestampIndex, int slaveTimestampIndex, RecordValueSink valueSink) {
            super(columnSplit);
            this.danglingSlaveRecord = false;
            this.slaveTimestamp = Long.MIN_VALUE;
            this.record = new OuterJoinRecord(columnSplit, nullRecord);
            this.joinKeyMap = joinKeyMap;
            this.masterTimestampIndex = masterTimestampIndex;
            this.slaveTimestampIndex = slaveTimestampIndex;
            this.valueSink = valueSink;
            this.isOpen = true;
        }

        @Override
        public void close() {
            if (this.isOpen) {
                this.joinKeyMap.close();
                this.isOpen = false;
                super.close();
            }
        }

        @Override
        public Record getRecord() {
            return this.record;
        }

        @Override
        public boolean hasNext() {
            if (this.masterCursor.hasNext()) {
                MapValue value;
                MapKey key;
                long slaveTimestamp = this.slaveTimestamp;
                long masterTimestamp = this.masterRecord.getTimestamp(this.masterTimestampIndex);
                if (slaveTimestamp <= masterTimestamp) {
                    if (this.danglingSlaveRecord) {
                        key = this.joinKeyMap.withKey();
                        key.put(this.slaveRecord, AsOfJoinRecordCursorFactory.this.slaveKeySink);
                        value = key.createValue();
                        this.valueSink.copy(this.slaveRecord, value);
                        this.danglingSlaveRecord = false;
                    }
                    while (this.slaveCursor.hasNext()) {
                        slaveTimestamp = this.slaveRecord.getTimestamp(this.slaveTimestampIndex);
                        if (slaveTimestamp <= masterTimestamp) {
                            key = this.joinKeyMap.withKey();
                            key.put(this.slaveRecord, AsOfJoinRecordCursorFactory.this.slaveKeySink);
                            value = key.createValue();
                            this.valueSink.copy(this.slaveRecord, value);
                            continue;
                        }
                        this.danglingSlaveRecord = true;
                        break;
                    }
                    this.slaveTimestamp = slaveTimestamp;
                }
                key = this.joinKeyMap.withKey();
                key.put(this.masterRecord, AsOfJoinRecordCursorFactory.this.masterKeySink);
                value = key.findValue();
                if (value != null) {
                    value.setMapRecordHere();
                    this.record.hasSlave(true);
                } else {
                    this.record.hasSlave(false);
                }
                return true;
            }
            return false;
        }

        @Override
        public long size() {
            return this.masterCursor.size();
        }

        @Override
        public void toTop() {
            this.joinKeyMap.clear();
            this.slaveTimestamp = Long.MIN_VALUE;
            this.danglingSlaveRecord = false;
            this.masterCursor.toTop();
            this.slaveCursor.toTop();
        }

        private void of(RecordCursor masterCursor, RecordCursor slaveCursor) {
            if (!this.isOpen) {
                this.joinKeyMap.reopen();
                this.isOpen = true;
            }
            this.slaveTimestamp = Long.MIN_VALUE;
            this.danglingSlaveRecord = false;
            this.masterCursor = masterCursor;
            this.slaveCursor = slaveCursor;
            this.masterRecord = masterCursor.getRecord();
            this.slaveRecord = slaveCursor.getRecord();
            MapRecord mapRecord = this.joinKeyMap.getRecord();
            mapRecord.setSymbolTableResolver(slaveCursor, AsOfJoinRecordCursorFactory.this.columnIndex);
            this.record.of(this.masterRecord, mapRecord);
        }
    }
}

