/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.std;

import io.questdb.cairo.Reopenable;
import io.questdb.log.Log;
import io.questdb.log.LogFactory;
import io.questdb.std.Misc;
import io.questdb.std.Mutable;
import io.questdb.std.Unsafe;
import io.questdb.std.Vect;
import io.questdb.std.str.StringSink;
import java.io.Closeable;

public class DirectLongList
implements Mutable,
Closeable,
Reopenable {
    private static final Log LOG = LogFactory.getLog(DirectLongList.class);
    private final long initialCapacity;
    private final int memoryTag;
    private long address;
    private long capacity;
    private long limit;
    private long pos;
    private long start;

    public DirectLongList(long capacity, int memoryTag) {
        this.memoryTag = memoryTag;
        this.capacity = capacity * 8L;
        this.start = this.pos = (this.address = Unsafe.malloc(this.capacity, memoryTag));
        this.limit = this.pos + this.capacity;
        this.initialCapacity = this.capacity;
    }

    public void add(long x) {
        this.ensureCapacity();
        assert (this.pos < this.limit);
        Unsafe.getUnsafe().putLong(this.pos, x);
        this.pos += 8L;
    }

    public final void add(DirectLongList that) {
        long thatSize = that.pos - that.start;
        if (this.limit - this.pos < thatSize) {
            this.setCapacityBytes(this.capacity + thatSize - (this.limit - this.pos));
        }
        Vect.memcpy(this.pos, that.start, thatSize);
        this.pos += thatSize;
    }

    public long binarySearch(long value, int scanDir) {
        long high = (this.pos - this.start) / 8L;
        if (high > 0L) {
            return Vect.binarySearch64Bit(this.start, value, 0L, high - 1L, scanDir);
        }
        return -1L;
    }

    @Override
    public void clear() {
        this.pos = this.start;
    }

    public void clear(long b) {
        this.zero(b);
        this.pos = this.start;
    }

    @Override
    public void close() {
        if (this.address != 0L) {
            Unsafe.free(this.address, this.capacity, this.memoryTag);
            this.address = 0L;
            this.start = 0L;
            this.limit = 0L;
            this.pos = 0L;
            this.capacity = 0L;
        }
    }

    public long get(long p) {
        return Unsafe.getUnsafe().getLong(this.start + (p << 3));
    }

    public long getAddress() {
        return this.address;
    }

    public long getCapacity() {
        return this.capacity / 8L;
    }

    @Override
    public void reopen() {
        if (this.address == 0L) {
            this.resetCapacity();
        }
    }

    public void resetCapacity() {
        this.setCapacityBytes(this.initialCapacity);
    }

    public long scanSearch(long v, long low, long high) {
        for (long i = low; i < high; ++i) {
            long f = this.get(i);
            if (f == v) {
                return i;
            }
            if (f <= v) continue;
            return -(i + 1L);
        }
        return -(high + 1L);
    }

    public void set(long p, long v) {
        assert (p >= 0L && p <= this.limit - this.start >> 3);
        Unsafe.getUnsafe().putLong(this.start + (p << 3), v);
    }

    public void setCapacity(long capacity) {
        this.setCapacityBytes(capacity * 8L);
    }

    public void setPos(long p) {
        assert (p * 8L <= this.capacity);
        this.pos = this.start + p * 8L;
    }

    public void shrink(long newCapacity) {
        if (newCapacity < this.capacity) {
            this.setCapacityBytes(newCapacity << 3);
        }
    }

    public long size() {
        return (int)((this.pos - this.start) / 8L);
    }

    public void sortAsUnsigned() {
        Vect.sortULongAscInPlace(this.address, this.size());
    }

    public String toString() {
        StringSink sb = Misc.getThreadLocalBuilder();
        sb.put('{');
        int maxElementsToPrint = 1000;
        int n = (int)Math.min(1000L, this.size());
        for (int i = 0; i < n; ++i) {
            if (i > 0) {
                sb.put(',').put(' ');
            }
            sb.put(this.get(i));
        }
        if (this.size() > 1000L) {
            sb.put(", .. ");
        }
        sb.put('}');
        return ((Object)sb).toString();
    }

    public void zero(long v) {
        Vect.memset(this.start, this.pos - this.start, (int)v);
    }

    private void setCapacityBytes(long capacity) {
        if (this.capacity != capacity) {
            long oldCapacity = this.capacity;
            this.capacity = capacity;
            long address = Unsafe.realloc(this.address, oldCapacity, capacity, this.memoryTag);
            this.pos = address + (this.pos - this.start);
            this.address = address;
            this.start = address;
            this.limit = address + capacity;
            LOG.debug().$("resized [old=").$(oldCapacity).$(", new=").$(this.capacity).$(']').$();
        }
    }

    void ensureCapacity() {
        if (this.pos < this.limit) {
            return;
        }
        this.setCapacityBytes(this.capacity * 2L);
    }
}

