/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.controller;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.SecureRandom;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.CipherOutputStream;
import javax.crypto.SecretKey;
import javax.crypto.spec.GCMParameterSpec;
import org.apache.nifi.controller.FileSystemSwapManager;
import org.apache.nifi.repository.encryption.configuration.EncryptedRepositoryType;
import org.apache.nifi.repository.encryption.configuration.kms.StandardRepositoryKeyProviderFactory;
import org.apache.nifi.security.kms.KeyProvider;
import org.apache.nifi.util.NiFiProperties;

public class EncryptedFileSystemSwapManager
extends FileSystemSwapManager {
    private static final String CIPHER_TRANSFORMATION = "AES/GCM/NoPadding";
    private static final int SIZE_IV_AES_BYTES = 16;
    private static final int SIZE_TAG_GCM_BITS = 128;
    private static final SecureRandom secureRandom = new SecureRandom();
    private final SecretKey secretKey;

    public EncryptedFileSystemSwapManager(NiFiProperties nifiProperties) throws GeneralSecurityException {
        super(nifiProperties);
        StandardRepositoryKeyProviderFactory repositoryKeyProviderFactory = new StandardRepositoryKeyProviderFactory();
        KeyProvider keyProvider = repositoryKeyProviderFactory.getKeyProvider(EncryptedRepositoryType.FLOWFILE, nifiProperties);
        String keyId = nifiProperties.getFlowFileRepoEncryptionKeyId();
        this.secretKey = keyProvider.getKey(keyId);
    }

    @Override
    protected InputStream getInputStream(File file) throws IOException {
        FileInputStream fis = new FileInputStream(file);
        try {
            byte[] iv = new byte[16];
            int ivBytesRead = fis.read(iv);
            if (ivBytesRead != 16) {
                throw new IOException(String.format("problem reading IV [expected=%d, actual=%d]", 16, ivBytesRead));
            }
            Cipher cipher = Cipher.getInstance(CIPHER_TRANSFORMATION);
            cipher.init(2, (Key)this.secretKey, new GCMParameterSpec(128, iv));
            return new CipherInputStream(fis, cipher);
        }
        catch (GeneralSecurityException e) {
            throw new IOException(String.format("Preparing Cipher Failed for File [%s]", file.getAbsolutePath()), e);
        }
    }

    @Override
    protected OutputStream getOutputStream(File file) throws IOException {
        byte[] iv = new byte[16];
        secureRandom.nextBytes(iv);
        FileOutputStream fos = new FileOutputStream(file);
        fos.write(iv);
        try {
            Cipher cipher = Cipher.getInstance(CIPHER_TRANSFORMATION);
            cipher.init(1, (Key)this.secretKey, new GCMParameterSpec(128, iv));
            return new CipherOutputStream(fos, cipher);
        }
        catch (GeneralSecurityException e) {
            throw new IOException(String.format("Preparing Cipher Failed for File [%s]", file.getAbsolutePath()), e);
        }
    }
}

