/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.controller.repository;

import java.util.Map;
import java.util.WeakHashMap;
import org.apache.nifi.controller.repository.ActiveProcessSessionFactory;
import org.apache.nifi.processor.ProcessSession;
import org.apache.nifi.processor.ProcessSessionFactory;
import org.apache.nifi.processor.exception.TerminatedTaskException;

public class WeakHashMapProcessSessionFactory
implements ActiveProcessSessionFactory {
    private final ProcessSessionFactory delegate;
    private final Map<ProcessSession, Boolean> sessionMap = new WeakHashMap<ProcessSession, Boolean>();
    private boolean terminated = false;

    public WeakHashMapProcessSessionFactory(ProcessSessionFactory delegate) {
        this.delegate = delegate;
    }

    public synchronized ProcessSession createSession() {
        if (this.terminated) {
            throw new TerminatedTaskException();
        }
        ProcessSession session = this.delegate.createSession();
        this.sessionMap.put(session, Boolean.TRUE);
        return session;
    }

    public synchronized void terminateActiveSessions() {
        this.terminated = true;
        for (ProcessSession session : this.sessionMap.keySet()) {
            try {
                session.rollback();
            }
            catch (TerminatedTaskException terminatedTaskException) {}
        }
        this.sessionMap.clear();
    }
}

