/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.admin.service.transaction.impl;

import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import org.apache.nifi.admin.RepositoryUtils;
import org.apache.nifi.admin.dao.impl.DAOFactoryImpl;
import org.apache.nifi.admin.service.action.AdministrationAction;
import org.apache.nifi.admin.service.transaction.Transaction;
import org.apache.nifi.admin.service.transaction.TransactionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StandardTransaction
implements Transaction {
    private static final Logger logger = LoggerFactory.getLogger(StandardTransaction.class);
    private Connection connection;

    public StandardTransaction(Connection connection) {
        this.connection = connection;
    }

    @Override
    public <T> T execute(AdministrationAction<T> action) {
        if (this.connection == null) {
            throw new IllegalStateException("This transaction is not active.");
        }
        DAOFactoryImpl daoFactory = new DAOFactoryImpl(this.connection);
        return action.execute(daoFactory);
    }

    @Override
    public void commit() throws TransactionException {
        if (this.connection == null) {
            throw new IllegalStateException("No active transaction.");
        }
        try {
            this.connection.commit();
        }
        catch (SQLException sqle) {
            throw new TransactionException(sqle.getMessage());
        }
    }

    @Override
    public void rollback() {
        if (this.connection != null) {
            RepositoryUtils.rollback(this.connection, logger);
        }
    }

    @Override
    public void close() throws IOException {
        if (this.connection != null) {
            RepositoryUtils.closeQuietly(this.connection);
            this.connection = null;
        }
    }
}

