/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.wali;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.apache.nifi.wali.ObjectPool;

public class BlockingQueuePool<T>
implements ObjectPool<T> {
    private final BlockingQueue<T> queue;
    private final Supplier<T> creationFunction;
    private final Predicate<T> reuseCheck;
    private final Consumer<T> returnPreparation;

    public BlockingQueuePool(int maxSize, Supplier<T> creationFunction, Predicate<T> reuseCheck, Consumer<T> returnPreparation) {
        this.queue = new LinkedBlockingQueue<T>(maxSize);
        this.creationFunction = creationFunction;
        this.reuseCheck = reuseCheck;
        this.returnPreparation = returnPreparation;
    }

    @Override
    public T borrowObject() {
        Object existing = this.queue.poll();
        if (existing != null) {
            return (T)existing;
        }
        return this.creationFunction.get();
    }

    @Override
    public void returnObject(T somethingBorrowed) {
        if (this.reuseCheck.test(somethingBorrowed)) {
            this.returnPreparation.accept(somethingBorrowed);
            this.queue.offer(somethingBorrowed);
        }
    }
}

