/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.core.dataStructures;

import java.lang.ref.SoftReference;
import java.util.Arrays;
import jetbrains.exodus.core.dataStructures.ObjectCacheBase;
import jetbrains.exodus.core.dataStructures.hash.HashUtil;
import org.jetbrains.annotations.NotNull;

public abstract class SoftObjectCacheBase<K, V>
extends ObjectCacheBase<K, V> {
    public static final int MIN_SIZE = 16;
    private final int chunkSize;
    private final SoftReference<ObjectCacheBase<K, V>>[] chunks;

    SoftObjectCacheBase(int cacheSize) {
        super(cacheSize);
        if (cacheSize < 16) {
            cacheSize = 16;
        }
        this.chunks = new SoftReference[SoftObjectCacheBase.computeNumberOfChunks(cacheSize)];
        this.chunkSize = cacheSize / this.chunks.length;
        this.clear();
    }

    @Override
    public void clear() {
        Arrays.fill(this.chunks, null);
    }

    @Override
    public final void lock() {
    }

    @Override
    public final void unlock() {
    }

    @Override
    public V tryKey(@NotNull K key) {
        V result;
        this.incAttempts();
        ObjectCacheBase<K, V> chunk = this.getChunk(key, false);
        V v = result = chunk == null ? null : (V)chunk.tryKeyLocked(key);
        if (result != null) {
            this.incHits();
        }
        return result;
    }

    @Override
    public V getObject(@NotNull K key) {
        ObjectCacheBase<K, V> chunk = this.getChunk(key, false);
        if (chunk == null) {
            return null;
        }
        try (ObjectCacheBase.CriticalSection ignored = chunk.newCriticalSection();){
            V v = chunk.getObject(key);
            return v;
        }
    }

    @Override
    public V cacheObject(@NotNull K key, @NotNull V value) {
        ObjectCacheBase<K, V> chunk = this.getChunk(key, true);
        try (ObjectCacheBase.CriticalSection ignored = chunk.newCriticalSection();){
            V v = chunk.cacheObject(key, value);
            return v;
        }
    }

    @Override
    public V remove(@NotNull K key) {
        ObjectCacheBase<K, V> chunk = this.getChunk(key, false);
        if (chunk == null) {
            return null;
        }
        try (ObjectCacheBase.CriticalSection ignored = chunk.newCriticalSection();){
            V v = chunk.remove(key);
            return v;
        }
    }

    @Override
    public int count() {
        throw new UnsupportedOperationException();
    }

    @Override
    public ObjectCacheBase.CriticalSection newCriticalSection() {
        return TRIVIAL_CRITICAL_SECTION;
    }

    static int computeNumberOfChunks(int cacheSize) {
        int result = (int)Math.sqrt(cacheSize);
        while (result * result < cacheSize) {
            ++result;
        }
        return HashUtil.getCeilingPrime(result);
    }

    protected abstract ObjectCacheBase<K, V> newChunk(int var1);

    private ObjectCacheBase<K, V> getChunk(@NotNull K key, boolean create) {
        ObjectCacheBase<K, V> result;
        int hc = key.hashCode();
        int chunkIndex = (hc + (hc >> 31) & Integer.MAX_VALUE) % this.chunks.length;
        SoftReference<ObjectCacheBase<K, V>> ref = this.chunks[chunkIndex];
        ObjectCacheBase<K, V> objectCacheBase = result = ref == null ? null : ref.get();
        if (result == null && create) {
            result = this.newChunk(this.chunkSize);
            this.chunks[chunkIndex] = new SoftReference<ObjectCacheBase<K, V>>(result);
        }
        return result;
    }
}

