/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.log;

import jetbrains.exodus.InvalidSettingException;
import jetbrains.exodus.core.dataStructures.Pair;
import jetbrains.exodus.crypto.StreamCipherProvider;
import jetbrains.exodus.env.EnvironmentConfig;
import jetbrains.exodus.io.DataReader;
import jetbrains.exodus.io.DataReaderWriterProvider;
import jetbrains.exodus.io.DataWriter;
import jetbrains.exodus.io.FileDataReaderWriterProvider;
import jetbrains.exodus.io.WatchingFileDataReaderWriterProvider;
import jetbrains.exodus.io.inMemory.MemoryDataReaderWriterProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LogConfig {
    private static final int DEFAULT_FILE_SIZE = 1024;
    private String location;
    private String readerWriterProvider;
    private DataReaderWriterProvider readerWriterProviderInstance;
    private long fileSize;
    private long lockTimeout;
    private long memoryUsage;
    private int memoryUsagePercentage;
    private DataReader reader;
    private DataWriter writer;
    private boolean isDurableWrite;
    private boolean sharedCache;
    private boolean nonBlockingCache;
    private boolean cacheUseSoftReferences;
    private int cacheGenerationCount;
    private int cacheReadAheadMultiple;
    private int cachePageSize;
    private int cacheOpenFilesCount;
    private boolean cleanDirectoryExpected;
    private boolean clearInvalidLog;
    private boolean warmup;
    private long syncPeriod;
    private boolean fullFileReadonly;
    private StreamCipherProvider cipherProvider;
    private byte[] cipherKey;
    private long cipherBasicIV;
    private boolean lockIgnored;
    private boolean useV1Format = EnvironmentConfig.DEFAULT.getUseVersion1Format();

    public LogConfig setLocation(@NotNull String location) {
        this.location = location;
        return this;
    }

    public LogConfig setReaderWriterProvider(@NotNull String provider) {
        this.readerWriterProvider = provider;
        return this;
    }

    public long getFileSize() {
        if (this.fileSize == 0L) {
            this.fileSize = 1024L;
        }
        return this.fileSize;
    }

    public LogConfig setFileSize(long fileSize) {
        this.fileSize = fileSize;
        return this;
    }

    public long getLockTimeout() {
        return this.lockTimeout;
    }

    public LogConfig setLockTimeout(long lockTimeout) {
        this.lockTimeout = lockTimeout;
        return this;
    }

    public boolean isLockIgnored() {
        return this.lockIgnored;
    }

    public void setLockIgnored(boolean lockIgnored) {
        this.lockIgnored = lockIgnored;
    }

    public long getMemoryUsage() {
        return this.memoryUsage;
    }

    public LogConfig setMemoryUsage(long memUsage) {
        this.memoryUsage = memUsage;
        return this;
    }

    public int getMemoryUsagePercentage() {
        if (this.memoryUsagePercentage == 0) {
            this.memoryUsagePercentage = 50;
        }
        return this.memoryUsagePercentage;
    }

    public LogConfig setMemoryUsagePercentage(int memoryUsagePercentage) {
        this.memoryUsagePercentage = memoryUsagePercentage;
        return this;
    }

    public DataReader getReader() {
        if (this.reader == null) {
            this.createReaderWriter();
        }
        return this.reader;
    }

    @Deprecated
    public LogConfig setReader(@NotNull DataReader reader) {
        this.reader = reader;
        return this;
    }

    public DataWriter getWriter() {
        if (this.writer == null) {
            this.createReaderWriter();
        }
        return this.writer;
    }

    @Deprecated
    public LogConfig setWriter(@NotNull DataWriter writer) {
        this.writer = writer;
        return this;
    }

    public LogConfig setReaderWriter(@NotNull DataReader reader, @NotNull DataWriter writer) {
        this.reader = reader;
        this.writer = writer;
        return this;
    }

    public boolean isDurableWrite() {
        return this.isDurableWrite;
    }

    public LogConfig setDurableWrite(boolean durableWrite) {
        this.isDurableWrite = durableWrite;
        return this;
    }

    public boolean isSharedCache() {
        return this.sharedCache;
    }

    public LogConfig setSharedCache(boolean sharedCache) {
        this.sharedCache = sharedCache;
        return this;
    }

    public boolean isNonBlockingCache() {
        return this.nonBlockingCache;
    }

    public LogConfig setNonBlockingCache(boolean nonBlockingCache) {
        this.nonBlockingCache = nonBlockingCache;
        return this;
    }

    public boolean getCacheUseSoftReferences() {
        return this.cacheUseSoftReferences;
    }

    public LogConfig setCacheUseSoftReferences(boolean cacheUseSoftReferences) {
        this.cacheUseSoftReferences = cacheUseSoftReferences;
        return this;
    }

    public int getCacheGenerationCount() {
        if (this.cacheGenerationCount == 0) {
            this.cacheGenerationCount = EnvironmentConfig.DEFAULT.getLogCacheGenerationCount();
        }
        return this.cacheGenerationCount;
    }

    public LogConfig setCacheGenerationCount(int cacheGenerationCount) {
        this.cacheGenerationCount = cacheGenerationCount;
        return this;
    }

    public int getCacheReadAheadMultiple() {
        if (this.cacheReadAheadMultiple == 0) {
            this.cacheReadAheadMultiple = EnvironmentConfig.DEFAULT.getLogCacheReadAheadMultiple();
        }
        return this.cacheReadAheadMultiple;
    }

    public void setCacheReadAheadMultiple(int cacheReadAheadMultiple) {
        this.cacheReadAheadMultiple = cacheReadAheadMultiple;
    }

    public int getCachePageSize() {
        if (this.cachePageSize == 0) {
            this.cachePageSize = 1024;
        }
        return this.cachePageSize;
    }

    public LogConfig setCachePageSize(int cachePageSize) {
        this.cachePageSize = cachePageSize;
        return this;
    }

    public int getCacheOpenFilesCount() {
        if (this.cacheOpenFilesCount == 0) {
            this.cacheOpenFilesCount = 16;
        }
        return this.cacheOpenFilesCount;
    }

    public LogConfig setCacheOpenFilesCount(int cacheOpenFilesCount) {
        this.cacheOpenFilesCount = cacheOpenFilesCount;
        return this;
    }

    public boolean isCleanDirectoryExpected() {
        return this.cleanDirectoryExpected;
    }

    public LogConfig setCleanDirectoryExpected(boolean cleanDirectoryExpected) {
        this.cleanDirectoryExpected = cleanDirectoryExpected;
        return this;
    }

    public boolean isClearInvalidLog() {
        return this.clearInvalidLog;
    }

    public LogConfig setClearInvalidLog(boolean clearInvalidLog) {
        this.clearInvalidLog = clearInvalidLog;
        return this;
    }

    public boolean isWarmup() {
        return this.warmup;
    }

    public LogConfig setWarmup(boolean warmup2) {
        this.warmup = warmup2;
        return this;
    }

    public long getSyncPeriod() {
        if (this.syncPeriod == 0L) {
            this.syncPeriod = EnvironmentConfig.DEFAULT.getLogSyncPeriod();
        }
        return this.syncPeriod;
    }

    public LogConfig setSyncPeriod(long syncPeriod) {
        this.syncPeriod = syncPeriod;
        return this;
    }

    public boolean isFullFileReadonly() {
        return this.fullFileReadonly;
    }

    public LogConfig setFullFileReadonly(boolean fullFileReadonly) {
        this.fullFileReadonly = fullFileReadonly;
        return this;
    }

    public StreamCipherProvider getCipherProvider() {
        return this.cipherProvider;
    }

    public LogConfig setCipherProvider(StreamCipherProvider cipherProvider) {
        this.cipherProvider = cipherProvider;
        return this;
    }

    public byte[] getCipherKey() {
        return this.cipherKey;
    }

    public LogConfig setCipherKey(byte[] cipherKey) {
        this.cipherKey = cipherKey;
        return this;
    }

    public long getCipherBasicIV() {
        return this.cipherBasicIV;
    }

    public LogConfig setCipherBasicIV(long basicIV) {
        this.cipherBasicIV = basicIV;
        return this;
    }

    @Nullable
    public DataReaderWriterProvider getReaderWriterProvider() {
        if (this.readerWriterProviderInstance == null && this.readerWriterProvider != null) {
            this.readerWriterProviderInstance = DataReaderWriterProvider.getProvider((String)this.readerWriterProvider);
            if (this.readerWriterProviderInstance == null) {
                switch (this.readerWriterProvider) {
                    case "jetbrains.exodus.io.FileDataReaderWriterProvider": {
                        this.readerWriterProviderInstance = new FileDataReaderWriterProvider();
                        break;
                    }
                    case "jetbrains.exodus.io.WatchingFileDataReaderWriterProvider": {
                        this.readerWriterProviderInstance = new WatchingFileDataReaderWriterProvider();
                        break;
                    }
                    case "jetbrains.exodus.io.MemoryDataReaderWriterProvider": {
                        this.readerWriterProviderInstance = new MemoryDataReaderWriterProvider();
                        break;
                    }
                    default: {
                        throw new InvalidSettingException("Unknown DataReaderWriterProvider: " + this.readerWriterProvider);
                    }
                }
            }
        }
        return this.readerWriterProviderInstance;
    }

    public boolean isReadonlyReaderWriterProvider() {
        DataReaderWriterProvider provider = this.getReaderWriterProvider();
        return provider != null && provider.isReadonly();
    }

    public boolean useV1Format() {
        return this.useV1Format;
    }

    public void setUseV1Format(boolean useV1Format) {
        this.useV1Format = useV1Format;
    }

    public static LogConfig create(@NotNull DataReader reader, @NotNull DataWriter writer) {
        return new LogConfig().setReaderWriter(reader, writer);
    }

    private void createReaderWriter() {
        String location = this.location;
        if (location == null) {
            throw new InvalidSettingException("Location for DataReader and DataWriter is not specified");
        }
        Pair readerWriter = this.getReaderWriterProvider().newReaderWriter(location);
        this.reader = (DataReader)readerWriter.getFirst();
        this.writer = (DataWriter)readerWriter.getSecond();
    }
}

