/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.tree.btree;

import java.io.PrintStream;
import jetbrains.exodus.ByteIterable;
import jetbrains.exodus.log.ByteIterableWithAddress;
import jetbrains.exodus.log.CompressedUnsignedLongByteIterable;
import jetbrains.exodus.tree.Dumpable;
import jetbrains.exodus.tree.btree.BTreeBase;
import jetbrains.exodus.tree.btree.BTreeMutable;
import jetbrains.exodus.tree.btree.BTreeReclaimTraverser;
import jetbrains.exodus.tree.btree.BTreeTraverser;
import jetbrains.exodus.tree.btree.BTreeTraverserDup;
import jetbrains.exodus.tree.btree.BaseLeafNode;
import jetbrains.exodus.tree.btree.BasePage;
import jetbrains.exodus.tree.btree.BasePageImmutable;
import jetbrains.exodus.tree.btree.BasePageMutable;
import jetbrains.exodus.tree.btree.BottomPageMutable;
import jetbrains.exodus.tree.btree.ILeafNode;
import jetbrains.exodus.tree.btree.TreePos;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class BottomPage
extends BasePageImmutable {
    BottomPage(@NotNull BTreeBase tree) {
        super(tree);
    }

    protected BottomPage(@NotNull BTreeBase tree, @NotNull ByteIterableWithAddress data) {
        super(tree, data);
    }

    protected BottomPage(@NotNull BTreeBase tree, @NotNull ByteIterableWithAddress data, int size) {
        super(tree, data, size);
    }

    @Override
    protected boolean isBottom() {
        return true;
    }

    @Override
    public long getChildAddress(int index) {
        return this.getKeyAddress(index);
    }

    @Override
    protected long getBottomPagesCount() {
        return 1L;
    }

    @Override
    public ILeafNode get(@NotNull ByteIterable key) {
        return BottomPage.get(key, this);
    }

    @Override
    public ILeafNode find(@NotNull BTreeTraverser stack, int depth, @NotNull ByteIterable key, @Nullable ByteIterable value, boolean equalOrNext) {
        return BottomPage.find(stack, depth, key, value, equalOrNext, this);
    }

    @Override
    @NotNull
    protected BasePageMutable getMutableCopy(BTreeMutable treeMutable) {
        return new BottomPageMutable(treeMutable, this);
    }

    @Override
    public boolean keyExists(@NotNull ByteIterable key) {
        return BottomPage.keyExists(key, this);
    }

    @Override
    public boolean exists(@NotNull ByteIterable key, @NotNull ByteIterable value) {
        return BottomPage.exists(key, value, this);
    }

    @Override
    public boolean childExists(@NotNull ByteIterable key, long pageAddress) {
        return false;
    }

    public String toString() {
        return "Bottom [" + this.size + "] @ " + (this.getDataAddress() - (long)CompressedUnsignedLongByteIterable.getIterable(this.size << 1).getLength() - 1L);
    }

    @Override
    public void dump(PrintStream out, int level, Dumpable.ToString renderer) {
        BottomPage.dump(out, level, renderer, this);
    }

    protected void reclaim(ByteIterable keyIterable, @NotNull BTreeReclaimTraverser context) {
        int index;
        block9: {
            BasePage node = context.currentNode;
            if (node.isBottom()) {
                if (node.getDataAddress() == this.getDataAddress()) {
                    BottomPage.doReclaim(context);
                    return;
                }
                if (node.size > 0 && node.getMinKey().compareKeyTo(keyIterable) == 0) {
                    return;
                }
            }
            if (context.canMoveUp()) {
                block8: {
                    do {
                        context.popAndMutate();
                        context.moveRight();
                        index = context.getNextSibling(keyIterable);
                        if (index >= 0) break block8;
                    } while (context.canMoveUp());
                    context.moveTo(Math.max(-index - 2, 0));
                    break block9;
                }
                context.pushChild(index);
            }
        }
        while (context.canMoveDown()) {
            index = context.getNextSibling(keyIterable);
            if (index < 0) {
                index = Math.max(-index - 2, 0);
            }
            context.pushChild(index);
        }
        if (context.currentNode.getDataAddress() == this.getDataAddress()) {
            BottomPage.doReclaim(context);
        }
    }

    static ILeafNode get(@NotNull ByteIterable key, @NotNull BasePage page) {
        int index = page.binarySearch(key);
        if (index >= 0) {
            return page.getKey(index);
        }
        return null;
    }

    @NotNull
    private static ILeafNode findFirst(@NotNull BTreeTraverser stack, int depth, BasePage page) {
        ILeafNode result;
        if (page.isBottom()) {
            result = page.getMinKey();
            stack.currentNode = page;
            stack.currentPos = 0;
            stack.top = depth;
        } else {
            result = BottomPage.findFirst(stack, depth + 1, page.getChild(0));
            stack.setAt(depth, new TreePos(page, 0));
        }
        return result;
    }

    @Nullable
    static ILeafNode find(@NotNull BTreeTraverser stack, int depth, @NotNull ByteIterable key, @Nullable ByteIterable value, boolean equalOrNext, @NotNull BasePage page) {
        BaseLeafNode ln;
        int index = page.binarySearch(key);
        if (index < 0) {
            if (value == null && equalOrNext) {
                if ((index = -index - 1) >= page.getSize()) {
                    return null;
                }
            } else {
                return null;
            }
        }
        if ((ln = page.getKey(index)).isDup()) {
            ILeafNode dupLeaf;
            BasePage dupRoot = ln.getTree().getRoot();
            if (value != null) {
                dupLeaf = dupRoot.find(stack, depth + 1, value, null, equalOrNext);
                if (dupLeaf == null) {
                    return null;
                }
            } else {
                dupLeaf = BottomPage.findFirst(stack, depth + 1, dupRoot);
            }
            stack.setAt(depth, new TreePos(page, index));
            ((BTreeTraverserDup)stack).inDupTree = true;
            return dupLeaf;
        }
        if (stack.isDup()) {
            ((BTreeTraverserDup)stack).inDupTree = false;
        }
        if (value == null || (equalOrNext ? value.compareTo((Object)ln.getValue()) <= 0 : value.compareTo((Object)ln.getValue()) == 0)) {
            stack.currentNode = page;
            stack.currentPos = index;
            stack.top = depth;
            return ln;
        }
        return null;
    }

    static boolean keyExists(@NotNull ByteIterable key, @NotNull BasePage page) {
        return page.binarySearch(key) >= 0;
    }

    static boolean exists(@NotNull ByteIterable key, @NotNull ByteIterable value, @NotNull BasePage page) {
        ILeafNode ln = page.get(key);
        return ln != null && ln.valueExists(value);
    }

    static void dump(PrintStream out, int level, Dumpable.ToString renderer, BasePage page) {
        BottomPage.indent(out, level);
        out.println(page);
        for (int i = 0; i < page.getSize(); ++i) {
            page.getKey(i).dump(out, level + 1, renderer);
        }
    }
}

