/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.tree.patricia;

import jetbrains.exodus.ExodusException;
import jetbrains.exodus.log.ByteIterableWithAddress;
import jetbrains.exodus.log.ByteIteratorWithAddress;
import jetbrains.exodus.log.CompressedUnsignedLongByteIterable;
import jetbrains.exodus.log.Log;
import jetbrains.exodus.log.RandomAccessLoggable;
import jetbrains.exodus.tree.ITreeCursor;
import jetbrains.exodus.tree.TreeCursor;
import jetbrains.exodus.tree.patricia.ImmutableNode;
import jetbrains.exodus.tree.patricia.PatriciaTraverser;
import jetbrains.exodus.tree.patricia.PatriciaTreeBase;
import jetbrains.exodus.tree.patricia.PatriciaTreeMutable;
import org.jetbrains.annotations.NotNull;

public class PatriciaTree
extends PatriciaTreeBase {
    private final RandomAccessLoggable rootLoggable;
    private final ImmutableNode root;

    public PatriciaTree(@NotNull Log log, long rootAddress, int structureId) {
        super(log, structureId);
        if (rootAddress == -1L) {
            throw new IllegalArgumentException("Can't instantiate nonempty tree with null root address");
        }
        this.rootLoggable = this.getLoggable(rootAddress);
        byte type = this.rootLoggable.getType();
        if (!PatriciaTree.nodeIsRoot(type)) {
            throw new ExodusException("Unexpected root page type: " + type);
        }
        ByteIterableWithAddress data = this.rootLoggable.getData();
        ByteIteratorWithAddress it = data.iterator();
        this.size = CompressedUnsignedLongByteIterable.getLong(it);
        if (PatriciaTree.nodeHasBackReference(type)) {
            long backRef = CompressedUnsignedLongByteIterable.getLong(it);
            this.rememberBackRef(backRef);
        }
        this.root = new ImmutableNode(this.rootLoggable, data.clone((int)(it.getAddress() - data.getDataAddress())));
    }

    @Override
    @NotNull
    public final PatriciaTreeMutable getMutableCopy() {
        return new PatriciaTreeMutable(this.log, this.structureId, this.size, this.getRoot());
    }

    @Override
    public final long getRootAddress() {
        return this.rootLoggable.getAddress();
    }

    @Override
    public final ITreeCursor openCursor() {
        ImmutableNode root = this.getRoot();
        return new TreeCursor(new PatriciaTraverser(this, root), root.hasValue());
    }

    void rememberBackRef(long backRef) {
    }

    @Override
    final ImmutableNode getRoot() {
        return this.root;
    }
}

