/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cairo;

import io.questdb.MessageBus;
import io.questdb.cairo.BitmapIndexWriter;
import io.questdb.cairo.CairoException;
import io.questdb.cairo.ColumnType;
import io.questdb.cairo.O3Utils;
import io.questdb.cairo.TableUtils;
import io.questdb.cairo.TableWriter;
import io.questdb.log.Log;
import io.questdb.log.LogFactory;
import io.questdb.mp.AbstractQueueConsumerJob;
import io.questdb.mp.Sequence;
import io.questdb.std.FilesFacade;
import io.questdb.std.Misc;
import io.questdb.std.Unsafe;
import io.questdb.std.Vect;
import io.questdb.tasks.O3CopyTask;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.Nullable;

public class O3CopyJob
extends AbstractQueueConsumerJob<O3CopyTask> {
    private static final Log LOG = LogFactory.getLog(O3CopyJob.class);

    public O3CopyJob(MessageBus messageBus) {
        super(messageBus.getO3CopyQueue(), messageBus.getO3CopySubSeq());
    }

    public static void copy(AtomicInteger columnCounter, @Nullable AtomicInteger partCounter, int columnType, int blockType, long timestampMergeIndexAddr, long timestampMergeIndexSize, int srcDataFixFd, long srcDataFixAddr, long srcDataFixOffset, long srcDataFixSize, int srcDataVarFd, long srcDataVarAddr, long srcDataVarOffset, long srcDataVarSize, long srcDataLo, long srcDataHi, long srcDataTop, long srcDataMax, long srcOooFixAddr, long srcOooVarAddr, long srcOooLo, long srcOooHi, long srcOooMax, long srcOooPartitionLo, long srcOooPartitionHi, long timestampMin, long timestampMax, long partitionTimestamp, int dstFixFd, long dstFixAddr, long dstFixOffset, long dstFixFileOffset, long dstFixSize, int dstVarFd, long dstVarAddr, long dstVarOffset, long dstVarOffsetEnd, long dstVarAdjust, long dstVarSize, int dstKFd, int dstVFd, long dstIndexOffset, long dstIndexAdjust, int indexBlockCapacity, int srcTimestampFd, long srcTimestampAddr, long srcTimestampSize, boolean partitionMutates, TableWriter tableWriter, BitmapIndexWriter indexWriter) {
        boolean directIoFlag = tableWriter.preferDirectIO();
        LOG.debug().$("o3 copy [blockType=").$(blockType).$(", columnType=").$(columnType).$(", dstFixFd=").$(dstFixFd).$(", dstFixSize=").$(dstFixSize).$(", dstFixOffset=").$(dstFixOffset).$(", dstVarFd=").$(dstVarFd).$(", dstVarSize=").$(dstVarSize).$(", dstVarOffset=").$(dstVarOffset).$(", srcDataLo=").$(srcDataLo).$(", srcDataHi=").$(srcDataHi).$(", srcDataMax=").$(srcDataMax).$(", srcOooLo=").$(srcOooLo).$(", srcOooHi=").$(srcOooHi).$(", srcOooMax=").$(srcOooMax).$(", srcOooPartitionLo=").$(srcOooPartitionLo).$(", srcOooPartitionHi=").$(srcOooPartitionHi).$(", directIoFlag=").$(directIoFlag).I$();
        try {
            switch (blockType) {
                case 3: {
                    O3CopyJob.mergeCopy(columnType, timestampMergeIndexAddr, srcDataFixAddr + srcDataFixOffset - srcDataTop, srcDataVarAddr + srcDataVarOffset, srcDataLo, srcDataHi, srcOooFixAddr, srcOooVarAddr, srcOooLo, srcOooHi, dstFixAddr + dstFixOffset, dstVarAddr, dstVarOffset, dstVarOffsetEnd);
                    break;
                }
                case 1: {
                    O3CopyJob.copyO3(tableWriter.getFilesFacade(), columnType, srcOooFixAddr, srcOooVarAddr, srcOooLo, srcOooHi, dstFixFd, dstFixAddr + dstFixOffset, dstFixFileOffset, dstVarAddr, dstVarFd, dstVarOffset, dstVarAdjust, dstVarSize, directIoFlag);
                    break;
                }
                case 2: {
                    O3CopyJob.copyData(tableWriter.getFilesFacade(), columnType, srcDataFixAddr + srcDataFixOffset, srcDataVarAddr + srcDataVarOffset, srcDataLo, srcDataHi, dstFixAddr + dstFixOffset, dstFixFd, dstFixFileOffset, dstVarAddr, dstVarFd, dstVarOffset, dstVarAdjust, dstVarSize, directIoFlag);
                    break;
                }
            }
        }
        catch (Throwable th) {
            FilesFacade ff = tableWriter.getFilesFacade();
            O3Utils.unmapAndClose(ff, srcDataFixFd, srcDataFixAddr, srcDataFixSize);
            O3Utils.unmapAndClose(ff, srcDataVarFd, srcDataVarAddr, srcDataVarSize);
            O3Utils.unmapAndClose(ff, dstFixFd, dstFixAddr, dstFixSize);
            O3Utils.unmapAndClose(ff, dstVarFd, dstVarAddr, dstVarSize);
            O3CopyJob.closeColumnIdle(columnCounter, timestampMergeIndexAddr, timestampMergeIndexSize, srcTimestampFd, srcTimestampAddr, srcTimestampSize, tableWriter);
            throw th;
        }
        O3CopyJob.copyTail(columnCounter, partCounter, timestampMergeIndexAddr, timestampMergeIndexSize, srcDataFixFd, srcDataFixAddr, srcDataFixSize, srcDataVarFd, srcDataVarAddr, srcDataVarSize, srcDataMax, srcOooMax, srcOooPartitionLo, srcOooPartitionHi, timestampMin, timestampMax, partitionTimestamp, dstFixFd, dstFixAddr, dstFixSize, dstVarFd, dstVarAddr, dstVarSize, dstKFd, dstVFd, dstIndexOffset, dstIndexAdjust, indexBlockCapacity, srcTimestampFd, srcTimestampAddr, srcTimestampSize, partitionMutates, tableWriter, indexWriter);
    }

    public static void copy(O3CopyTask task, long cursor, Sequence subSeq) {
        AtomicInteger columnCounter = task.getColumnCounter();
        AtomicInteger partCounter = task.getPartCounter();
        int columnType = task.getColumnType();
        int blockType = task.getBlockType();
        long timestampMergeIndexAddr = task.getTimestampMergeIndexAddr();
        long timestampMergeIndexSize = task.getTimestampMergeIndexSize();
        int srcDataFixFd = task.getSrcDataFixFd();
        long srcDataFixAddr = task.getSrcDataFixAddr();
        long srcDataFixOffset = task.getSrcDataFixOffset();
        long srcDataFixSize = task.getSrcDataFixSize();
        int srcDataVarFd = task.getSrcDataVarFd();
        long srcDataVarAddr = task.getSrcDataVarAddr();
        long srcDataVarOffset = task.getSrcDataVarOffset();
        long srcDataVarSize = task.getSrcDataVarSize();
        long srcDataTop = task.getSrcDataTop();
        long srcDataLo = task.getSrcDataLo();
        long srcDataMax = task.getSrcDataMax();
        long srcDataHi = task.getSrcDataHi();
        long srcOooFixAddr = task.getSrcOooFixAddr();
        long srcOooVarAddr = task.getSrcOooVarAddr();
        long srcOooLo = task.getSrcOooLo();
        long srcOooHi = task.getSrcOooHi();
        long srcOooMax = task.getSrcOooMax();
        long srcOooPartitionLo = task.getSrcOooPartitionLo();
        long srcOooPartitionHi = task.getSrcOooPartitionHi();
        long timestampMin = task.getTimestampMin();
        long timestampMax = task.getTimestampMax();
        long partitionTimestamp = task.getPartitionTimestamp();
        int dstFixFd = task.getDstFixFd();
        long dstFixAddr = task.getDstFixAddr();
        long dstFixOffset = task.getDstFixOffset();
        long dstFixFileOffset = task.getDstFixFileOffset();
        long dstFixSize = task.getDstFixSize();
        int dstVarFd = task.getDstVarFd();
        long dstVarAddr = task.getDstVarAddr();
        long dstVarOffset = task.getDstVarOffset();
        long dstVarOffsetEnd = task.getDstVarOffsetEnd();
        long dstVarAdjust = task.getDstVarAdjust();
        long dstVarSize = task.getDstVarSize();
        int dstKFd = task.getDstKFd();
        int dskVFd = task.getDstVFd();
        long dstIndexOffset = task.getDstIndexOffset();
        long dstIndexAdjust = task.getDstIndexAdjust();
        int indexBlockCapacity = task.getIndexBlockCapacity();
        int srcTimestampFd = task.getSrcTimestampFd();
        long srcTimestampAddr = task.getSrcTimestampAddr();
        long srcTimestampSize = task.getSrcTimestampSize();
        boolean partitionMutates = task.isPartitionMutates();
        TableWriter tableWriter = task.getTableWriter();
        BitmapIndexWriter indexWriter = task.getIndexWriter();
        subSeq.done(cursor);
        O3CopyJob.copy(columnCounter, partCounter, columnType, blockType, timestampMergeIndexAddr, timestampMergeIndexSize, srcDataFixFd, srcDataFixAddr, srcDataFixOffset, srcDataFixSize, srcDataVarFd, srcDataVarAddr, srcDataVarOffset, srcDataVarSize, srcDataLo, srcDataHi, srcDataTop, srcDataMax, srcOooFixAddr, srcOooVarAddr, srcOooLo, srcOooHi, srcOooMax, srcOooPartitionLo, srcOooPartitionHi, timestampMin, timestampMax, partitionTimestamp, dstFixFd, dstFixAddr, dstFixOffset, dstFixFileOffset, dstFixSize, dstVarFd, dstVarAddr, dstVarOffset, dstVarOffsetEnd, dstVarAdjust, dstVarSize, dstKFd, dskVFd, dstIndexOffset, dstIndexAdjust, indexBlockCapacity, srcTimestampFd, srcTimestampAddr, srcTimestampSize, partitionMutates, tableWriter, indexWriter);
    }

    private static void copyData(FilesFacade ff, int columnType, long srcFixAddr, long srcVarAddr, long srcLo, long srcHi, long dstFixAddr, int dstFixFd, long dstFixFileOffset, long dstVarAddr, int dstVarFd, long dstVarOffset, long dstVarAdjust, long dstVarSize, boolean directIoFlag) {
        switch (ColumnType.tagOf(columnType)) {
            case 11: 
            case 18: {
                O3CopyJob.copyVarSizeCol(ff, srcFixAddr, srcVarAddr, srcLo, srcHi, dstFixAddr, dstFixFd, dstFixFileOffset, dstVarAddr, dstVarFd, dstVarOffset, dstVarAdjust, dstVarSize, directIoFlag);
                break;
            }
            default: {
                O3CopyJob.copyFixedSizeCol(ff, srcFixAddr, srcLo, srcHi, dstFixAddr, dstFixFileOffset, dstFixFd, ColumnType.pow2SizeOf(Math.abs(columnType)), directIoFlag);
            }
        }
    }

    private static void copyFixedSizeCol(FilesFacade ff, long src, long srcLo, long srcHi, long dstFixAddr, long dstFixFileOffset, int dstFd, int shl, boolean directIoFlag) {
        long len = srcHi - srcLo + 1L << shl;
        long fromAddress = src + (srcLo << shl);
        if (directIoFlag) {
            if (ff.write(Math.abs(dstFd), fromAddress, len, dstFixFileOffset) != len) {
                throw CairoException.critical(ff.errno()).put("cannot copy fixed column prefix [fd=").put(dstFd).put(", len=").put(len).put(", offset=").put(fromAddress).put(']');
            }
        } else {
            Vect.memcpy(dstFixAddr, fromAddress, len);
        }
    }

    private static void copyTail(AtomicInteger columnCounter, @Nullable AtomicInteger partCounter, long timestampMergeIndexAddr, long timestampMergeIndexSize, int srcDataFixFd, long srcDataFixAddr, long srcDataFixSize, int srcDataVarFd, long srcDataVarAddr, long srcDataVarSize, long srcDataMax, long srcOooMax, long srcOooPartitionLo, long srcOooPartitionHi, long timestampMin, long timestampMax, long partitionTimestamp, int dstFixFd, long dstFixAddr, long dstFixSize, int dstVarFd, long dstVarAddr, long dstVarSize, int dstKFd, int dstVFd, long dstIndexOffset, long dstIndexAdjust, int indexBlockCapacity, int srcTimestampFd, long srcTimestampAddr, long srcTimestampSize, boolean partitionMutates, TableWriter tableWriter, BitmapIndexWriter indexWriter) {
        if (partCounter == null || partCounter.decrementAndGet() == 0) {
            FilesFacade ff = tableWriter.getFilesFacade();
            if (indexBlockCapacity > -1) {
                O3CopyJob.updateIndex(columnCounter, timestampMergeIndexAddr, timestampMergeIndexSize, srcDataFixFd, srcDataFixAddr, srcDataFixSize, srcDataVarFd, srcDataVarAddr, srcDataVarSize, dstFixFd, dstFixAddr, Math.abs(dstFixSize), dstVarFd, dstVarAddr, Math.abs(dstVarSize), dstKFd, dstVFd, dstIndexOffset, dstIndexAdjust, srcTimestampFd, srcTimestampAddr, srcTimestampSize, tableWriter, indexWriter, indexBlockCapacity);
            }
            O3Utils.unmapAndClose(ff, srcDataFixFd, srcDataFixAddr, srcDataFixSize);
            O3Utils.unmapAndClose(ff, srcDataVarFd, srcDataVarAddr, srcDataVarSize);
            O3Utils.unmapAndClose(ff, dstFixFd, dstFixAddr, dstFixSize);
            O3Utils.unmapAndClose(ff, dstVarFd, dstVarAddr, dstVarSize);
            int columnsRemaining = columnCounter.decrementAndGet();
            LOG.debug().$("organic [columnsRemaining=").$(columnsRemaining).I$();
            if (columnsRemaining == 0) {
                O3CopyJob.updatePartition(timestampMergeIndexAddr, timestampMergeIndexSize, srcDataMax, srcOooMax, srcOooPartitionLo, srcOooPartitionHi, timestampMin, timestampMax, partitionTimestamp, srcTimestampFd, srcTimestampAddr, srcTimestampSize, partitionMutates, tableWriter);
            }
        }
    }

    private static void copyVarSizeCol(FilesFacade ff, long srcFixAddr, long srcVarAddr, long srcLo, long srcHi, long dstFixAddr, int dstFixFd, long dstFixFileOffset, long dstVarAddr, int dstVarFd, long dstVarOffset, long dstVarAdjust, long dstVarSize, boolean directIoFlag) {
        long lo = O3Utils.findVarOffset(srcFixAddr, srcLo);
        assert (lo >= 0L);
        long hi = O3Utils.findVarOffset(srcFixAddr, srcHi + 1L);
        assert (hi >= lo);
        long len = hi - lo;
        assert (len <= Math.abs(dstVarSize) - dstVarOffset);
        long offset = dstVarOffset + dstVarAdjust;
        if (directIoFlag) {
            if (ff.write(Math.abs(dstVarFd), srcVarAddr + lo, len, offset) != len) {
                throw CairoException.critical(ff.errno()).put("cannot copy var data column prefix [fd=").put(dstVarFd).put(", offset=").put(offset).put(", len=").put(len).put(']');
            }
        } else {
            Vect.memcpy(dstVarAddr + dstVarOffset, srcVarAddr + lo, len);
        }
        if (lo == offset) {
            O3CopyJob.copyFixedSizeCol(ff, srcFixAddr, srcLo, srcHi + 1L, dstFixAddr, dstFixFileOffset, dstFixFd, 3, directIoFlag);
        } else {
            O3Utils.shiftCopyFixedSizeColumnData(lo - offset, srcFixAddr, srcLo, srcHi + 1L, dstFixAddr);
        }
    }

    private static void mergeCopy(int columnType, long timestampMergeIndexAddr, long srcDataFixAddr, long srcDataVarAddr, long srcDataLo, long srcDataHi, long srcOooFixAddr, long srcOooVarAddr, long srcOooLo, long srcOooHi, long dstFixAddr, long dstVarAddr, long dstVarOffset, long dstVarOffsetEnd) {
        long rowCount = srcOooHi - srcOooLo + 1L + srcDataHi - srcDataLo + 1L;
        switch (ColumnType.tagOf(columnType)) {
            case 1: 
            case 2: 
            case 14: {
                Vect.mergeShuffle8Bit(srcDataFixAddr, srcOooFixAddr, dstFixAddr, timestampMergeIndexAddr, rowCount);
                break;
            }
            case 3: 
            case 4: 
            case 15: {
                Vect.mergeShuffle16Bit(srcDataFixAddr, srcOooFixAddr, dstFixAddr, timestampMergeIndexAddr, rowCount);
                break;
            }
            case 11: {
                Vect.oooMergeCopyStrColumn(timestampMergeIndexAddr, rowCount, srcDataFixAddr, srcDataVarAddr, srcOooFixAddr, srcOooVarAddr, dstFixAddr, dstVarAddr, dstVarOffset);
                Unsafe.getUnsafe().putLong(dstFixAddr + rowCount * 8L, dstVarOffsetEnd);
                break;
            }
            case 18: {
                Vect.oooMergeCopyBinColumn(timestampMergeIndexAddr, rowCount, srcDataFixAddr, srcDataVarAddr, srcOooFixAddr, srcOooVarAddr, dstFixAddr, dstVarAddr, dstVarOffset);
                Unsafe.getUnsafe().putLong(dstFixAddr + rowCount * 8L, dstVarOffsetEnd);
                break;
            }
            case 5: 
            case 9: 
            case 12: 
            case 16: {
                Vect.mergeShuffle32Bit(srcDataFixAddr, srcOooFixAddr, dstFixAddr, timestampMergeIndexAddr, rowCount);
                break;
            }
            case 6: 
            case 7: 
            case 10: 
            case 17: {
                Vect.mergeShuffle64Bit(srcDataFixAddr, srcOooFixAddr, dstFixAddr, timestampMergeIndexAddr, rowCount);
                break;
            }
            case 8: {
                boolean designated = ColumnType.isDesignatedTimestamp(columnType);
                if (designated) {
                    Vect.oooCopyIndex(timestampMergeIndexAddr, rowCount, dstFixAddr);
                    break;
                }
                Vect.mergeShuffle64Bit(srcDataFixAddr, srcOooFixAddr, dstFixAddr, timestampMergeIndexAddr, rowCount);
                break;
            }
            case 19: 
            case 24: {
                Vect.mergeShuffle128Bit(srcDataFixAddr, srcOooFixAddr, dstFixAddr, timestampMergeIndexAddr, rowCount);
                break;
            }
            case 13: {
                Vect.mergeShuffle256Bit(srcDataFixAddr, srcOooFixAddr, dstFixAddr, timestampMergeIndexAddr, rowCount);
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void updateIndex(AtomicInteger columnCounter, long timestampMergeIndexAddr, long timestampMergeIndexSize, int srcDataFixFd, long srcDataFixAddr, long srcDataFixSize, int srcDataVarFd, long srcDataVarAddr, long srcDataVarSize, int dstFixFd, long dstFixAddr, long dstFixSize, int dstVarFd, long dstVarAddr, long dstVarSize, int dstKFd, int dstVFd, long dstIndexOffset, long dstIndexAdjust, int srcTimestampFd, long srcTimestampAddr, long srcTimestampSize, TableWriter tableWriter, BitmapIndexWriter indexWriter, int indexBlockCapacity) {
        try {
            boolean closed;
            long row = dstIndexOffset / 4L;
            boolean bl = closed = !indexWriter.isOpen();
            if (closed) {
                indexWriter.of(tableWriter.getConfiguration(), dstKFd, dstVFd, row == 0L, indexBlockCapacity);
            }
            try {
                O3CopyJob.updateIndex(dstFixAddr, dstFixSize, indexWriter, dstIndexOffset / 4L, dstIndexAdjust);
            }
            finally {
                if (closed) {
                    Misc.free(indexWriter);
                }
            }
        }
        catch (Throwable e) {
            LOG.error().$("index error [table=").utf8(tableWriter.getTableToken().getTableName()).$(", e=").$(e).I$();
            tableWriter.o3BumpErrorCount();
            O3CopyJob.copyIdleQuick(columnCounter, timestampMergeIndexAddr, timestampMergeIndexSize, srcDataFixFd, srcDataFixAddr, srcDataFixSize, srcDataVarFd, srcDataVarAddr, srcDataVarSize, srcTimestampFd, srcTimestampAddr, srcTimestampSize, dstFixFd, dstFixAddr, dstFixSize, dstVarFd, dstVarAddr, dstVarSize, 0, 0, tableWriter);
            throw e;
        }
    }

    private static void updateIndex(long dstFixAddr, long dstFixSize, BitmapIndexWriter w, long row, long rowAdjust) {
        w.rollbackConditionally(row + rowAdjust);
        long count = dstFixSize / 4L;
        while (row < count) {
            w.add(TableUtils.toIndexKey(Unsafe.getUnsafe().getInt(dstFixAddr + row * 4L)), row + rowAdjust);
            ++row;
        }
        w.setMaxValue(count - 1L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void updatePartition(long timestampMergeIndexAddr, long timestampMergeIndexSize, long srcDataMax, long srcOooMax, long srcOooPartitionLo, long srcOooPartitionHi, long timestampMin, long timestampMax, long partitionTimestamp, int srcTimestampFd, long srcTimestampAddr, long srcTimestampSize, boolean partitionMutates, TableWriter tableWriter) {
        FilesFacade ff = tableWriter.getFilesFacade();
        O3Utils.unmap(ff, srcTimestampAddr, srcTimestampSize);
        try {
            try {
                O3Utils.close(ff, srcTimestampFd);
            }
            finally {
                tableWriter.o3NotifyPartitionUpdate(timestampMin, timestampMax, partitionTimestamp, srcOooPartitionLo, srcOooPartitionHi, partitionMutates, srcOooMax, srcDataMax);
            }
        }
        finally {
            if (timestampMergeIndexAddr != 0L) {
                Vect.freeMergedIndex(timestampMergeIndexAddr, timestampMergeIndexSize);
            }
            tableWriter.o3CountDownDoneLatch();
        }
    }

    static void closeColumnIdle(AtomicInteger columnCounter, long timestampMergeIndexAddr, long timestampMergeIndexSize, int srcTimestampFd, long srcTimestampAddr, long srcTimestampSize, TableWriter tableWriter) {
        int columnsRemaining = columnCounter.decrementAndGet();
        LOG.debug().$("idle [table=").utf8(tableWriter.getTableToken().getTableName()).$(", columnsRemaining=").$(columnsRemaining).I$();
        if (columnsRemaining == 0) {
            O3CopyJob.closeColumnIdleQuick(timestampMergeIndexAddr, timestampMergeIndexSize, srcTimestampFd, srcTimestampAddr, srcTimestampSize, tableWriter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void closeColumnIdleQuick(long timestampMergeIndexAddr, long timestampMergeIndexSize, int srcTimestampFd, long srcTimestampAddr, long srcTimestampSize, TableWriter tableWriter) {
        try {
            FilesFacade ff = tableWriter.getFilesFacade();
            O3Utils.unmap(ff, srcTimestampAddr, srcTimestampSize);
            O3Utils.close(ff, srcTimestampFd);
            if (timestampMergeIndexAddr != 0L) {
                Vect.freeMergedIndex(timestampMergeIndexAddr, timestampMergeIndexSize);
            }
        }
        finally {
            tableWriter.o3ClockDownPartitionUpdateCount();
            tableWriter.o3CountDownDoneLatch();
        }
    }

    static void copyIdle(AtomicInteger columnCounter, AtomicInteger partCounter, long timestampMergeIndexAddr, long timestampMergeIndexSize, int srcDataFixFd, long srcDataFixAddr, long srcDataFixSize, int srcDataVarFd, long srcDataVarAddr, long srcDataVarSize, int dstFixFd, long dstFixAddr, long dstFixSize, int dstVarFd, long dstVarAddr, long dstVarSize, int srcTimestampFd, long srcTimestampAddr, long srcTimestampSize, int dstKFd, int dstVFd, TableWriter tableWriter) {
        if (partCounter == null || partCounter.decrementAndGet() == 0) {
            O3CopyJob.copyIdleQuick(columnCounter, timestampMergeIndexAddr, timestampMergeIndexSize, srcDataFixFd, srcDataFixAddr, srcDataFixSize, srcDataVarFd, srcDataVarAddr, srcDataVarSize, srcTimestampFd, srcTimestampAddr, srcTimestampSize, dstFixFd, dstFixAddr, dstFixSize, dstVarFd, dstVarAddr, dstVarSize, dstKFd, dstVFd, tableWriter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void copyIdleQuick(AtomicInteger columnCounter, long timestampMergeIndexAddr, long timestampMergeIndexSize, int srcDataFixFd, long srcDataFixAddr, long srcDataFixSize, int srcDataVarFd, long srcDataVarAddr, long srcDataVarSize, int srcTimestampFd, long srcTimestampAddr, long srcTimestampSize, int dstFixFd, long dstFixAddr, long dstFixSize, int dstVarFd, long dstVarAddr, long dstVarSize, int dstKFd, int dstVFd, TableWriter tableWriter) {
        try {
            FilesFacade ff = tableWriter.getFilesFacade();
            O3Utils.unmapAndClose(ff, srcDataFixFd, srcDataFixAddr, srcDataFixSize);
            O3Utils.unmapAndClose(ff, srcDataVarFd, srcDataVarAddr, srcDataVarSize);
            O3Utils.unmapAndClose(ff, dstFixFd, dstFixAddr, dstFixSize);
            O3Utils.unmapAndClose(ff, dstVarFd, dstVarAddr, dstVarSize);
            O3Utils.close(ff, dstKFd);
            O3Utils.close(ff, dstVFd);
        }
        finally {
            O3CopyJob.closeColumnIdle(columnCounter, timestampMergeIndexAddr, timestampMergeIndexSize, srcTimestampFd, srcTimestampAddr, srcTimestampSize, tableWriter);
        }
    }

    static void copyO3(FilesFacade ff, int columnType, long srcOooFixAddr, long srcOooVarAddr, long srcOooLo, long srcOooHi, int dstFixFd, long dstFixAddr, long dstFixFileOffset, long dstVarAddr, int dstVarFd, long dstVarOffset, long dstVarAdjust, long dstVarSize, boolean directIoFlag) {
        switch (ColumnType.tagOf(columnType)) {
            case 11: 
            case 18: {
                O3CopyJob.copyVarSizeCol(ff, srcOooFixAddr, srcOooVarAddr, srcOooLo, srcOooHi, dstFixAddr, dstFixFd, dstFixFileOffset, dstVarAddr, dstVarFd, dstVarOffset, dstVarAdjust, dstVarSize, directIoFlag);
                break;
            }
            case 1: 
            case 2: 
            case 14: {
                O3CopyJob.copyFixedSizeCol(ff, srcOooFixAddr, srcOooLo, srcOooHi, dstFixAddr, dstFixFileOffset, dstFixFd, 0, directIoFlag);
                break;
            }
            case 3: 
            case 4: 
            case 15: {
                O3CopyJob.copyFixedSizeCol(ff, srcOooFixAddr, srcOooLo, srcOooHi, dstFixAddr, dstFixFileOffset, dstFixFd, 1, directIoFlag);
                break;
            }
            case 5: 
            case 9: 
            case 12: 
            case 16: {
                O3CopyJob.copyFixedSizeCol(ff, srcOooFixAddr, srcOooLo, srcOooHi, dstFixAddr, dstFixFileOffset, dstFixFd, 2, directIoFlag);
                break;
            }
            case 6: 
            case 7: 
            case 10: 
            case 17: {
                O3CopyJob.copyFixedSizeCol(ff, srcOooFixAddr, srcOooLo, srcOooHi, dstFixAddr, dstFixFileOffset, dstFixFd, 3, directIoFlag);
                break;
            }
            case 8: {
                boolean designated = ColumnType.isDesignatedTimestamp(columnType);
                if (designated) {
                    O3Utils.copyFromTimestampIndex(srcOooFixAddr, srcOooLo, srcOooHi, dstFixAddr);
                    break;
                }
                O3CopyJob.copyFixedSizeCol(ff, srcOooFixAddr, srcOooLo, srcOooHi, dstFixAddr, dstFixFileOffset, dstFixFd, 3, directIoFlag);
                break;
            }
            case 19: 
            case 24: {
                O3CopyJob.copyFixedSizeCol(ff, srcOooFixAddr, srcOooLo, srcOooHi, dstFixAddr, dstFixFileOffset, dstFixFd, 4, directIoFlag);
                break;
            }
            case 13: {
                O3CopyJob.copyFixedSizeCol(ff, srcOooFixAddr, srcOooLo, srcOooHi, dstFixAddr, dstFixFileOffset, dstFixFd, 5, directIoFlag);
                break;
            }
        }
    }

    @Override
    protected boolean doRun(int workerId, long cursor) {
        O3CopyJob.copy((O3CopyTask)this.queue.get(cursor), cursor, this.subSeq);
        return true;
    }
}

