/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cairo;

import io.questdb.cairo.AbstractRecordMetadata;
import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.CairoException;
import io.questdb.cairo.TableColumnMetadata;
import io.questdb.cairo.TableToken;
import io.questdb.cairo.TableUtils;
import io.questdb.cairo.sql.TableRecordMetadata;
import io.questdb.cairo.vm.Vm;
import io.questdb.cairo.vm.api.MemoryMA;
import io.questdb.cairo.vm.api.MemoryMR;
import io.questdb.std.Chars;
import io.questdb.std.FilesFacade;
import io.questdb.std.LowerCaseCharSequenceIntHashMap;
import io.questdb.std.Misc;
import io.questdb.std.Mutable;
import io.questdb.std.datetime.millitime.MillisecondClock;
import io.questdb.std.str.Path;

public class TableReaderMetadata
extends AbstractRecordMetadata
implements TableRecordMetadata,
Mutable {
    private final CairoConfiguration configuration;
    private final FilesFacade ff;
    private final LowerCaseCharSequenceIntHashMap tmpValidationMap = new LowerCaseCharSequenceIntHashMap();
    private int maxUncommittedRows;
    private MemoryMR metaMem;
    private long o3MaxLag;
    private int partitionBy;
    private Path path;
    private int plen;
    private long structureVersion;
    private int tableId;
    private TableToken tableToken;
    private MemoryMR transitionMeta;
    private boolean walEnabled;

    public TableReaderMetadata(CairoConfiguration configuration, TableToken tableToken) {
        this.configuration = configuration;
        this.ff = configuration.getFilesFacade();
        this.tableToken = tableToken;
        this.path = new Path().of(configuration.getRoot()).concat(tableToken.getDirName());
        this.plen = this.path.length();
        this.metaMem = Vm.getMRInstance();
    }

    public TableReaderMetadata(CairoConfiguration configuration) {
        this.configuration = configuration;
        this.ff = configuration.getFilesFacade();
        this.tableToken = null;
        this.metaMem = Vm.getMRInstance();
    }

    public void applyTransitionIndex() {
        MemoryMR temp = this.metaMem;
        this.metaMem = this.transitionMeta;
        this.transitionMeta = temp;
        this.transitionMeta.close();
        this.columnNameIndexMap.clear();
        int existingColumnCount = this.columnCount;
        int columnCount = this.metaMem.getInt(0L);
        assert (columnCount >= existingColumnCount);
        this.columnMetadata.setPos(columnCount);
        int timestampIndex = this.metaMem.getInt(8L);
        this.tableId = this.metaMem.getInt(16L);
        this.structureVersion = this.metaMem.getLong(32L);
        this.maxUncommittedRows = this.metaMem.getInt(20L);
        this.o3MaxLag = this.metaMem.getLong(24L);
        this.walEnabled = this.metaMem.getBool(40L);
        long offset = TableUtils.getColumnNameOffset(columnCount);
        int shiftLeft = 0;
        int existingIndex = 0;
        for (int metaIndex = 0; metaIndex < columnCount; ++metaIndex) {
            CharSequence name = this.metaMem.getStr(offset);
            offset += (long)Vm.getStorageLength(name);
            assert (name != null);
            int columnType = TableUtils.getColumnType(this.metaMem, metaIndex);
            boolean isIndexed = TableUtils.isColumnIndexed(this.metaMem, metaIndex);
            int indexBlockCapacity = TableUtils.getIndexBlockCapacity(this.metaMem, metaIndex);
            TableColumnMetadata existing = null;
            if (existingIndex < existingColumnCount && (existing = (TableColumnMetadata)this.columnMetadata.getQuick(existingIndex)).getWriterIndex() > metaIndex) {
                assert (columnType < 0);
                continue;
            }
            assert (existing == null || existing.getWriterIndex() == metaIndex);
            if (columnType < 0) {
                ++shiftLeft;
            } else {
                String newName;
                boolean rename = existing != null && !Chars.equals((CharSequence)existing.getName(), name);
                String string = newName = rename || existing == null ? Chars.toString(name) : existing.getName();
                if (rename || existing == null || existing.isIndexed() != isIndexed || existing.getIndexValueBlockCapacity() != indexBlockCapacity) {
                    this.columnMetadata.setQuick(existingIndex - shiftLeft, new TableColumnMetadata(newName, columnType, isIndexed, indexBlockCapacity, true, null, metaIndex));
                } else if (shiftLeft > 0) {
                    this.columnMetadata.setQuick(existingIndex - shiftLeft, existing);
                }
                this.columnNameIndexMap.put(newName, existingIndex - shiftLeft);
                if (timestampIndex == metaIndex) {
                    this.timestampIndex = existingIndex - shiftLeft;
                }
            }
            ++existingIndex;
        }
        this.columnMetadata.setPos(existingIndex - shiftLeft);
        this.columnCount = this.columnMetadata.size();
        if (timestampIndex < 0) {
            this.timestampIndex = timestampIndex;
        }
    }

    @Override
    public void clear() {
        super.clear();
        Misc.free(this.metaMem);
        Misc.free(this.transitionMeta);
    }

    @Override
    public void close() {
        this.metaMem = Misc.free(this.metaMem);
        this.path = Misc.free(this.path);
        this.transitionMeta = Misc.free(this.transitionMeta);
    }

    public void copy(TableReaderMetadata metadata) {
        this.partitionBy = metadata.partitionBy;
        this.tableId = metadata.tableId;
        this.maxUncommittedRows = metadata.maxUncommittedRows;
        this.o3MaxLag = metadata.o3MaxLag;
        this.structureVersion = metadata.structureVersion;
        this.walEnabled = metadata.walEnabled;
        this.path.of(metadata.path);
        this.timestampIndex = metadata.timestampIndex;
        this.columnCount = metadata.columnCount;
        this.columnMetadata.setPos(this.columnCount);
        this.columnNameIndexMap.clear();
        for (int i = 0; i < this.columnCount; ++i) {
            TableColumnMetadata columnMetadata = (TableColumnMetadata)metadata.columnMetadata.getQuick(i);
            this.columnMetadata.setQuick(i, new TableColumnMetadata(columnMetadata.getName(), columnMetadata.getType(), columnMetadata.isIndexed(), columnMetadata.getIndexValueBlockCapacity(), columnMetadata.isSymbolTableStatic(), columnMetadata.getMetadata(), columnMetadata.getWriterIndex()));
            this.columnNameIndexMap.put(columnMetadata.getName(), i);
        }
    }

    public long createTransitionIndex(long txnStructureVersion) {
        if (this.transitionMeta == null) {
            this.transitionMeta = Vm.getMRInstance();
        }
        this.transitionMeta.smallFile(this.ff, this.path, 25);
        if (this.transitionMeta.size() >= 40L && txnStructureVersion != this.transitionMeta.getLong(32L)) {
            return -1L;
        }
        this.tmpValidationMap.clear();
        TableUtils.validateMeta(this.transitionMeta, this.tmpValidationMap, 426);
        return TableUtils.createTransitionIndex(this.transitionMeta, this);
    }

    public void dumpTo(MemoryMA mem) {
        long len = this.metaMem.size();
        for (long p = 0L; p < len; ++p) {
            mem.putByte(this.metaMem.getByte(p));
        }
    }

    @Override
    public int getColumnCount() {
        return this.columnCount;
    }

    @Override
    public int getMaxUncommittedRows() {
        return this.maxUncommittedRows;
    }

    @Override
    public long getO3MaxLag() {
        return this.o3MaxLag;
    }

    public int getPartitionBy() {
        return this.partitionBy;
    }

    @Override
    public long getStructureVersion() {
        return this.structureVersion;
    }

    @Override
    public int getTableId() {
        return this.tableId;
    }

    @Override
    public TableToken getTableToken() {
        return this.tableToken;
    }

    @Override
    public boolean isWalEnabled() {
        return this.walEnabled;
    }

    public void load() {
        long timeout = this.configuration.getSpinLockTimeout();
        MillisecondClock millisecondClock = this.configuration.getMillisecondClock();
        long deadline = this.configuration.getMillisecondClock().getTicks() + timeout;
        this.path.trimTo(this.plen).concat("_meta").$();
        boolean existenceChecked = false;
        while (true) {
            try {
                this.load(this.path);
                return;
            }
            catch (CairoException ex) {
                if (!existenceChecked) {
                    this.path.trimTo(this.plen).slash$();
                    if (!this.ff.exists(this.path)) {
                        throw CairoException.tableDoesNotExist(this.tableToken.getTableName());
                    }
                    this.path.trimTo(this.plen).concat("_meta").$();
                }
                existenceChecked = true;
                TableUtils.handleMetadataLoadException(this.tableToken.getTableName(), deadline, ex, millisecondClock, timeout);
                continue;
            }
            break;
        }
    }

    public void load(Path path) {
        try {
            this.metaMem.smallFile(this.ff, path, 25);
            this.columnNameIndexMap.clear();
            TableUtils.validateMeta(this.metaMem, this.columnNameIndexMap, 426);
            int columnCount = this.metaMem.getInt(0L);
            int timestampIndex = this.metaMem.getInt(8L);
            this.partitionBy = this.metaMem.getInt(4L);
            this.tableId = this.metaMem.getInt(16L);
            this.maxUncommittedRows = this.metaMem.getInt(20L);
            this.o3MaxLag = this.metaMem.getLong(24L);
            this.structureVersion = this.metaMem.getLong(32L);
            this.walEnabled = this.metaMem.getBool(40L);
            this.columnMetadata.clear();
            long offset = TableUtils.getColumnNameOffset(columnCount);
            this.timestampIndex = -1;
            for (int i = 0; i < columnCount; ++i) {
                CharSequence name = this.metaMem.getStr(offset);
                assert (name != null);
                int columnType = TableUtils.getColumnType(this.metaMem, i);
                if (columnType > -1) {
                    this.columnMetadata.add(new TableColumnMetadata(Chars.toString(name), columnType, TableUtils.isColumnIndexed(this.metaMem, i), TableUtils.getIndexBlockCapacity(this.metaMem, i), true, null, i));
                    if (i == timestampIndex) {
                        this.timestampIndex = this.columnMetadata.size() - 1;
                    }
                }
                offset += (long)Vm.getStorageLength(name);
            }
            this.columnCount = this.columnMetadata.size();
        }
        catch (Throwable e) {
            this.clear();
            throw e;
        }
    }

    public void updateTableToken(TableToken tableToken) {
        this.tableToken = tableToken;
    }
}

