/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cutlass.text;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.CairoEngine;
import io.questdb.cairo.CairoException;
import io.questdb.cairo.ColumnType;
import io.questdb.cairo.DefaultLifecycleManager;
import io.questdb.cairo.ImplicitCastException;
import io.questdb.cairo.PartitionBy;
import io.questdb.cairo.SymbolMapReaderImpl;
import io.questdb.cairo.SymbolMapWriter;
import io.questdb.cairo.TableStructure;
import io.questdb.cairo.TableToken;
import io.questdb.cairo.TableUtils;
import io.questdb.cairo.TableWriter;
import io.questdb.cairo.TxReader;
import io.questdb.cairo.sql.ExecutionCircuitBreaker;
import io.questdb.cairo.sql.RecordMetadata;
import io.questdb.cairo.vm.Vm;
import io.questdb.cairo.vm.api.MemoryCMARW;
import io.questdb.cutlass.text.AbstractTextLexer;
import io.questdb.cutlass.text.CsvFileIndexer;
import io.questdb.cutlass.text.ParallelCsvFileImporter;
import io.questdb.cutlass.text.TextException;
import io.questdb.cutlass.text.TextImportException;
import io.questdb.cutlass.text.TextLexerWrapper;
import io.questdb.cutlass.text.Utf8Exception;
import io.questdb.cutlass.text.types.TimestampAdapter;
import io.questdb.cutlass.text.types.TypeAdapter;
import io.questdb.griffin.engine.functions.columns.ColumnUtils;
import io.questdb.log.Log;
import io.questdb.log.LogFactory;
import io.questdb.std.DirectLongList;
import io.questdb.std.Files;
import io.questdb.std.FilesFacade;
import io.questdb.std.IOURing;
import io.questdb.std.IOURingFacade;
import io.questdb.std.IntObjHashMap;
import io.questdb.std.LongList;
import io.questdb.std.NumericException;
import io.questdb.std.ObjList;
import io.questdb.std.Os;
import io.questdb.std.Unsafe;
import io.questdb.std.Vect;
import io.questdb.std.str.DirectByteCharSequence;
import io.questdb.std.str.DirectCharSink;
import io.questdb.std.str.Path;
import io.questdb.std.str.StringSink;
import org.jetbrains.annotations.Nullable;

public class TextImportTask {
    public static final byte NO_PHASE = -1;
    public static final byte PHASE_ANALYZE_FILE_STRUCTURE = 9;
    public static final byte PHASE_ATTACH_PARTITIONS = 8;
    public static final byte PHASE_BOUNDARY_CHECK = 1;
    public static final byte PHASE_BUILD_SYMBOL_INDEX = 6;
    public static final byte PHASE_CLEANUP = 10;
    public static final byte PHASE_INDEXING = 2;
    public static final byte PHASE_MOVE_PARTITIONS = 7;
    public static final byte PHASE_PARTITION_IMPORT = 3;
    public static final byte PHASE_SETUP = 0;
    public static final byte PHASE_SYMBOL_TABLE_MERGE = 4;
    public static final byte PHASE_UPDATE_SYMBOL_KEYS = 5;
    public static final byte STATUS_CANCELLED = 3;
    public static final byte STATUS_FAILED = 2;
    public static final byte STATUS_FINISHED = 1;
    public static final byte STATUS_STARTED = 0;
    private static final Log LOG = LogFactory.getLog(TextImportTask.class);
    private static final IntObjHashMap<String> PHASE_NAME_MAP = new IntObjHashMap();
    private static final IntObjHashMap<String> STATUS_NAME_MAP = new IntObjHashMap();
    private final PhaseBoundaryCheck phaseBoundaryCheck = new PhaseBoundaryCheck();
    private final PhaseBuildSymbolIndex phaseBuildSymbolIndex = new PhaseBuildSymbolIndex();
    private final PhaseIndexing phaseIndexing = new PhaseIndexing();
    private final PhasePartitionImport phasePartitionImport = new PhasePartitionImport();
    private final PhaseSymbolTableMerge phaseSymbolTableMerge = new PhaseSymbolTableMerge();
    private final PhaseUpdateSymbolKeys phaseUpdateSymbolKeys = new PhaseUpdateSymbolKeys();
    private int chunkIndex;
    @Nullable
    private ExecutionCircuitBreaker circuitBreaker;
    @Nullable
    private CharSequence errorMessage;
    private byte phase;
    private byte status;

    public static String getPhaseName(byte phase) {
        return PHASE_NAME_MAP.get(phase);
    }

    public static String getStatusName(byte status) {
        return STATUS_NAME_MAP.get(status);
    }

    public void clear() {
        if (this.phase == 1) {
            this.phaseBoundaryCheck.clear();
        } else if (this.phase == 2) {
            this.phaseIndexing.clear();
        } else if (this.phase == 3) {
            this.phasePartitionImport.clear();
        } else if (this.phase == 4) {
            this.phaseSymbolTableMerge.clear();
        } else if (this.phase == 5) {
            this.phaseUpdateSymbolKeys.clear();
        } else if (this.phase == 6) {
            this.phaseBuildSymbolIndex.clear();
        } else {
            throw TextException.$("Unexpected phase ").put(this.phase);
        }
    }

    public PhaseIndexing getBuildPartitionIndexPhase() {
        return this.phaseIndexing;
    }

    public int getChunkIndex() {
        return this.chunkIndex;
    }

    public PhaseBoundaryCheck getCountQuotesPhase() {
        return this.phaseBoundaryCheck;
    }

    @Nullable
    public CharSequence getErrorMessage() {
        return this.errorMessage;
    }

    public PhasePartitionImport getImportPartitionDataPhase() {
        return this.phasePartitionImport;
    }

    public byte getPhase() {
        return this.phase;
    }

    public byte getStatus() {
        return this.status;
    }

    public boolean isCancelled() {
        return this.status == 3;
    }

    public boolean isFailed() {
        return this.status == 2;
    }

    public void ofPhaseBoundaryCheck(FilesFacade ff, Path path, long chunkStart, long chunkEnd) {
        this.phase = 1;
        this.phaseBoundaryCheck.of(ff, path, chunkStart, chunkEnd);
    }

    public void ofPhaseBuildSymbolIndex(CairoEngine cairoEngine, TableStructure tableStructure, CharSequence root, int index, RecordMetadata metadata) {
        this.phase = (byte)6;
        this.phaseBuildSymbolIndex.of(cairoEngine, tableStructure, root, index, metadata);
    }

    public void ofPhaseIndexing(long chunkStart, long chunkEnd, long lineNumber, int index, CharSequence inputFileName, CharSequence importRoot, int partitionBy, byte columnDelimiter, int timestampIndex, TimestampAdapter adapter, boolean ignoreHeader, int atomicity) {
        this.phase = (byte)2;
        this.phaseIndexing.of(chunkStart, chunkEnd, lineNumber, index, inputFileName, importRoot, partitionBy, columnDelimiter, timestampIndex, adapter, ignoreHeader, atomicity);
    }

    public void ofPhaseSymbolTableMerge(CairoConfiguration cfg, CharSequence importRoot, TableWriter writer, TableToken tableToken, CharSequence column, int columnIndex, int symbolColumnIndex, int tmpTableCount, int partitionBy) {
        this.phase = (byte)4;
        this.phaseSymbolTableMerge.of(cfg, importRoot, writer, tableToken, column, columnIndex, symbolColumnIndex, tmpTableCount, partitionBy);
    }

    public void ofPhaseUpdateSymbolKeys(CairoEngine cairoEngine, TableStructure tableStructure, int index, long partitionSize, long partitionTimestamp, CharSequence root, CharSequence columnName, int symbolCount) {
        this.phase = (byte)5;
        this.phaseUpdateSymbolKeys.of(cairoEngine, tableStructure, index, partitionSize, partitionTimestamp, root, columnName, symbolCount);
    }

    public boolean run(TextLexerWrapper lf, CsvFileIndexer indexer, DirectCharSink utf8Sink, DirectLongList unmergedIndexes, long fileBufAddr, long fileBufSize, Path p1, Path p2) {
        try {
            LOG.debug().$("starting [phase=").$(TextImportTask.getPhaseName(this.phase)).$(",index=").$(this.chunkIndex).I$();
            this.status = 0;
            this.errorMessage = null;
            this.throwIfCancelled();
            if (this.phase == 1) {
                this.phaseBoundaryCheck.run(fileBufAddr, fileBufSize);
            } else if (this.phase == 2) {
                this.phaseIndexing.run(indexer, fileBufAddr, fileBufSize);
            } else if (this.phase == 3) {
                this.phasePartitionImport.run(lf, fileBufAddr, fileBufSize, utf8Sink, unmergedIndexes, p1, p2);
            } else if (this.phase == 4) {
                this.phaseSymbolTableMerge.run(p1);
            } else if (this.phase == 5) {
                this.phaseUpdateSymbolKeys.run(p1);
            } else if (this.phase == 6) {
                this.phaseBuildSymbolIndex.run();
            } else {
                throw TextException.$("Unexpected phase ").put(this.phase);
            }
            LOG.debug().$("finished [phase=").$(TextImportTask.getPhaseName(this.phase)).$(",index=").$(this.chunkIndex).I$();
        }
        catch (TextImportException e) {
            this.status = (byte)3;
            this.errorMessage = e.getMessage();
            LOG.error().$("Import cancelled [phase=").$(TextImportTask.getPhaseName(e.getPhase())).I$();
            return false;
        }
        catch (Throwable t) {
            LOG.error().$("could not import [phase=").$(TextImportTask.getPhaseName(this.phase)).$(", ex=").$(t).I$();
            this.status = (byte)2;
            this.errorMessage = t.getMessage();
            return false;
        }
        return true;
    }

    public void setChunkIndex(int chunkIndex) {
        this.chunkIndex = chunkIndex;
    }

    public void setCircuitBreaker(@Nullable ExecutionCircuitBreaker circuitBreaker) {
        this.circuitBreaker = circuitBreaker;
    }

    private TextImportException getCancelException() {
        TextImportException ex = TextImportException.instance(this.phase, "Cancelled");
        ex.setCancelled(true);
        return ex;
    }

    private void throwIfCancelled() throws TextImportException {
        if (this.circuitBreaker != null && this.circuitBreaker.checkIfTripped()) {
            throw this.getCancelException();
        }
    }

    void ofPhasePartitionImport(CairoEngine cairoEngine, TableStructure targetTableStructure, ObjList<TypeAdapter> types, int atomicity, byte columnDelimiter, CharSequence importRoot, CharSequence inputFileName, int index, int lo, int hi, ObjList<ParallelCsvFileImporter.PartitionInfo> partitions) {
        this.phase = (byte)3;
        this.phasePartitionImport.of(cairoEngine, targetTableStructure, types, atomicity, columnDelimiter, importRoot, inputFileName, index, lo, hi, partitions);
    }

    static {
        PHASE_NAME_MAP.put(0, "setup");
        PHASE_NAME_MAP.put(1, "boundary_check");
        PHASE_NAME_MAP.put(2, "indexing");
        PHASE_NAME_MAP.put(3, "partition_import");
        PHASE_NAME_MAP.put(4, "symbol_table_merge");
        PHASE_NAME_MAP.put(5, "update_symbol_keys");
        PHASE_NAME_MAP.put(6, "build_symbol_index");
        PHASE_NAME_MAP.put(7, "move_partitions");
        PHASE_NAME_MAP.put(8, "attach_partitions");
        PHASE_NAME_MAP.put(9, "analyze_file_structure");
        PHASE_NAME_MAP.put(10, "cleanup");
        STATUS_NAME_MAP.put(0, "started");
        STATUS_NAME_MAP.put(1, "finished");
        STATUS_NAME_MAP.put(2, "failed");
        STATUS_NAME_MAP.put(3, "cancelled");
    }

    public class PhasePartitionImport {
        private final LongList importedRows = new LongList();
        private final LongList offsets = new LongList();
        private final StringSink tableNameSink = new StringSink();
        private int atomicity;
        private CairoEngine cairoEngine;
        private byte columnDelimiter;
        private long errors;
        private int hi;
        private CharSequence importRoot;
        private int index;
        private CharSequence inputFileName;
        private int lo;
        private long offset;
        private ObjList<ParallelCsvFileImporter.PartitionInfo> partitions;
        private long rowsHandled;
        private long rowsImported;
        private TableWriter tableWriterRef;
        private TableStructure targetTableStructure;
        private TimestampAdapter timestampAdapter;
        private int timestampIndex;
        private ObjList<TypeAdapter> types;
        private DirectCharSink utf8Sink;
        private final AbstractTextLexer.Listener onFieldsPartitioned = this::onFieldsPartitioned;

        public void clear() {
            this.cairoEngine = null;
            this.targetTableStructure = null;
            this.types = null;
            this.atomicity = -1;
            this.columnDelimiter = (byte)-1;
            this.importRoot = null;
            this.inputFileName = null;
            this.index = -1;
            this.partitions = null;
            this.timestampIndex = -1;
            this.timestampAdapter = null;
            this.offset = 0L;
            this.importedRows.clear();
            this.tableNameSink.clear();
            this.rowsHandled = 0L;
            this.rowsImported = 0L;
            this.errors = 0L;
            this.utf8Sink = null;
        }

        public long getErrors() {
            return this.errors;
        }

        public LongList getImportedRows() {
            return this.importedRows;
        }

        public long getRowsHandled() {
            return this.rowsHandled;
        }

        public long getRowsImported() {
            return this.rowsImported;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run(TextLexerWrapper lf, long fileBufAddr, long fileBufSize, DirectCharSink utf8Sink, DirectLongList unmergedIndexes, Path path, Path tmpPath) throws TextException {
            this.utf8Sink = utf8Sink;
            CairoConfiguration configuration = this.cairoEngine.getConfiguration();
            FilesFacade ff = configuration.getFilesFacade();
            this.tableNameSink.clear();
            this.tableNameSink.put(this.targetTableStructure.getTableName()).put('_').put(this.index);
            String publicTableName = this.tableNameSink.toString();
            TableToken tableToken = new TableToken(publicTableName, publicTableName, (int)this.cairoEngine.getTableIdGenerator().getNextId(), false);
            ParallelCsvFileImporter.createTable(ff, configuration.getMkDirMode(), this.importRoot, tableToken.getDirName(), publicTableName, this.targetTableStructure, 0);
            try (TableWriter writer = new TableWriter(configuration, tableToken, this.cairoEngine.getMessageBus(), null, true, DefaultLifecycleManager.INSTANCE, this.importRoot, this.cairoEngine.getMetrics());){
                this.tableWriterRef = writer;
                AbstractTextLexer lexer = lf.getLexer(this.columnDelimiter);
                lexer.setTableName(this.tableNameSink);
                lexer.setSkipLinesWithExtraValues(false);
                try {
                    for (int i = this.lo; i < this.hi; ++i) {
                        TextImportTask.this.throwIfCancelled();
                        lexer.clear();
                        long prevErrors = this.errors;
                        CharSequence name = this.partitions.getQuick((int)i).name;
                        path.of(this.importRoot).concat(name);
                        this.mergePartitionIndexAndImportData(ff, configuration.getIOURingFacade(), configuration.isIOURingEnabled(), path, lexer, fileBufAddr, fileBufSize, utf8Sink, unmergedIndexes, tmpPath);
                        long newErrors = this.errors - prevErrors;
                        long imported = this.atomicity == 1 ? lexer.getLineCount() - newErrors : lexer.getLineCount();
                        this.importedRows.add(i);
                        this.importedRows.add(imported);
                        this.rowsHandled += lexer.getLineCount();
                        this.rowsImported += imported;
                        LOG.info().$("imported data [temp_table=").$(this.tableNameSink).$(", partition=").$(name).$(", lines=").$(lexer.getLineCount()).$(", errors=").$(newErrors).I$();
                    }
                }
                finally {
                    writer.commit(1);
                }
            }
        }

        private void consumeIOURing(FilesFacade ff, long sqeMin, AbstractTextLexer lexer, long fileBufAddr, LongList offsets, IOURing ring, int cc, Path tmpPath) {
            int i;
            int submitted = ring.submit();
            assert (submitted == cc);
            long nextCqe = sqeMin;
            int writtenMax = 0;
            for (i = 0; i < submitted; ++i) {
                while (!ring.nextCqe()) {
                    Os.pause();
                }
                if (ring.getCqeRes() < 0) {
                    throw TextException.$("could not read from file [path='").put(tmpPath).put("', errno=").put(ff.errno()).put(", offset=").put(this.offset).put("]");
                }
                if (ring.getCqeId() != nextCqe) continue;
                ++nextCqe;
                this.parseLinesAndWrite(lexer, fileBufAddr, offsets, writtenMax);
                ++writtenMax;
            }
            for (i = writtenMax; i < submitted; ++i) {
                this.parseLinesAndWrite(lexer, fileBufAddr, offsets, i);
            }
        }

        private TableWriter.Row getRow(DirectByteCharSequence dbcs, long offset) {
            long timestamp;
            try {
                timestamp = this.timestampAdapter.getTimestamp(dbcs);
            }
            catch (Throwable e) {
                if (this.atomicity == 0) {
                    throw TextException.$("could not parse timestamp [offset=").put(offset).put(", msg=").put(e.getMessage()).put(']');
                }
                this.logError(offset, this.timestampIndex, dbcs);
                return null;
            }
            return this.tableWriterRef.newRow(timestamp);
        }

        private void importPartitionData(IOURingFacade rf, boolean ioURingEnabled, AbstractTextLexer lexer, long address, long size, long fileBufAddr, long fileBufSize, DirectCharSink utf8Sink, Path tmpPath) throws TextException {
            if (ioURingEnabled && rf.isAvailable()) {
                this.importPartitionDataURing(rf, lexer, address, size, fileBufAddr, fileBufSize, utf8Sink, tmpPath);
            } else {
                this.importPartitionDataVanilla(lexer, address, size, fileBufAddr, fileBufSize, utf8Sink, tmpPath);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void importPartitionDataURing(IOURingFacade rf, AbstractTextLexer lexer, long address, long size, long fileBufAddr, long fileBufSize, DirectCharSink utf8Sink, Path tmpPath) {
            CairoConfiguration configuration = this.cairoEngine.getConfiguration();
            FilesFacade ff = configuration.getFilesFacade();
            this.offsets.clear();
            lexer.setupBeforeExactLines(this.onFieldsPartitioned);
            int fd = -1;
            try {
                tmpPath.of(configuration.getSqlCopyInputRoot()).concat(this.inputFileName).$();
                utf8Sink.clear();
                fd = TableUtils.openRO(ff, tmpPath, LOG);
                long len = ff.length(fd);
                if (len == -1L) {
                    throw CairoException.critical(ff.errno()).put("could not get length of file [path=").put(tmpPath).put(']');
                }
                ff.fadvise(fd, 0L, len, Files.POSIX_FADV_RANDOM);
                long MASK = 0xFFFFFFFFFFFFL;
                long count = size / 16L;
                int ringCapacity = 32;
                long sqeMin = 0L;
                long sqeMax = -1L;
                try (IOURing ring = rf.newInstance(ringCapacity);){
                    long addr = fileBufAddr;
                    long lim = fileBufAddr + fileBufSize;
                    int cc = 0;
                    for (long i = 0L; i < count; ++i) {
                        TextImportTask.this.throwIfCancelled();
                        long lengthAndOffset = Unsafe.getUnsafe().getLong(address + i * 2L * 8L + 8L);
                        int lineLength = (int)(lengthAndOffset >>> 48);
                        this.offset = lengthAndOffset & 0xFFFFFFFFFFFFL;
                        int bytesToRead = lineLength;
                        if (cc == ringCapacity || cc > 0 && addr + (long)lineLength > lim) {
                            this.consumeIOURing(ff, sqeMin, lexer, fileBufAddr, this.offsets, ring, cc, tmpPath);
                            cc = 0;
                            addr = fileBufAddr;
                            this.offsets.clear();
                            sqeMin = sqeMax + 1L;
                        }
                        if (addr + (long)lineLength > lim) {
                            throw TextException.$("buffer overflow [path='").put(tmpPath).put("', lineLength=").put(lineLength).put(", fileBufSize=").put(fileBufSize).put("]");
                        }
                        int additionalLines = 0;
                        for (long j = i + 1L; j < count; ++j) {
                            long nextLengthAndOffset = Unsafe.getUnsafe().getLong(address + j * 2L * 8L + 8L);
                            int nextLineLength = (int)(nextLengthAndOffset >>> 48);
                            long nextOffset = nextLengthAndOffset & 0xFFFFFFFFFFFFL;
                            long diff = nextOffset - this.offset - (long)bytesToRead;
                            long nextBytesToRead = diff + (long)nextLineLength;
                            if (diff <= -1L || diff >= 2L || addr + (long)bytesToRead + nextBytesToRead > lim) break;
                            bytesToRead = (int)((long)bytesToRead + nextBytesToRead);
                            ++additionalLines;
                        }
                        i += (long)additionalLines;
                        sqeMax = ring.enqueueRead(fd, this.offset, addr, bytesToRead);
                        if (sqeMax == -1L) {
                            throw TextException.$("io_uring error [path='").put(tmpPath).put("', cqeRes=").put(-ring.getCqeRes()).put("]");
                        }
                        this.offsets.add(addr - fileBufAddr, (long)bytesToRead);
                        ++cc;
                        addr += (long)bytesToRead;
                    }
                    if (cc > 0) {
                        this.consumeIOURing(ff, sqeMin, lexer, fileBufAddr, this.offsets, ring, cc, tmpPath);
                    }
                }
            }
            finally {
                ff.close(fd);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void importPartitionDataVanilla(AbstractTextLexer lexer, long address, long size, long fileBufAddr, long fileBufSize, DirectCharSink utf8Sink, Path tmpPath) {
            CairoConfiguration configuration = this.cairoEngine.getConfiguration();
            FilesFacade ff = configuration.getFilesFacade();
            lexer.setupBeforeExactLines(this.onFieldsPartitioned);
            int fd = -1;
            try {
                tmpPath.of(configuration.getSqlCopyInputRoot()).concat(this.inputFileName).$();
                utf8Sink.clear();
                fd = TableUtils.openRO(ff, tmpPath, LOG);
                long len = ff.length(fd);
                if (len == -1L) {
                    throw CairoException.critical(ff.errno()).put("could not get length of file [path=").put(tmpPath).put(']');
                }
                ff.fadvise(fd, 0L, len, Files.POSIX_FADV_RANDOM);
                long MASK = 0xFFFFFFFFFFFFL;
                long count = size / 16L;
                for (long i = 0L; i < count; ++i) {
                    TextImportTask.this.throwIfCancelled();
                    long lengthAndOffset = Unsafe.getUnsafe().getLong(address + i * 2L * 8L + 8L);
                    int lineLength = (int)(lengthAndOffset >>> 48);
                    this.offset = lengthAndOffset & 0xFFFFFFFFFFFFL;
                    int bytesToRead = lineLength;
                    int additionalLines = 0;
                    for (long j = i + 1L; j < count; ++j) {
                        long nextLengthAndOffset = Unsafe.getUnsafe().getLong(address + j * 2L * 8L + 8L);
                        int nextLineLength = (int)(nextLengthAndOffset >>> 48);
                        long nextOffset = nextLengthAndOffset & 0xFFFFFFFFFFFFL;
                        long diff = nextOffset - this.offset - (long)bytesToRead;
                        long nextBytesToRead = diff + (long)nextLineLength;
                        if (diff <= -1L || diff >= 2L || (long)bytesToRead + nextBytesToRead > fileBufSize) break;
                        bytesToRead = (int)((long)bytesToRead + (diff + (long)nextLineLength));
                        ++additionalLines;
                    }
                    i += (long)additionalLines;
                    if ((long)bytesToRead > fileBufSize) {
                        throw TextException.$("buffer overflow [path='").put(tmpPath).put("', bytesToRead=").put(bytesToRead).put(", fileBufSize=").put(fileBufSize).put("]");
                    }
                    long n = ff.read(fd, fileBufAddr, bytesToRead, this.offset);
                    if (n <= 0L) {
                        throw TextException.$("could not read from file [path='").put(tmpPath).put("', errno=").put(ff.errno()).put(", offset=").put(this.offset).put("]");
                    }
                    lexer.parseExactLines(fileBufAddr, fileBufAddr + n);
                }
            }
            finally {
                ff.close(fd);
            }
        }

        private void logError(long offset, int column, DirectByteCharSequence dbcs) {
            LOG.error().$("type syntax [type=").$(ColumnType.nameOf(this.types.getQuick(column).getType())).$(", offset=").$(offset).$(", column=").$(column).$(", value='").$(dbcs).$("']").$();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void mergePartitionIndexAndImportData(FilesFacade ff, IOURingFacade rf, boolean ioURingEnabled, Path partitionPath, AbstractTextLexer lexer, long fileBufAddr, long fileBufSize, DirectCharSink utf8Sink, DirectLongList unmergedIndexes, Path tmpPath) throws TextException {
            unmergedIndexes.clear();
            partitionPath.slash$();
            int partitionLen = partitionPath.length();
            long mergedIndexSize = -1L;
            long mergeIndexAddr = 0L;
            int fd = -1;
            try {
                mergedIndexSize = this.openIndexChunks(ff, partitionPath, unmergedIndexes, partitionLen);
                if (unmergedIndexes.size() > 2L) {
                    partitionPath.trimTo(partitionLen);
                    partitionPath.concat(CsvFileIndexer.INDEX_FILE_NAME).$();
                    fd = TableUtils.openFileRWOrFail(ff, partitionPath, 0L);
                    mergeIndexAddr = TableUtils.mapRW(ff, fd, mergedIndexSize, 33);
                    Vect.mergeLongIndexesAsc(unmergedIndexes.getAddress(), (int)unmergedIndexes.size() / 2, mergeIndexAddr);
                    this.unmap(ff, unmergedIndexes);
                    this.importPartitionData(rf, ioURingEnabled, lexer, mergeIndexAddr, mergedIndexSize, fileBufAddr, fileBufSize, utf8Sink, tmpPath);
                } else {
                    this.importPartitionData(rf, ioURingEnabled, lexer, unmergedIndexes.get(0L), mergedIndexSize, fileBufAddr, fileBufSize, utf8Sink, tmpPath);
                }
            }
            finally {
                ff.close(fd);
                ff.munmap(mergeIndexAddr, mergedIndexSize, 33);
                this.unmap(ff, unmergedIndexes);
            }
        }

        private boolean onField(long offset, DirectByteCharSequence dbcs, TableWriter.Row w, int fieldIndex) throws TextException {
            TypeAdapter type = this.types.getQuick(fieldIndex);
            try {
                type.write(w, fieldIndex, dbcs, this.utf8Sink);
            }
            catch (ImplicitCastException | Utf8Exception | NumericException ignore) {
                ++this.errors;
                this.logError(offset, fieldIndex, dbcs);
                switch (this.atomicity) {
                    case 0: {
                        this.tableWriterRef.rollback();
                        throw TextException.$("bad syntax [line offset=").put(offset).put(",column=").put(fieldIndex).put(']');
                    }
                    case 1: {
                        w.cancel();
                        return true;
                    }
                }
            }
            catch (Exception e) {
                throw TextException.$("unexpected error [line offset=").put(offset).put(",column=").put(fieldIndex).put(",message=").put(e.getMessage()).put(']');
            }
            return false;
        }

        private void onFieldsPartitioned(long line, ObjList<DirectByteCharSequence> values, int valuesLength) {
            assert (this.tableWriterRef != null);
            DirectByteCharSequence dbcs = values.getQuick(this.timestampIndex);
            TableWriter.Row w = this.getRow(dbcs, this.offset);
            if (w == null) {
                return;
            }
            for (int i = 0; i < valuesLength; ++i) {
                dbcs = values.getQuick(i);
                if (i == this.timestampIndex || dbcs.length() == 0 || !this.onField(this.offset, dbcs, w, i)) continue;
                return;
            }
            w.append();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private long openIndexChunks(FilesFacade ff, Path partitionPath, DirectLongList mergeIndexes, int partitionLen) {
            long mergedIndexSize = 0L;
            long chunk = ff.findFirst(partitionPath);
            if (chunk > 0L) {
                try {
                    do {
                        long chunkName = ff.findName(chunk);
                        long chunkType = ff.findType(chunk);
                        if (chunkType != 8L) continue;
                        partitionPath.trimTo(partitionLen);
                        partitionPath.concat(chunkName).$();
                        int fd = TableUtils.openRO(ff, partitionPath, LOG);
                        long size = 0L;
                        long address = -1L;
                        try {
                            size = ff.length(fd);
                            if (size < 1L) {
                                throw TextException.$("index chunk is empty [path='").put(partitionPath).put(']');
                            }
                            address = TableUtils.mapRO(ff, fd, size, 33);
                            mergeIndexes.add(address);
                            mergeIndexes.add(size / 16L);
                            mergedIndexSize += size;
                        }
                        catch (Throwable t) {
                            if (address != -1L) {
                                ff.munmap(address, size, 33);
                            }
                            throw t;
                        }
                        finally {
                            ff.close(fd);
                        }
                    } while (ff.findNext(chunk) > 0);
                }
                finally {
                    ff.findClose(chunk);
                }
            }
            return mergedIndexSize;
        }

        private void parseLinesAndWrite(AbstractTextLexer lexer, long fileBufAddr, LongList offsets, int j) {
            long lo = fileBufAddr + offsets.getQuick(j * 2);
            long hi = lo + offsets.getQuick(j * 2 + 1);
            lexer.parseExactLines(lo, hi);
        }

        private void unmap(FilesFacade ff, DirectLongList mergeIndexes) {
            long sz = mergeIndexes.size() / 2L;
            for (long i = 0L; i < sz; ++i) {
                long addr = mergeIndexes.get(2L * i);
                long size = mergeIndexes.get(2L * i + 1L) * 16L;
                ff.munmap(addr, size, 33);
            }
            mergeIndexes.clear();
        }

        void of(CairoEngine cairoEngine, TableStructure targetTableStructure, ObjList<TypeAdapter> types, int atomicity, byte columnDelimiter, CharSequence importRoot, CharSequence inputFileName, int index, int lo, int hi, ObjList<ParallelCsvFileImporter.PartitionInfo> partitions) {
            this.cairoEngine = cairoEngine;
            this.targetTableStructure = targetTableStructure;
            this.types = types;
            this.atomicity = atomicity;
            this.columnDelimiter = columnDelimiter;
            this.importRoot = importRoot;
            this.inputFileName = inputFileName;
            this.index = index;
            this.lo = lo;
            this.hi = hi;
            this.partitions = partitions;
            this.timestampIndex = targetTableStructure.getTimestampIndex();
            this.timestampAdapter = this.timestampIndex > -1 && this.timestampIndex < types.size() ? (TimestampAdapter)types.getQuick(this.timestampIndex) : null;
            this.errors = 0L;
            this.importedRows.clear();
        }
    }

    public class PhaseIndexing {
        private final LongList partitionKeysAndSizes = new LongList();
        private TimestampAdapter adapter;
        private int atomicity;
        private long chunkEnd;
        private long chunkStart;
        private byte columnDelimiter;
        private long errorCount;
        private boolean ignoreHeader;
        private CharSequence importRoot;
        private int index;
        private CharSequence inputFileName;
        private long lineCount;
        private long lineNumber;
        private int partitionBy;
        private int timestampIndex;

        public void clear() {
            this.chunkStart = -1L;
            this.chunkEnd = -1L;
            this.lineNumber = -1L;
            this.lineCount = 0L;
            this.errorCount = 0L;
            this.index = -1;
            this.inputFileName = null;
            this.importRoot = null;
            this.partitionBy = -1;
            this.columnDelimiter = (byte)-1;
            this.timestampIndex = -1;
            this.adapter = null;
            this.ignoreHeader = false;
            this.atomicity = -1;
        }

        public long getErrorCount() {
            return this.errorCount;
        }

        public long getLineCount() {
            return this.lineCount;
        }

        public LongList getPartitionKeysAndSizes() {
            return this.partitionKeysAndSizes;
        }

        public void of(long chunkStart, long chunkEnd, long lineNumber, int index, CharSequence inputFileName, CharSequence importRoot, int partitionBy, byte columnDelimiter, int timestampIndex, TimestampAdapter adapter, boolean ignoreHeader, int atomicity) {
            assert (chunkStart >= 0L && chunkEnd > chunkStart);
            assert (lineNumber >= 0L);
            this.chunkStart = chunkStart;
            this.chunkEnd = chunkEnd;
            this.lineNumber = lineNumber;
            this.index = index;
            this.inputFileName = inputFileName;
            this.importRoot = importRoot;
            this.partitionBy = partitionBy;
            this.columnDelimiter = columnDelimiter;
            this.timestampIndex = timestampIndex;
            this.adapter = adapter;
            this.ignoreHeader = ignoreHeader;
            this.atomicity = atomicity;
        }

        public void run(CsvFileIndexer indexer, long fileBufAddr, long fileBufSize) throws TextException {
            try {
                indexer.of(this.inputFileName, this.importRoot, this.index, this.partitionBy, this.columnDelimiter, this.timestampIndex, this.adapter, this.ignoreHeader, this.atomicity, TextImportTask.this.circuitBreaker);
                indexer.index(this.chunkStart, this.chunkEnd, this.lineNumber, this.partitionKeysAndSizes, fileBufAddr, fileBufSize);
                this.lineCount = indexer.getLineCount();
                this.errorCount = indexer.getErrorCount();
            }
            catch (TextException e) {
                if (indexer.isCancelled()) {
                    throw TextImportTask.this.getCancelException();
                }
                throw e;
            }
            finally {
                indexer.clear();
            }
        }
    }

    public static class PhaseUpdateSymbolKeys {
        CharSequence columnName;
        int index;
        long partitionSize;
        long partitionTimestamp;
        CharSequence root;
        int symbolCount;
        private CairoEngine cairoEngine;
        private TableStructure tableStructure;

        public void clear() {
            this.cairoEngine = null;
            this.tableStructure = null;
            this.index = -1;
            this.partitionSize = -1L;
            this.partitionTimestamp = -1L;
            this.root = null;
            this.columnName = null;
            this.symbolCount = -1;
        }

        public void of(CairoEngine cairoEngine, TableStructure tableStructure, int index, long partitionSize, long partitionTimestamp, CharSequence root, CharSequence columnName, int symbolCount) {
            this.cairoEngine = cairoEngine;
            this.tableStructure = tableStructure;
            this.index = index;
            this.partitionSize = partitionSize;
            this.partitionTimestamp = partitionTimestamp;
            this.root = root;
            this.columnName = columnName;
            this.symbolCount = symbolCount;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run(Path path) {
            FilesFacade ff = this.cairoEngine.getConfiguration().getFilesFacade();
            TableToken tableToken = this.cairoEngine.getTableToken(this.tableStructure.getTableName());
            path.of(this.root).concat(tableToken.getTableName()).put('_').put(this.index);
            int plen = path.length();
            PartitionBy.setSinkForPartition(path.slash(), this.tableStructure.getPartitionBy(), this.partitionTimestamp, false);
            path.concat(this.columnName).put(".d");
            long columnMemory = 0L;
            long columnMemorySize = 0L;
            long remapTableMemory = 0L;
            long remapTableMemorySize = 0L;
            int columnFd = -1;
            int remapFd = -1;
            try {
                columnFd = TableUtils.openFileRWOrFail(ff, path.$(), 0L);
                columnMemorySize = ff.length(columnFd);
                path.trimTo(plen);
                path.concat(this.columnName).put(".r");
                remapFd = TableUtils.openFileRWOrFail(ff, path.$(), 0L);
                remapTableMemorySize = ff.length(remapFd);
                if (columnMemorySize >= 4L && remapTableMemorySize >= 4L) {
                    columnMemory = TableUtils.mapRW(ff, columnFd, columnMemorySize, 33);
                    remapTableMemory = TableUtils.mapRW(ff, remapFd, remapTableMemorySize, 33);
                    long columnMemSize = this.partitionSize * 4L;
                    long remapMemSize = (long)this.symbolCount * 4L;
                    ColumnUtils.symbolColumnUpdateKeys(columnMemory, columnMemSize, remapTableMemory, remapMemSize);
                }
            }
            finally {
                ff.close(columnFd);
                ff.close(remapFd);
                if (columnMemory > 0L) {
                    ff.munmap(columnMemory, columnMemorySize, 33);
                }
                if (remapTableMemory > 0L) {
                    ff.munmap(remapTableMemory, remapTableMemorySize, 33);
                }
            }
        }
    }

    public static class PhaseSymbolTableMerge {
        private CairoConfiguration cfg;
        private CharSequence column;
        private int columnIndex;
        private CharSequence importRoot;
        private int partitionBy;
        private int symbolColumnIndex;
        private TableToken tableToken;
        private int tmpTableCount;
        private TableWriter writer;

        public void clear() {
            this.cfg = null;
            this.importRoot = null;
            this.writer = null;
            this.tableToken = null;
            this.column = null;
            this.columnIndex = -1;
            this.symbolColumnIndex = -1;
            this.tmpTableCount = -1;
            this.partitionBy = -1;
        }

        public void of(CairoConfiguration cfg, CharSequence importRoot, TableWriter writer, TableToken tableToken, CharSequence column, int columnIndex, int symbolColumnIndex, int tmpTableCount, int partitionBy) {
            this.cfg = cfg;
            this.importRoot = importRoot;
            this.writer = writer;
            this.tableToken = tableToken;
            this.column = column;
            this.columnIndex = columnIndex;
            this.symbolColumnIndex = symbolColumnIndex;
            this.tmpTableCount = tmpTableCount;
            this.partitionBy = partitionBy;
        }

        public void run(Path path) {
            FilesFacade ff = this.cfg.getFilesFacade();
            path.of(this.importRoot).concat(this.tableToken.getTableName());
            int plen = path.length();
            for (int i = 0; i < this.tmpTableCount; ++i) {
                path.trimTo(plen);
                path.put('_').put(i);
                int tableLen = path.length();
                try (TxReader txFile = new TxReader(ff).ofRO(path.concat("_txn").$(), this.partitionBy);){
                    path.trimTo(tableLen);
                    txFile.unsafeLoadAll();
                    int symbolCount = txFile.getSymbolValueCount(this.symbolColumnIndex);
                    try (SymbolMapReaderImpl reader = new SymbolMapReaderImpl(this.cfg, path, this.column, -1L, symbolCount);
                         MemoryCMARW mem = Vm.getSmallCMARWInstance(ff, path.concat(this.column).put(".r").$(), 33, this.cfg.getWriterFileOpenOpts());){
                        SymbolMapWriter.mergeSymbols(this.writer.getSymbolMapWriter(this.columnIndex), reader, mem);
                        continue;
                    }
                }
            }
        }
    }

    public static class PhaseBuildSymbolIndex {
        private final StringSink tableNameSink = new StringSink();
        private CairoEngine cairoEngine;
        private int index;
        private RecordMetadata metadata;
        private CharSequence root;
        private TableStructure tableStructure;

        public void clear() {
            this.cairoEngine = null;
            this.tableStructure = null;
            this.root = null;
            this.index = -1;
            this.metadata = null;
        }

        public void of(CairoEngine cairoEngine, TableStructure tableStructure, CharSequence root, int index, RecordMetadata metadata) {
            this.cairoEngine = cairoEngine;
            this.tableStructure = tableStructure;
            this.root = root;
            this.index = index;
            this.metadata = metadata;
        }

        public void run() {
            CairoConfiguration configuration = this.cairoEngine.getConfiguration();
            this.tableNameSink.clear();
            this.tableNameSink.put(this.tableStructure.getTableName()).put('_').put(this.index);
            String tableName = this.tableNameSink.toString();
            TableToken tableToken = new TableToken(tableName, tableName, (int)this.cairoEngine.getTableIdGenerator().getNextId(), false);
            int columnCount = this.metadata.getColumnCount();
            try (TableWriter w = new TableWriter(configuration, tableToken, this.cairoEngine.getMessageBus(), null, true, DefaultLifecycleManager.INSTANCE, this.root, this.cairoEngine.getMetrics());){
                for (int i = 0; i < columnCount; ++i) {
                    if (!this.metadata.isColumnIndexed(i)) continue;
                    w.addIndex(this.metadata.getColumnName(i), this.metadata.getIndexValueBlockCapacity(i));
                }
            }
        }
    }

    public static class PhaseBoundaryCheck {
        private long chunkEnd;
        private long chunkStart;
        private FilesFacade ff;
        private long newLineCountEven;
        private long newLineCountOdd;
        private long newLineOffsetEven;
        private long newLineOffsetOdd;
        private Path path;
        private long quoteCount;

        public void clear() {
            this.ff = null;
            this.path = null;
            this.chunkStart = -1L;
            this.chunkEnd = -1L;
        }

        public long getNewLineCountEven() {
            return this.newLineCountEven;
        }

        public long getNewLineCountOdd() {
            return this.newLineCountOdd;
        }

        public long getNewLineOffsetEven() {
            return this.newLineOffsetEven;
        }

        public long getNewLineOffsetOdd() {
            return this.newLineOffsetOdd;
        }

        public long getQuoteCount() {
            return this.quoteCount;
        }

        public void of(FilesFacade ff, Path path, long chunkStart, long chunkEnd) {
            assert (ff != null);
            assert (path != null);
            assert (chunkStart >= 0L && chunkEnd > chunkStart);
            this.ff = ff;
            this.path = path;
            this.chunkStart = chunkStart;
            this.chunkEnd = chunkEnd;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run(long fileBufPtr, long fileBufSize) throws TextException {
            long offset = this.chunkStart;
            long quotes = 0L;
            long[] nlCount = new long[2];
            long[] nlFirst = new long[]{-1L, -1L};
            int fd = TableUtils.openRO(this.ff, this.path, LOG);
            this.ff.fadvise(fd, this.chunkStart, this.chunkEnd - this.chunkStart, Files.POSIX_FADV_SEQUENTIAL);
            try {
                long leftToRead;
                long read;
                while ((read = (long)((int)this.ff.read(fd, fileBufPtr, leftToRead = Math.min(this.chunkEnd - offset, fileBufSize), offset))) >= 1L) {
                    long hi = fileBufPtr + read;
                    long ptr = fileBufPtr;
                    while (ptr < hi) {
                        byte c = Unsafe.getUnsafe().getByte(ptr++);
                        if (c == 34) {
                            ++quotes;
                            continue;
                        }
                        if (c != 10) continue;
                        int n = (int)(quotes & 1L);
                        nlCount[n] = nlCount[n] + 1L;
                        if (nlFirst[(int)(quotes & 1L)] != -1L) continue;
                        nlFirst[(int)(quotes & 1L)] = offset + (ptr - fileBufPtr);
                    }
                    if ((offset += read) < this.chunkEnd) continue;
                }
                if (read < 0L || offset < this.chunkEnd) {
                    throw TextException.$("could not read import file [path='").put(this.path).put("', offset=").put(offset).put(", errno=").put(this.ff.errno()).put(']');
                }
            }
            finally {
                this.ff.close(fd);
            }
            this.quoteCount = quotes;
            this.newLineCountEven = nlCount[0];
            this.newLineCountOdd = nlCount[1];
            this.newLineOffsetEven = nlFirst[0];
            this.newLineOffsetOdd = nlFirst[1];
        }
    }
}

