/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cutlass.text.types;

import io.questdb.cairo.TableWriter;
import io.questdb.cutlass.text.types.AbstractTypeAdapter;
import io.questdb.griffin.SqlKeywords;
import io.questdb.std.str.DirectByteCharSequence;

public final class BooleanAdapter
extends AbstractTypeAdapter {
    public static final BooleanAdapter INSTANCE = new BooleanAdapter();

    private BooleanAdapter() {
    }

    @Override
    public int getType() {
        return 1;
    }

    @Override
    public boolean probe(DirectByteCharSequence text) {
        return SqlKeywords.isTrueKeyword(text) || SqlKeywords.isFalseKeyword(text);
    }

    @Override
    public void write(TableWriter.Row row, int column, DirectByteCharSequence value) {
        row.putBool(column, SqlKeywords.isTrueKeyword(value));
    }
}

