/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.cast;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.griffin.FunctionFactory;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.cast.AbstractCastToDateFunction;
import io.questdb.std.IntList;
import io.questdb.std.ObjList;

public class CastCharToDateFunctionFactory
implements FunctionFactory {
    @Override
    public String getSignature() {
        return "cast(Am)";
    }

    @Override
    public Function newInstance(int position, ObjList<Function> args, IntList argPositions, CairoConfiguration configuration, SqlExecutionContext sqlExecutionContext) {
        return new CastCharToDateFunction(args.getQuick(0));
    }

    public static class CastCharToDateFunction
    extends AbstractCastToDateFunction {
        private final Function arg;

        public CastCharToDateFunction(Function arg) {
            this.arg = arg;
        }

        @Override
        public Function getArg() {
            return this.arg;
        }

        @Override
        public long getDate(Record rec) {
            byte v = (byte)(this.arg.getChar(rec) - 48);
            return v > -1 && v < 10 ? (long)v : Long.MIN_VALUE;
        }
    }
}

