/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.columns;

import io.questdb.cairo.sql.Record;
import io.questdb.cairo.sql.ScalarFunction;
import io.questdb.griffin.PlanSink;
import io.questdb.griffin.engine.functions.CharFunction;
import io.questdb.std.ObjList;

public class CharColumn
extends CharFunction
implements ScalarFunction {
    private static final ObjList<CharColumn> COLUMNS = new ObjList(32);
    private final int columnIndex;

    public CharColumn(int columnIndex) {
        this.columnIndex = columnIndex;
    }

    public static CharColumn newInstance(int columnIndex) {
        if (columnIndex < 32) {
            return COLUMNS.getQuick(columnIndex);
        }
        return new CharColumn(columnIndex);
    }

    @Override
    public char getChar(Record rec) {
        return rec.getChar(this.columnIndex);
    }

    @Override
    public boolean isReadThreadSafe() {
        return true;
    }

    @Override
    public void toPlan(PlanSink sink) {
        sink.putColumnName(this.columnIndex);
    }

    static {
        COLUMNS.setPos(32);
        for (int i = 0; i < 32; ++i) {
            COLUMNS.setQuick(i, new CharColumn(i));
        }
    }
}

