/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.rnd;

import io.questdb.cairo.AbstractRecordCursorFactory;
import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.ColumnType;
import io.questdb.cairo.GenericRecordMetadata;
import io.questdb.cairo.TableColumnMetadata;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.cairo.sql.RecordCursor;
import io.questdb.cairo.sql.RecordMetadata;
import io.questdb.griffin.FunctionFactory;
import io.questdb.griffin.PlanSink;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.CursorFunction;
import io.questdb.std.IntList;
import io.questdb.std.ObjList;
import io.questdb.std.Rnd;

public class LongSequenceFunctionFactory
implements FunctionFactory {
    private static final RecordMetadata METADATA;

    @Override
    public String getSignature() {
        return "long_sequence(v)";
    }

    @Override
    public Function newInstance(int position, ObjList<Function> args, IntList argPositions, CairoConfiguration configuration, SqlExecutionContext sqlExecutionContext) throws SqlException {
        if (args != null) {
            Function seedHiFunc;
            Function seedLoFunc;
            Function countFunc;
            int argCount = args.size();
            if (argCount == 1 && ColumnType.isAssignableFrom((countFunc = args.getQuick(0)).getType(), 6)) {
                return new CursorFunction(new LongSequenceCursorFactory(METADATA, countFunc.getLong(null)));
            }
            if (argCount > 2 && ColumnType.isAssignableFrom((countFunc = args.getQuick(0)).getType(), 6) && ColumnType.isAssignableFrom((seedLoFunc = args.getQuick(1)).getType(), 6) && ColumnType.isAssignableFrom((seedHiFunc = args.getQuick(2)).getType(), 6)) {
                return new CursorFunction(new SeedingLongSequenceCursorFactory(METADATA, countFunc.getLong(null), seedLoFunc.getLong(null), seedHiFunc.getLong(null)));
            }
        }
        throw SqlException.position(position).put("invalid arguments");
    }

    static {
        GenericRecordMetadata metadata = new GenericRecordMetadata();
        metadata.add(new TableColumnMetadata("x", 6));
        METADATA = metadata;
    }

    private static class SeedingLongSequenceCursorFactory
    extends AbstractRecordCursorFactory {
        private final LongSequenceRecordCursor cursor;
        private final Rnd rnd;
        private final long seedHi;
        private final long seedLo;

        public SeedingLongSequenceCursorFactory(RecordMetadata metadata, long recordCount, long seedLo, long seedHi) {
            super(metadata);
            this.cursor = new LongSequenceRecordCursor(Math.max(0L, recordCount));
            this.seedLo = seedLo;
            this.seedHi = seedHi;
            this.rnd = new Rnd(this.seedLo, this.seedHi);
        }

        @Override
        public RecordCursor getCursor(SqlExecutionContext executionContext) {
            this.rnd.reset(this.seedLo, this.seedHi);
            executionContext.setRandom(this.rnd);
            this.cursor.toTop();
            return this.cursor;
        }

        @Override
        public boolean recordCursorSupportsRandomAccess() {
            return true;
        }

        @Override
        public void toPlan(PlanSink sink) {
            sink.type("long_sequence");
            sink.meta("count").val(this.cursor.recordCount);
            sink.meta("seedLo").val(this.seedLo);
            sink.meta("seedHi").val(this.seedHi);
        }
    }

    static class LongSequenceRecordCursor
    implements RecordCursor {
        private final LongSequenceRecord recordA = new LongSequenceRecord();
        private final LongSequenceRecord recordB = new LongSequenceRecord();
        private final long recordCount;

        public LongSequenceRecordCursor(long recordCount) {
            this.recordCount = recordCount;
            this.recordA.of(0L);
        }

        @Override
        public void close() {
        }

        @Override
        public Record getRecord() {
            return this.recordA;
        }

        @Override
        public Record getRecordB() {
            return this.recordB;
        }

        @Override
        public boolean hasNext() {
            if (this.recordA.getValue() < this.recordCount) {
                this.recordA.next();
                return true;
            }
            return false;
        }

        @Override
        public void recordAt(Record record, long atRowId) {
            ((LongSequenceRecord)record).of(atRowId);
        }

        @Override
        public long size() {
            return this.recordCount;
        }

        @Override
        public void toTop() {
            this.recordA.of(0L);
        }
    }

    static class LongSequenceRecord
    implements Record {
        private long value;

        LongSequenceRecord() {
        }

        @Override
        public long getLong(int col) {
            return this.value;
        }

        @Override
        public long getRowId() {
            return this.value;
        }

        long getValue() {
            return this.value;
        }

        void next() {
            ++this.value;
        }

        void of(long value) {
            this.value = value;
        }
    }

    private static class LongSequenceCursorFactory
    extends AbstractRecordCursorFactory {
        private final LongSequenceRecordCursor cursor;

        public LongSequenceCursorFactory(RecordMetadata metadata, long recordCount) {
            super(metadata);
            this.cursor = new LongSequenceRecordCursor(Math.max(0L, recordCount));
        }

        @Override
        public RecordCursor getCursor(SqlExecutionContext executionContext) {
            this.cursor.toTop();
            return this.cursor;
        }

        @Override
        public boolean recordCursorSupportsRandomAccess() {
            return true;
        }

        @Override
        public void toPlan(PlanSink sink) {
            sink.type("long_sequence");
            sink.meta("count").val(this.cursor.recordCount);
        }
    }
}

