/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.join;

import io.questdb.cairo.AbstractRecordCursorFactory;
import io.questdb.cairo.sql.Record;
import io.questdb.cairo.sql.RecordCursor;
import io.questdb.cairo.sql.RecordCursorFactory;
import io.questdb.cairo.sql.RecordMetadata;
import io.questdb.griffin.PlanSink;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.join.AbstractJoinCursor;
import io.questdb.griffin.engine.join.JoinRecordMetadata;
import io.questdb.griffin.engine.join.NullRecordFactory;
import io.questdb.griffin.engine.join.OuterJoinRecord;
import io.questdb.std.Misc;

public class LtJoinNoKeyRecordCursorFactory
extends AbstractRecordCursorFactory {
    private final LtJoinNoKeyJoinRecordCursor cursor;
    private final RecordCursorFactory masterFactory;
    private final RecordCursorFactory slaveFactory;

    public LtJoinNoKeyRecordCursorFactory(RecordMetadata metadata, RecordCursorFactory masterFactory, RecordCursorFactory slaveFactory, int columnSplit) {
        super(metadata);
        this.masterFactory = masterFactory;
        this.slaveFactory = slaveFactory;
        this.cursor = new LtJoinNoKeyJoinRecordCursor(columnSplit, NullRecordFactory.getInstance(slaveFactory.getMetadata()), masterFactory.getMetadata().getTimestampIndex(), slaveFactory.getMetadata().getTimestampIndex());
    }

    @Override
    public RecordCursor getCursor(SqlExecutionContext executionContext) throws SqlException {
        RecordCursor masterCursor = this.masterFactory.getCursor(executionContext);
        RecordCursor slaveCursor = null;
        try {
            slaveCursor = this.slaveFactory.getCursor(executionContext);
            this.cursor.of(masterCursor, slaveCursor);
            return this.cursor;
        }
        catch (Throwable e) {
            Misc.free(slaveCursor);
            Misc.free(masterCursor);
            throw e;
        }
    }

    @Override
    public boolean hasDescendingOrder() {
        return this.masterFactory.hasDescendingOrder();
    }

    @Override
    public boolean recordCursorSupportsRandomAccess() {
        return false;
    }

    @Override
    public void toPlan(PlanSink sink) {
        sink.type("Lt Join");
        sink.child(this.masterFactory);
        sink.child(this.slaveFactory);
    }

    @Override
    protected void _close() {
        ((JoinRecordMetadata)this.getMetadata()).close();
        this.masterFactory.close();
        this.slaveFactory.close();
    }

    private static class LtJoinNoKeyJoinRecordCursor
    extends AbstractJoinCursor {
        private final int masterTimestampIndex;
        private final OuterJoinRecord record;
        private final int slaveTimestampIndex;
        private long latestSlaveRowID = Long.MIN_VALUE;
        private Record masterRecord;
        private Record slaveRecA;
        private Record slaveRecB;
        private long slaveTimestamp = Long.MIN_VALUE;

        public LtJoinNoKeyJoinRecordCursor(int columnSplit, Record nullRecord, int masterTimestampIndex, int slaveTimestampIndex) {
            super(columnSplit);
            this.record = new OuterJoinRecord(columnSplit, nullRecord);
            this.masterTimestampIndex = masterTimestampIndex;
            this.slaveTimestampIndex = slaveTimestampIndex;
        }

        @Override
        public Record getRecord() {
            return this.record;
        }

        @Override
        public boolean hasNext() {
            if (this.masterCursor.hasNext()) {
                long masterTimestamp = this.masterRecord.getTimestamp(this.masterTimestampIndex);
                this.nextSlave(masterTimestamp);
                return true;
            }
            return false;
        }

        @Override
        public long size() {
            return this.masterCursor.size();
        }

        @Override
        public void toTop() {
            this.slaveTimestamp = Long.MIN_VALUE;
            this.latestSlaveRowID = Long.MIN_VALUE;
            this.record.hasSlave(false);
            this.masterCursor.toTop();
            this.slaveCursor.toTop();
        }

        private void nextSlave(long masterTimestamp) {
            long slaveTimestamp = this.slaveTimestamp;
            this.positionSlaveRecB();
            if (slaveTimestamp <= masterTimestamp) {
                this.overScrollSlave(masterTimestamp, slaveTimestamp);
            }
        }

        private void of(RecordCursor masterCursor, RecordCursor slaveCursor) {
            this.slaveTimestamp = Long.MIN_VALUE;
            this.latestSlaveRowID = Long.MIN_VALUE;
            this.masterCursor = masterCursor;
            this.slaveCursor = slaveCursor;
            this.masterRecord = masterCursor.getRecord();
            this.slaveRecA = slaveCursor.getRecord();
            this.slaveRecB = slaveCursor.getRecordB();
            this.record.of(this.masterRecord, this.slaveRecB);
            this.record.hasSlave(false);
        }

        private void overScrollSlave(long masterTimestamp, long slaveTimestamp) {
            block2: {
                this.latestSlaveRowID = this.slaveRecA.getRowId();
                this.slaveTimestamp = slaveTimestamp;
                while (this.slaveCursor.hasNext()) {
                    slaveTimestamp = this.slaveRecA.getTimestamp(this.slaveTimestampIndex);
                    if (slaveTimestamp < masterTimestamp) {
                        this.record.hasSlave(true);
                        this.slaveCursor.recordAt(this.slaveRecB, this.latestSlaveRowID);
                        this.latestSlaveRowID = this.slaveRecA.getRowId();
                        this.slaveTimestamp = slaveTimestamp;
                        continue;
                    }
                    this.latestSlaveRowID = this.slaveRecA.getRowId();
                    this.slaveTimestamp = slaveTimestamp;
                    break block2;
                }
                this.record.hasSlave(true);
                this.slaveCursor.recordAt(this.slaveRecB, this.latestSlaveRowID);
                this.slaveTimestamp = Long.MAX_VALUE;
            }
        }

        private void positionSlaveRecB() {
            if (this.latestSlaveRowID != Long.MIN_VALUE) {
                this.record.hasSlave(true);
                this.slaveCursor.recordAt(this.slaveRecB, this.latestSlaveRowID);
            }
        }
    }
}

