/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.table;

import io.questdb.cairo.sql.PageAddressCacheRecord;
import io.questdb.cairo.sql.Record;
import io.questdb.cairo.sql.RecordCursor;
import io.questdb.cairo.sql.SymbolTable;
import io.questdb.cairo.sql.async.PageFrameReduceTask;
import io.questdb.cairo.sql.async.PageFrameSequence;
import io.questdb.log.Log;
import io.questdb.log.LogFactory;
import io.questdb.std.DirectLongList;
import io.questdb.std.Misc;
import io.questdb.std.Os;
import io.questdb.std.Rows;

class AsyncFilteredNegativeLimitRecordCursor
implements RecordCursor {
    private static final Log LOG = LogFactory.getLog(AsyncFilteredNegativeLimitRecordCursor.class);
    private final PageAddressCacheRecord record = new PageAddressCacheRecord();
    private int frameIndex;
    private int frameLimit;
    private PageFrameSequence<?> frameSequence;
    private PageAddressCacheRecord recordB;
    private long rowCount;
    private long rowIndex;
    private long rowLimit;
    private DirectLongList rows;

    @Override
    public void close() {
        LOG.debug().$("closing [shard=").$(this.frameSequence.getShard()).$(", frameCount=").$(this.frameLimit).I$();
        if (this.frameLimit > -1) {
            this.frameSequence.await();
        }
        this.frameSequence.clear();
    }

    public void freeRecords() {
        Misc.free(this.record);
        Misc.free(this.recordB);
    }

    @Override
    public Record getRecord() {
        return this.record;
    }

    @Override
    public Record getRecordB() {
        if (this.recordB != null) {
            return this.recordB;
        }
        this.recordB = new PageAddressCacheRecord(this.record);
        return this.recordB;
    }

    @Override
    public SymbolTable getSymbolTable(int columnIndex) {
        return this.frameSequence.getSymbolTableSource().getSymbolTable(columnIndex);
    }

    @Override
    public boolean hasNext() {
        if (this.frameIndex == -1 && this.frameLimit > -1) {
            this.fetchAllFrames();
        }
        if (this.rowIndex < this.rows.getCapacity()) {
            long rowId = this.rows.get(this.rowIndex);
            this.record.setRowIndex(Rows.toLocalRowID(rowId));
            this.record.setFrameIndex(Rows.toPartitionIndex(rowId));
            ++this.rowIndex;
            return true;
        }
        return false;
    }

    @Override
    public SymbolTable newSymbolTable(int columnIndex) {
        return this.frameSequence.getSymbolTableSource().newSymbolTable(columnIndex);
    }

    @Override
    public void recordAt(Record record, long atRowId) {
        ((PageAddressCacheRecord)record).setFrameIndex(Rows.toPartitionIndex(atRowId));
        ((PageAddressCacheRecord)record).setRowIndex(Rows.toLocalRowID(atRowId));
    }

    @Override
    public long size() {
        return this.rowCount;
    }

    @Override
    public void toTop() {
        this.rowIndex = this.rows.getCapacity() - this.rowCount;
    }

    private void fetchAllFrames() {
        do {
            long cursor;
            if ((cursor = this.frameSequence.next()) > -1L) {
                PageFrameReduceTask task = this.frameSequence.getTask(cursor);
                LOG.debug().$("collected [shard=").$(this.frameSequence.getShard()).$(", frameIndex=").$(task.getFrameIndex()).$(", frameCount=").$(this.frameSequence.getFrameCount()).$(", active=").$(this.frameSequence.isActive()).$(", cursor=").$(cursor).I$();
                DirectLongList frameRows = task.getRows();
                long frameRowCount = frameRows.size();
                this.frameIndex = task.getFrameIndex();
                if (frameRowCount > 0L && this.rowCount < this.rowLimit + 1L && this.frameSequence.isActive()) {
                    long i = frameRowCount - 1L;
                    while (i > -1L && this.rowCount < this.rowLimit) {
                        this.rows.set(--this.rowIndex, Rows.toRowID(this.frameIndex, frameRows.get(i)));
                        --i;
                        ++this.rowCount;
                    }
                    if (this.rowCount >= this.rowLimit) {
                        this.frameSequence.cancel();
                    }
                }
                this.frameSequence.collect(cursor, false);
                continue;
            }
            Os.pause();
        } while (this.frameIndex < this.frameLimit);
    }

    void of(PageFrameSequence<?> frameSequence, long rowLimit, DirectLongList negativeLimitRows) {
        this.frameSequence = frameSequence;
        this.frameIndex = -1;
        this.frameLimit = frameSequence.getFrameCount() - 1;
        this.rowLimit = rowLimit;
        this.rows = negativeLimitRows;
        this.rowIndex = negativeLimitRows.getCapacity();
        this.rowCount = 0L;
        this.record.of(frameSequence.getSymbolTableSource(), frameSequence.getPageAddressCache());
        if (this.recordB != null) {
            this.recordB.of(frameSequence.getSymbolTableSource(), frameSequence.getPageAddressCache());
        }
    }
}

