/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.table;

import io.questdb.cairo.CairoException;
import io.questdb.cairo.sql.Record;
import io.questdb.cairo.sql.RecordCursor;

final class StringLongTuplesRecordCursor
implements RecordCursor {
    private final TableWriterMetricsRecord record = new TableWriterMetricsRecord();
    private String[] keys;
    private int pos;
    private long[] values;

    StringLongTuplesRecordCursor() {
    }

    @Override
    public void close() {
    }

    @Override
    public Record getRecord() {
        return this.record;
    }

    @Override
    public Record getRecordB() {
        throw new UnsupportedOperationException("RecordB not supported");
    }

    @Override
    public boolean hasNext() {
        if (this.keys.length > this.pos + 1) {
            ++this.pos;
            return true;
        }
        return false;
    }

    public void of(String[] keys, long[] values) {
        assert (keys.length == values.length);
        this.keys = keys;
        this.values = values;
        this.toTop();
    }

    @Override
    public void recordAt(Record record, long atRowId) {
        throw new UnsupportedOperationException("random access not supported");
    }

    @Override
    public long size() {
        return this.keys.length;
    }

    @Override
    public void toTop() {
        this.pos = -1;
    }

    private class TableWriterMetricsRecord
    implements Record {
        private TableWriterMetricsRecord() {
        }

        @Override
        public long getLong(int col) {
            if (col != 1) {
                throw CairoException.nonCritical().put("unsupported long column number [column=").put(col).put("]");
            }
            return StringLongTuplesRecordCursor.this.values[StringLongTuplesRecordCursor.this.pos];
        }

        @Override
        public CharSequence getStr(int col) {
            if (col != 0) {
                throw CairoException.nonCritical().put("unsupported string column number [column=").put(col).put("]");
            }
            return StringLongTuplesRecordCursor.this.keys[StringLongTuplesRecordCursor.this.pos];
        }

        @Override
        public CharSequence getStrB(int col) {
            return this.getStr(col);
        }

        @Override
        public int getStrLen(int col) {
            if (col != 0) {
                throw CairoException.nonCritical().put("unsupported string column number [column=").put(col).put("]");
            }
            return this.getStr(col).length();
        }
    }
}

