/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.cluster.protocol.impl;

import java.io.IOException;
import java.util.Collection;
import java.util.Set;
import org.apache.nifi.cluster.coordination.node.NodeConnectionStatus;
import org.apache.nifi.cluster.protocol.ClusterCoordinationProtocolSender;
import org.apache.nifi.cluster.protocol.NodeIdentifier;
import org.apache.nifi.cluster.protocol.ProtocolException;
import org.apache.nifi.cluster.protocol.ProtocolHandler;
import org.apache.nifi.cluster.protocol.ProtocolListener;
import org.apache.nifi.cluster.protocol.message.DisconnectMessage;
import org.apache.nifi.cluster.protocol.message.NodeStatusChangeMessage;
import org.apache.nifi.cluster.protocol.message.OffloadMessage;
import org.apache.nifi.cluster.protocol.message.ReconnectionRequestMessage;
import org.apache.nifi.cluster.protocol.message.ReconnectionResponseMessage;
import org.apache.nifi.reporting.BulletinRepository;

public class ClusterCoordinationProtocolSenderListener
implements ClusterCoordinationProtocolSender,
ProtocolListener {
    private final ClusterCoordinationProtocolSender sender;
    private final ProtocolListener listener;

    public ClusterCoordinationProtocolSenderListener(ClusterCoordinationProtocolSender sender, ProtocolListener listener) {
        if (sender == null) {
            throw new IllegalArgumentException("ClusterManagerProtocolSender may not be null.");
        }
        if (listener == null) {
            throw new IllegalArgumentException("ProtocolListener may not be null.");
        }
        this.sender = sender;
        this.listener = listener;
    }

    @Override
    public void stop() throws IOException {
        if (!this.isRunning()) {
            throw new IllegalStateException("Instance is already stopped.");
        }
        this.listener.stop();
    }

    @Override
    public void start() throws IOException {
        if (this.isRunning()) {
            throw new IllegalStateException("Instance is already started.");
        }
        this.listener.start();
    }

    @Override
    public boolean isRunning() {
        return this.listener.isRunning();
    }

    @Override
    public boolean removeHandler(ProtocolHandler handler) {
        return this.listener.removeHandler(handler);
    }

    @Override
    public Collection<ProtocolHandler> getHandlers() {
        return this.listener.getHandlers();
    }

    @Override
    public void addHandler(ProtocolHandler handler) {
        this.listener.addHandler(handler);
    }

    @Override
    public void setBulletinRepository(BulletinRepository bulletinRepository) {
        this.listener.setBulletinRepository(bulletinRepository);
        this.sender.setBulletinRepository(bulletinRepository);
    }

    @Override
    public ReconnectionResponseMessage requestReconnection(ReconnectionRequestMessage msg) throws ProtocolException {
        return this.sender.requestReconnection(msg);
    }

    @Override
    public void offload(OffloadMessage msg) throws ProtocolException {
        this.sender.offload(msg);
    }

    @Override
    public void disconnect(DisconnectMessage msg) throws ProtocolException {
        this.sender.disconnect(msg);
    }

    @Override
    public void notifyNodeStatusChange(Set<NodeIdentifier> nodesToNotify, NodeStatusChangeMessage msg) {
        this.sender.notifyNodeStatusChange(nodesToNotify, msg);
    }

    @Override
    public NodeConnectionStatus requestNodeConnectionStatus(String hostname, int port) {
        return this.sender.requestNodeConnectionStatus(hostname, port);
    }
}

