/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.minifi.commons.schema;

import java.util.Map;
import org.apache.nifi.minifi.commons.schema.common.BaseSchema;
import org.apache.nifi.minifi.commons.schema.common.WritableSchema;

public class CorePropertiesSchema
extends BaseSchema
implements WritableSchema {
    public static final String FLOW_CONTROLLER_SHUTDOWN_PERIOD_KEY = "flow controller graceful shutdown period";
    public static final String FLOW_SERVICE_WRITE_DELAY_INTERVAL_KEY = "flow service write delay interval";
    public static final String ADMINISTRATIVE_YIELD_DURATION_KEY = "administrative yield duration";
    public static final String BORED_YIELD_DURATION_KEY = "bored yield duration";
    public static final String VARIABLE_REGISTRY_PROPERTIES_KEY = "variable registry properties";
    public static final String DEFAULT_FLOW_CONTROLLER_GRACEFUL_SHUTDOWN_PERIOD = "10 sec";
    public static final String DEFAULT_FLOW_SERVICE_WRITE_DELAY_INTERVAL = "500 ms";
    public static final String DEFAULT_ADMINISTRATIVE_YIELD_DURATION = "30 sec";
    public static final String DEFAULT_BORED_YIELD_DURATION = "10 millis";
    public static final int DEFAULT_MAX_CONCURRENT_THREADS = 1;
    public static final String DEFAULT_VARIABLE_REGISTRY_PROPERTIES = "";
    private String flowControllerGracefulShutdownPeriod = "10 sec";
    private String flowServiceWriteDelayInterval = "500 ms";
    private String administrativeYieldDuration = "30 sec";
    private String boredYieldDuration = "10 millis";
    private Number maxConcurrentThreads = 1;
    private String variableRegistryProperties = "";

    public CorePropertiesSchema() {
    }

    public CorePropertiesSchema(Map map) {
        this.flowControllerGracefulShutdownPeriod = this.getOptionalKeyAsType(map, FLOW_CONTROLLER_SHUTDOWN_PERIOD_KEY, String.class, "Core Properties", DEFAULT_FLOW_CONTROLLER_GRACEFUL_SHUTDOWN_PERIOD);
        this.flowServiceWriteDelayInterval = this.getOptionalKeyAsType(map, FLOW_SERVICE_WRITE_DELAY_INTERVAL_KEY, String.class, "Core Properties", DEFAULT_FLOW_SERVICE_WRITE_DELAY_INTERVAL);
        this.administrativeYieldDuration = this.getOptionalKeyAsType(map, ADMINISTRATIVE_YIELD_DURATION_KEY, String.class, "Core Properties", DEFAULT_ADMINISTRATIVE_YIELD_DURATION);
        this.boredYieldDuration = this.getOptionalKeyAsType(map, BORED_YIELD_DURATION_KEY, String.class, "Core Properties", DEFAULT_BORED_YIELD_DURATION);
        this.maxConcurrentThreads = this.getOptionalKeyAsType(map, "max concurrent threads", Number.class, "Core Properties", 1);
        this.variableRegistryProperties = this.getOptionalKeyAsType(map, VARIABLE_REGISTRY_PROPERTIES_KEY, String.class, "Core Properties", DEFAULT_VARIABLE_REGISTRY_PROPERTIES);
    }

    @Override
    public Map<String, Object> toMap() {
        Map result = (Map)this.mapSupplier.get();
        result.put(FLOW_CONTROLLER_SHUTDOWN_PERIOD_KEY, this.flowControllerGracefulShutdownPeriod);
        result.put(FLOW_SERVICE_WRITE_DELAY_INTERVAL_KEY, this.flowServiceWriteDelayInterval);
        result.put(ADMINISTRATIVE_YIELD_DURATION_KEY, this.administrativeYieldDuration);
        result.put(BORED_YIELD_DURATION_KEY, this.boredYieldDuration);
        result.put("max concurrent threads", this.maxConcurrentThreads);
        result.put(VARIABLE_REGISTRY_PROPERTIES_KEY, this.variableRegistryProperties);
        return result;
    }

    public String getFlowControllerGracefulShutdownPeriod() {
        return this.flowControllerGracefulShutdownPeriod;
    }

    public String getFlowServiceWriteDelayInterval() {
        return this.flowServiceWriteDelayInterval;
    }

    public String getAdministrativeYieldDuration() {
        return this.administrativeYieldDuration;
    }

    public String getBoredYieldDuration() {
        return this.boredYieldDuration;
    }

    public Number getMaxConcurrentThreads() {
        return this.maxConcurrentThreads;
    }

    public String getVariableRegistryProperties() {
        return this.variableRegistryProperties;
    }
}

