/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.controller.repository.metrics;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.nifi.controller.repository.FlowFileEvent;
import org.apache.nifi.controller.repository.metrics.EmptyFlowFileEvent;
import org.apache.nifi.controller.repository.metrics.StandardFlowFileEvent;

public class EventSumValue {
    private volatile boolean empty = true;
    private int flowFilesIn = 0;
    private int flowFilesOut = 0;
    private int flowFilesRemoved = 0;
    private int flowFilesReceived = 0;
    private int flowFilesSent = 0;
    private long contentSizeIn = 0L;
    private long contentSizeOut = 0L;
    private long contentSizeRemoved = 0L;
    private long bytesRead = 0L;
    private long bytesWritten = 0L;
    private long bytesReceived = 0L;
    private long bytesSent = 0L;
    private long processingNanos = 0L;
    private long cpuNanos = 0L;
    private long contentReadNanos = 0L;
    private long contentWriteNanos = 0L;
    private long sessionCommitNanos = 0L;
    private long gcMillis = 0L;
    private long aggregateLineageMillis = 0L;
    private int invocations = 0;
    private Map<String, Long> counters;
    private final long millisecondTimestamp;

    public EventSumValue(long timestamp) {
        this.millisecondTimestamp = timestamp;
    }

    public synchronized void add(FlowFileEvent flowFileEvent) {
        this.empty = false;
        this.aggregateLineageMillis += flowFileEvent.getAggregateLineageMillis();
        this.bytesRead += flowFileEvent.getBytesRead();
        this.bytesReceived += flowFileEvent.getBytesReceived();
        this.bytesSent += flowFileEvent.getBytesSent();
        this.bytesWritten += flowFileEvent.getBytesWritten();
        this.contentSizeIn += flowFileEvent.getContentSizeIn();
        this.contentSizeOut += flowFileEvent.getContentSizeOut();
        this.contentSizeRemoved += flowFileEvent.getContentSizeRemoved();
        this.flowFilesIn += flowFileEvent.getFlowFilesIn();
        this.flowFilesOut += flowFileEvent.getFlowFilesOut();
        this.flowFilesReceived += flowFileEvent.getFlowFilesReceived();
        this.flowFilesRemoved += flowFileEvent.getFlowFilesRemoved();
        this.flowFilesSent += flowFileEvent.getFlowFilesSent();
        this.invocations += flowFileEvent.getInvocations();
        this.processingNanos += flowFileEvent.getProcessingNanoseconds();
        this.cpuNanos += flowFileEvent.getCpuNanoseconds();
        this.contentReadNanos += flowFileEvent.getContentReadNanoseconds();
        this.contentWriteNanos += flowFileEvent.getContentWriteNanoseconds();
        this.gcMillis += flowFileEvent.getGargeCollectionMillis();
        this.sessionCommitNanos += flowFileEvent.getSessionCommitNanoseconds();
        Map eventCounters = flowFileEvent.getCounters();
        if (eventCounters != null) {
            for (Map.Entry entry : eventCounters.entrySet()) {
                String counterName = (String)entry.getKey();
                Long counterValue = (Long)entry.getValue();
                if (this.counters == null) {
                    this.counters = new HashMap<String, Long>();
                }
                this.counters.compute(counterName, (key, value) -> value == null ? counterValue : value + counterValue);
            }
        }
    }

    public synchronized FlowFileEvent toFlowFileEvent() {
        if (this.empty) {
            return EmptyFlowFileEvent.INSTANCE;
        }
        StandardFlowFileEvent event = new StandardFlowFileEvent();
        event.setAggregateLineageMillis(this.aggregateLineageMillis);
        event.setBytesRead(this.bytesRead);
        event.setBytesReceived(this.bytesReceived);
        event.setBytesSent(this.bytesSent);
        event.setBytesWritten(this.bytesWritten);
        event.setContentSizeIn(this.contentSizeIn);
        event.setContentSizeOut(this.contentSizeOut);
        event.setContentSizeRemoved(this.contentSizeRemoved);
        event.setFlowFilesIn(this.flowFilesIn);
        event.setFlowFilesOut(this.flowFilesOut);
        event.setFlowFilesReceived(this.flowFilesReceived);
        event.setFlowFilesRemoved(this.flowFilesRemoved);
        event.setFlowFilesSent(this.flowFilesSent);
        event.setInvocations(this.invocations);
        event.setProcessingNanos(this.processingNanos);
        event.setCpuNanoseconds(this.cpuNanos);
        event.setContentReadNanoseconds(this.contentReadNanos);
        event.setContentWriteNanoseconds(this.contentWriteNanos);
        event.setSessionCommitNanos(this.sessionCommitNanos);
        event.setGarbageCollectionMillis(this.gcMillis);
        event.setCounters(this.counters == null ? Collections.emptyMap() : Collections.unmodifiableMap(this.counters));
        return event;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void add(EventSumValue other) {
        if (other.empty) {
            return;
        }
        EventSumValue eventSumValue = other;
        synchronized (eventSumValue) {
            this.aggregateLineageMillis += other.aggregateLineageMillis;
            this.bytesRead += other.bytesRead;
            this.bytesReceived += other.bytesReceived;
            this.bytesSent += other.bytesSent;
            this.bytesWritten += other.bytesWritten;
            this.contentSizeIn += other.contentSizeIn;
            this.contentSizeOut += other.contentSizeOut;
            this.contentSizeRemoved += other.contentSizeRemoved;
            this.flowFilesIn += other.flowFilesIn;
            this.flowFilesOut += other.flowFilesOut;
            this.flowFilesReceived += other.flowFilesReceived;
            this.flowFilesRemoved += other.flowFilesRemoved;
            this.flowFilesSent += other.flowFilesSent;
            this.invocations += other.invocations;
            this.processingNanos += other.processingNanos;
            this.cpuNanos += other.cpuNanos;
            this.contentReadNanos += other.contentReadNanos;
            this.contentWriteNanos += other.contentWriteNanos;
            this.sessionCommitNanos += other.sessionCommitNanos;
            Map<String, Long> eventCounters = other.counters;
            if (eventCounters != null) {
                if (this.counters == null) {
                    this.counters = new HashMap<String, Long>();
                }
                for (Map.Entry<String, Long> entry : eventCounters.entrySet()) {
                    String counterName = entry.getKey();
                    Long counterValue = entry.getValue();
                    this.counters.compute(counterName, (key, value) -> value == null ? counterValue : value + counterValue);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void subtract(EventSumValue other) {
        if (other.empty) {
            return;
        }
        EventSumValue eventSumValue = other;
        synchronized (eventSumValue) {
            this.aggregateLineageMillis -= other.aggregateLineageMillis;
            this.bytesRead -= other.bytesRead;
            this.bytesReceived -= other.bytesReceived;
            this.bytesSent -= other.bytesSent;
            this.bytesWritten -= other.bytesWritten;
            this.contentSizeIn -= other.contentSizeIn;
            this.contentSizeOut -= other.contentSizeOut;
            this.contentSizeRemoved -= other.contentSizeRemoved;
            this.flowFilesIn -= other.flowFilesIn;
            this.flowFilesOut -= other.flowFilesOut;
            this.flowFilesReceived -= other.flowFilesReceived;
            this.flowFilesRemoved -= other.flowFilesRemoved;
            this.flowFilesSent -= other.flowFilesSent;
            this.invocations -= other.invocations;
            this.processingNanos -= other.processingNanos;
            this.cpuNanos -= other.cpuNanos;
            this.contentReadNanos -= other.contentReadNanos;
            this.contentWriteNanos -= other.contentWriteNanos;
            this.sessionCommitNanos -= other.sessionCommitNanos;
            Map<String, Long> eventCounters = other.counters;
            if (eventCounters != null) {
                if (this.counters == null) {
                    this.counters = new HashMap<String, Long>();
                }
                for (Map.Entry<String, Long> entry : eventCounters.entrySet()) {
                    String counterName = entry.getKey();
                    Long counterValue = entry.getValue();
                    this.counters.compute(counterName, (key, value) -> value == null ? -counterValue.longValue() : value - counterValue);
                }
            }
        }
    }

    public long getTimestamp() {
        return this.millisecondTimestamp;
    }
}

