/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.registry.flow.mapping;

import java.nio.charset.StandardCharsets;
import java.util.Optional;
import java.util.UUID;

public interface ComponentIdLookup {
    public static final ComponentIdLookup VERSIONED_OR_GENERATE = new ComponentIdLookup(){

        @Override
        public String getComponentId(Optional<String> currentVersionedId, String componentId) {
            if (currentVersionedId.isPresent()) {
                return currentVersionedId.get();
            }
            return UUID.nameUUIDFromBytes(componentId.getBytes(StandardCharsets.UTF_8)).toString();
        }
    };
    public static final ComponentIdLookup USE_COMPONENT_ID = (versioned, componentId) -> componentId;

    public String getComponentId(Optional<String> var1, String var2);
}

