/*
 * Decompiled with CFR 0.152.
 */
package v14.h2.table;

import v14.h2.engine.Session;
import v14.h2.expression.Expression;
import v14.h2.index.Index;
import v14.h2.index.RangeIndex;
import v14.h2.message.DbException;
import v14.h2.schema.Schema;
import v14.h2.table.Column;
import v14.h2.table.IndexColumn;
import v14.h2.table.TableType;
import v14.h2.table.VirtualTable;

public class RangeTable
extends VirtualTable {
    public static final String NAME = "SYSTEM_RANGE";
    public static final String ALIAS = "GENERATE_SERIES";
    private Expression min;
    private Expression max;
    private Expression step;
    private boolean optimized;

    public RangeTable(Schema schema, Expression expression, Expression expression2) {
        super(schema, 0, NAME);
        this.min = expression;
        this.max = expression2;
        this.setColumns(new Column[]{new Column("X", 5)});
    }

    public RangeTable(Schema schema, Expression expression, Expression expression2, Expression expression3) {
        this(schema, expression, expression2);
        this.step = expression3;
    }

    @Override
    public StringBuilder getSQL(StringBuilder stringBuilder, boolean bl) {
        stringBuilder.append(NAME).append('(');
        this.min.getSQL(stringBuilder, bl).append(", ");
        this.max.getSQL(stringBuilder, bl);
        if (this.step != null) {
            stringBuilder.append(", ");
            this.step.getSQL(stringBuilder, bl);
        }
        return stringBuilder.append(')');
    }

    @Override
    public boolean canGetRowCount() {
        return true;
    }

    @Override
    public long getRowCount(Session session) {
        long l = this.getStep(session);
        if (l == 0L) {
            throw DbException.get(90142);
        }
        long l2 = this.getMax(session) - this.getMin(session);
        if (l > 0L ? l2 < 0L : l2 > 0L) {
            return 0L;
        }
        return l2 / l + 1L;
    }

    @Override
    public TableType getTableType() {
        return TableType.SYSTEM_TABLE;
    }

    @Override
    public Index getScanIndex(Session session) {
        if (this.getStep(session) == 0L) {
            throw DbException.get(90142);
        }
        return new RangeIndex(this, IndexColumn.wrap(this.columns));
    }

    public long getMin(Session session) {
        this.optimize(session);
        return this.min.getValue(session).getLong();
    }

    public long getMax(Session session) {
        this.optimize(session);
        return this.max.getValue(session).getLong();
    }

    public long getStep(Session session) {
        this.optimize(session);
        if (this.step == null) {
            return 1L;
        }
        return this.step.getValue(session).getLong();
    }

    private void optimize(Session session) {
        if (!this.optimized) {
            this.min = this.min.optimize(session);
            this.max = this.max.optimize(session);
            if (this.step != null) {
                this.step = this.step.optimize(session);
            }
            this.optimized = true;
        }
    }

    @Override
    public long getMaxDataModificationId() {
        return 0L;
    }

    @Override
    public long getRowCountApproximation() {
        return 100L;
    }

    @Override
    public boolean isDeterministic() {
        return true;
    }
}

