/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.controller.lifecycle;

import java.io.IOException;
import java.util.Map;
import org.apache.nifi.components.state.Scope;
import org.apache.nifi.components.state.StateManager;
import org.apache.nifi.components.state.StateMap;
import org.apache.nifi.controller.lifecycle.TaskTermination;
import org.apache.nifi.processor.exception.TerminatedTaskException;

public class TaskTerminationAwareStateManager
implements StateManager {
    private final StateManager stateManager;
    private final TaskTermination taskTermination;

    public TaskTerminationAwareStateManager(StateManager stateManager, TaskTermination taskTermination) {
        this.stateManager = stateManager;
        this.taskTermination = taskTermination;
    }

    private void verifyNotTerminated() {
        if (this.taskTermination.isTerminated()) {
            throw new TerminatedTaskException();
        }
    }

    public void clear(Scope scope) throws IOException {
        this.verifyNotTerminated();
        this.stateManager.clear(scope);
    }

    public StateMap getState(Scope scope) throws IOException {
        this.verifyNotTerminated();
        return this.stateManager.getState(scope);
    }

    public boolean replace(StateMap oldValue, Map<String, String> newValue, Scope scope) throws IOException {
        this.verifyNotTerminated();
        return this.stateManager.replace(oldValue, newValue, scope);
    }

    public void setState(Map<String, String> state, Scope scope) throws IOException {
        this.verifyNotTerminated();
        this.stateManager.setState(state, scope);
    }
}

