/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.controller.scheduling;

import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.apache.nifi.annotation.lifecycle.OnScheduled;
import org.apache.nifi.annotation.lifecycle.OnShutdown;
import org.apache.nifi.annotation.lifecycle.OnStopped;
import org.apache.nifi.annotation.lifecycle.OnUnscheduled;
import org.apache.nifi.annotation.notification.PrimaryNodeState;
import org.apache.nifi.components.state.StateManager;
import org.apache.nifi.components.state.StateManagerProvider;
import org.apache.nifi.components.validation.ValidationStatus;
import org.apache.nifi.connectable.Connectable;
import org.apache.nifi.connectable.Funnel;
import org.apache.nifi.connectable.Port;
import org.apache.nifi.controller.AbstractPort;
import org.apache.nifi.controller.ComponentNode;
import org.apache.nifi.controller.ConfigurationContext;
import org.apache.nifi.controller.ControllerServiceLookup;
import org.apache.nifi.controller.FlowController;
import org.apache.nifi.controller.NodeTypeProvider;
import org.apache.nifi.controller.ProcessScheduler;
import org.apache.nifi.controller.ProcessorNode;
import org.apache.nifi.controller.ReportingTaskNode;
import org.apache.nifi.controller.ScheduledState;
import org.apache.nifi.controller.SchedulingAgentCallback;
import org.apache.nifi.controller.exception.ProcessorInstantiationException;
import org.apache.nifi.controller.repository.scheduling.ConnectableProcessContext;
import org.apache.nifi.controller.scheduling.LifecycleState;
import org.apache.nifi.controller.scheduling.SchedulingAgent;
import org.apache.nifi.controller.service.ControllerServiceNode;
import org.apache.nifi.controller.service.ControllerServiceProvider;
import org.apache.nifi.controller.service.StandardConfigurationContext;
import org.apache.nifi.engine.FlowEngine;
import org.apache.nifi.logging.LoggingContext;
import org.apache.nifi.logging.StandardLoggingContext;
import org.apache.nifi.nar.ExtensionManager;
import org.apache.nifi.nar.NarCloseable;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.SimpleProcessLogger;
import org.apache.nifi.processor.StandardProcessContext;
import org.apache.nifi.reporting.ReportingTask;
import org.apache.nifi.scheduling.SchedulingStrategy;
import org.apache.nifi.util.FormatUtils;
import org.apache.nifi.util.NiFiProperties;
import org.apache.nifi.util.ReflectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class StandardProcessScheduler
implements ProcessScheduler {
    private static final Logger LOG = LoggerFactory.getLogger(StandardProcessScheduler.class);
    private final FlowController flowController;
    private final long administrativeYieldMillis;
    private final String administrativeYieldDuration;
    private final StateManagerProvider stateManagerProvider;
    private final long processorStartTimeoutMillis;
    private final ConcurrentMap<Object, LifecycleState> lifecycleStates = new ConcurrentHashMap<Object, LifecycleState>();
    private final ScheduledExecutorService frameworkTaskExecutor;
    private final ConcurrentMap<SchedulingStrategy, SchedulingAgent> strategyAgentMap = new ConcurrentHashMap<SchedulingStrategy, SchedulingAgent>();
    private final ScheduledExecutorService componentLifeCycleThreadPool;
    private final ScheduledExecutorService componentMonitoringThreadPool = new FlowEngine(2, "Monitor Processor Lifecycle", true);

    public StandardProcessScheduler(FlowEngine componentLifecycleThreadPool, FlowController flowController, StateManagerProvider stateManagerProvider, NiFiProperties nifiProperties) {
        this.componentLifeCycleThreadPool = componentLifecycleThreadPool;
        this.flowController = flowController;
        this.stateManagerProvider = stateManagerProvider;
        this.administrativeYieldDuration = nifiProperties.getAdministrativeYieldDuration();
        this.administrativeYieldMillis = FormatUtils.getTimeDuration((String)this.administrativeYieldDuration, (TimeUnit)TimeUnit.MILLISECONDS);
        String timeoutString = nifiProperties.getProperty("nifi.processor.scheduling.timeout");
        this.processorStartTimeoutMillis = timeoutString == null ? 60000L : FormatUtils.getTimeDuration((String)timeoutString.trim(), (TimeUnit)TimeUnit.MILLISECONDS);
        this.frameworkTaskExecutor = new FlowEngine(4, "Framework Task Thread");
    }

    public ControllerServiceProvider getControllerServiceProvider() {
        return this.flowController.getControllerServiceProvider();
    }

    private StateManager getStateManager(String componentId) {
        return this.stateManagerProvider.getStateManager(componentId);
    }

    public void scheduleFrameworkTask(final Runnable command, final String taskName, long initialDelay, long delay, TimeUnit timeUnit) {
        this.frameworkTaskExecutor.scheduleWithFixedDelay(new Runnable(){

            @Override
            public void run() {
                block2: {
                    try {
                        command.run();
                    }
                    catch (Throwable t) {
                        LOG.error("Failed to run Framework Task {} due to {}", (Object)taskName, (Object)t.toString());
                        if (!LOG.isDebugEnabled()) break block2;
                        LOG.error("", t);
                    }
                }
            }
        }, initialDelay, delay, timeUnit);
    }

    public Future<?> submitFrameworkTask(Runnable task) {
        return this.frameworkTaskExecutor.submit(task);
    }

    public void setMaxThreadCount(SchedulingStrategy schedulingStrategy, int maxThreadCount) {
        SchedulingAgent agent = this.getSchedulingAgent(schedulingStrategy);
        if (agent == null) {
            return;
        }
        agent.setMaxThreadCount(maxThreadCount);
    }

    public void setSchedulingAgent(SchedulingStrategy strategy, SchedulingAgent agent) {
        this.strategyAgentMap.put(strategy, agent);
    }

    public SchedulingAgent getSchedulingAgent(SchedulingStrategy strategy) {
        return (SchedulingAgent)this.strategyAgentMap.get(strategy);
    }

    private SchedulingAgent getSchedulingAgent(Connectable connectable) {
        return this.getSchedulingAgent(connectable.getSchedulingStrategy());
    }

    public void shutdown() {
        for (SchedulingAgent schedulingAgent : this.strategyAgentMap.values()) {
            try {
                schedulingAgent.shutdown();
            }
            catch (Throwable t) {
                LOG.error("Failed to shutdown Scheduling Agent {} due to {}", (Object)schedulingAgent, (Object)t.toString());
                LOG.error("", t);
            }
        }
        this.frameworkTaskExecutor.shutdown();
        this.componentLifeCycleThreadPool.shutdown();
    }

    public void shutdownReportingTask(ReportingTaskNode reportingTask) {
        ConfigurationContext configContext = reportingTask.getConfigurationContext();
        try (NarCloseable narCloseable = NarCloseable.withComponentNarLoader((ExtensionManager)this.flowController.getExtensionManager(), reportingTask.getReportingTask().getClass(), (String)reportingTask.getIdentifier());){
            ReflectionUtils.quietlyInvokeMethodsWithAnnotation(OnShutdown.class, (Object)reportingTask.getReportingTask(), (Object[])new Object[]{configContext});
        }
    }

    public void shutdownControllerService(ControllerServiceNode serviceNode, ControllerServiceProvider controllerServiceProvider) {
        Class<?> serviceImplClass = serviceNode.getControllerServiceImplementation().getClass();
        try (NarCloseable narCloseable = NarCloseable.withComponentNarLoader((ExtensionManager)this.flowController.getExtensionManager(), serviceImplClass, (String)serviceNode.getIdentifier());){
            StandardConfigurationContext configContext = new StandardConfigurationContext((ComponentNode)serviceNode, (ControllerServiceLookup)controllerServiceProvider, null, this.flowController.getVariableRegistry());
            ReflectionUtils.quietlyInvokeMethodsWithAnnotation(OnShutdown.class, (Object)serviceNode.getControllerServiceImplementation(), (Object[])new Object[]{configContext});
        }
    }

    public void schedule(final ReportingTaskNode taskNode) {
        final LifecycleState lifecycleState = this.getLifecycleState(Objects.requireNonNull(taskNode), true);
        if (lifecycleState.isScheduled()) {
            return;
        }
        int activeThreadCount = lifecycleState.getActiveThreadCount();
        if (activeThreadCount > 0) {
            throw new IllegalStateException("Reporting Task " + taskNode.getName() + " cannot be started because it has " + activeThreadCount + " threads still running");
        }
        final SchedulingAgent agent = this.getSchedulingAgent(taskNode.getSchedulingStrategy());
        lifecycleState.setScheduled(true);
        Runnable startReportingTaskRunnable = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                long lastStopTime = lifecycleState.getLastStopTime();
                ReportingTask reportingTask = taskNode.getReportingTask();
                try {
                    LifecycleState lifecycleState2 = lifecycleState;
                    synchronized (lifecycleState2) {
                        if (!lifecycleState.isScheduled() || lifecycleState.getLastStopTime() != lastStopTime) {
                            LOG.debug("Did not complete invocation of @OnScheduled task for {} but Lifecycle State is no longer scheduled. Will not attempt to invoke task anymore", (Object)reportingTask);
                            return;
                        }
                        ValidationStatus validationStatus = taskNode.getValidationStatus();
                        if (validationStatus != ValidationStatus.VALID) {
                            LOG.debug("Cannot schedule {} to run because it is currently invalid. Will try again in 5 seconds", (Object)taskNode);
                            StandardProcessScheduler.this.componentLifeCycleThreadPool.schedule(this, 5L, TimeUnit.SECONDS);
                            return;
                        }
                        try (NarCloseable x = NarCloseable.withComponentNarLoader((ExtensionManager)StandardProcessScheduler.this.flowController.getExtensionManager(), reportingTask.getClass(), (String)reportingTask.getIdentifier());){
                            ReflectionUtils.invokeMethodsWithAnnotation(OnScheduled.class, (Object)reportingTask, (Object[])new Object[]{taskNode.getConfigurationContext()});
                        }
                        agent.schedule(taskNode, lifecycleState);
                    }
                }
                catch (Exception e) {
                    Throwable cause = e instanceof InvocationTargetException ? e.getCause() : e;
                    SimpleProcessLogger componentLog = new SimpleProcessLogger(reportingTask.getIdentifier(), (Object)reportingTask, (LoggingContext)new StandardLoggingContext(null));
                    componentLog.error("Failed to invoke @OnScheduled method due to {}", cause);
                    LOG.error("Failed to invoke the On-Scheduled Lifecycle methods of {} due to {}; administratively yielding this ReportingTask and will attempt to schedule it again after {}", new Object[]{reportingTask, e.toString(), StandardProcessScheduler.this.administrativeYieldDuration, e});
                    try (NarCloseable x = NarCloseable.withComponentNarLoader((ExtensionManager)StandardProcessScheduler.this.flowController.getExtensionManager(), reportingTask.getClass(), (String)reportingTask.getIdentifier());){
                        ReflectionUtils.quietlyInvokeMethodsWithAnnotation(OnUnscheduled.class, (Object)reportingTask, (Object[])new Object[]{taskNode.getConfigurationContext()});
                        ReflectionUtils.quietlyInvokeMethodsWithAnnotation(OnStopped.class, (Object)reportingTask, (Object[])new Object[]{taskNode.getConfigurationContext()});
                    }
                    StandardProcessScheduler.this.componentLifeCycleThreadPool.schedule(this, StandardProcessScheduler.this.administrativeYieldMillis, TimeUnit.MILLISECONDS);
                }
            }
        };
        this.componentLifeCycleThreadPool.execute(startReportingTaskRunnable);
        taskNode.setScheduledState(ScheduledState.RUNNING);
    }

    public Future<Void> unschedule(final ReportingTaskNode taskNode) {
        final LifecycleState lifecycleState = this.getLifecycleState(Objects.requireNonNull(taskNode), false);
        if (!lifecycleState.isScheduled()) {
            return CompletableFuture.completedFuture(null);
        }
        taskNode.verifyCanStop();
        lifecycleState.incrementActiveThreadCount(null);
        final SchedulingAgent agent = this.getSchedulingAgent(taskNode.getSchedulingStrategy());
        final ReportingTask reportingTask = taskNode.getReportingTask();
        taskNode.setScheduledState(ScheduledState.STOPPED);
        final CompletableFuture<Void> future = new CompletableFuture<Void>();
        Runnable unscheduleReportingTaskRunnable = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                ConfigurationContext configurationContext = taskNode.getConfigurationContext();
                LifecycleState lifecycleState2 = lifecycleState;
                synchronized (lifecycleState2) {
                    lifecycleState.setScheduled(false);
                    try (NarCloseable x = NarCloseable.withComponentNarLoader((ExtensionManager)StandardProcessScheduler.this.flowController.getExtensionManager(), reportingTask.getClass(), (String)reportingTask.getIdentifier());){
                        ReflectionUtils.invokeMethodsWithAnnotation(OnUnscheduled.class, (Object)reportingTask, (Object[])new Object[]{configurationContext});
                    }
                    catch (Exception e) {
                        Throwable cause = e instanceof InvocationTargetException ? e.getCause() : e;
                        SimpleProcessLogger componentLog = new SimpleProcessLogger(reportingTask.getIdentifier(), (Object)reportingTask, (LoggingContext)new StandardLoggingContext(null));
                        componentLog.error("Failed to invoke @OnUnscheduled method due to {}", cause);
                        LOG.error("Failed to invoke the @OnUnscheduled methods of {} due to {}; administratively yielding this ReportingTask and will attempt to schedule it again after {}", new Object[]{reportingTask, cause.toString(), StandardProcessScheduler.this.administrativeYieldDuration});
                        LOG.error("", cause);
                    }
                    agent.unschedule(taskNode, lifecycleState);
                    if (lifecycleState.getActiveThreadCount() == 1 && lifecycleState.mustCallOnStoppedMethods()) {
                        ReflectionUtils.quietlyInvokeMethodsWithAnnotation(OnStopped.class, (Object)reportingTask, (Object[])new Object[]{configurationContext});
                        future.complete(null);
                    }
                    lifecycleState.decrementActiveThreadCount();
                }
            }
        };
        this.componentLifeCycleThreadPool.execute(unscheduleReportingTaskRunnable);
        return future;
    }

    public synchronized CompletableFuture<Void> startProcessor(final ProcessorNode procNode, boolean failIfStopping) {
        final LifecycleState lifecycleState = this.getLifecycleState(Objects.requireNonNull(procNode), true);
        Supplier<ProcessContext> processContextFactory = () -> new StandardProcessContext(procNode, this.getControllerServiceProvider(), this.flowController.getEncryptor(), this.getStateManager(procNode.getIdentifier()), () -> ((LifecycleState)lifecycleState).isTerminated(), (NodeTypeProvider)this.flowController);
        final CompletableFuture<Void> future = new CompletableFuture<Void>();
        SchedulingAgentCallback callback = new SchedulingAgentCallback(){

            public void trigger() {
                lifecycleState.clearTerminationFlag();
                StandardProcessScheduler.this.getSchedulingAgent((Connectable)procNode).schedule((Connectable)procNode, lifecycleState);
                future.complete(null);
            }

            public Future<?> scheduleTask(Callable<?> task) {
                lifecycleState.incrementActiveThreadCount(null);
                return StandardProcessScheduler.this.componentLifeCycleThreadPool.submit(task);
            }

            public void onTaskComplete() {
                lifecycleState.decrementActiveThreadCount();
            }
        };
        LOG.info("Starting {}", (Object)procNode);
        procNode.start(this.componentMonitoringThreadPool, this.administrativeYieldMillis, this.processorStartTimeoutMillis, processContextFactory, callback, failIfStopping);
        return future;
    }

    public Future<Void> runProcessorOnce(final ProcessorNode procNode, final Callable<Future<Void>> stopCallback) {
        final LifecycleState lifecycleState = this.getLifecycleState(Objects.requireNonNull(procNode), true);
        Supplier<ProcessContext> processContextFactory = () -> new StandardProcessContext(procNode, this.getControllerServiceProvider(), this.flowController.getEncryptor(), this.getStateManager(procNode.getIdentifier()), () -> ((LifecycleState)lifecycleState).isTerminated(), (NodeTypeProvider)this.flowController);
        final CompletableFuture<Void> future = new CompletableFuture<Void>();
        SchedulingAgentCallback callback = new SchedulingAgentCallback(){

            public void trigger() {
                lifecycleState.clearTerminationFlag();
                StandardProcessScheduler.this.getSchedulingAgent((Connectable)procNode).scheduleOnce((Connectable)procNode, lifecycleState, stopCallback);
                future.complete(null);
            }

            public Future<?> scheduleTask(Callable<?> task) {
                lifecycleState.incrementActiveThreadCount(null);
                return StandardProcessScheduler.this.componentLifeCycleThreadPool.submit(task);
            }

            public void onTaskComplete() {
                lifecycleState.decrementActiveThreadCount();
            }
        };
        LOG.info("Running once {}", (Object)procNode);
        procNode.runOnce(this.componentMonitoringThreadPool, this.administrativeYieldMillis, this.processorStartTimeoutMillis, processContextFactory, callback);
        return future;
    }

    public synchronized CompletableFuture<Void> stopProcessor(ProcessorNode procNode) {
        LifecycleState lifecycleState = this.getLifecycleState(procNode, false);
        StandardProcessContext processContext = new StandardProcessContext(procNode, this.getControllerServiceProvider(), this.flowController.getEncryptor(), this.getStateManager(procNode.getIdentifier()), () -> ((LifecycleState)lifecycleState).isTerminated(), (NodeTypeProvider)this.flowController);
        LOG.info("Stopping {}", (Object)procNode);
        return procNode.stop((ProcessScheduler)this, this.componentLifeCycleThreadPool, (ProcessContext)processContext, this.getSchedulingAgent((Connectable)procNode), lifecycleState);
    }

    public synchronized void terminateProcessor(ProcessorNode procNode) {
        if (procNode.getScheduledState() != ScheduledState.STOPPED && procNode.getScheduledState() != ScheduledState.RUN_ONCE) {
            throw new IllegalStateException("Cannot terminate " + procNode + " because it is not currently stopped");
        }
        LifecycleState state = this.getLifecycleState(procNode, false);
        if (state.getActiveThreadCount() == 0) {
            LOG.debug("Will not terminate {} because it has no active threads", (Object)procNode);
            return;
        }
        LOG.debug("Terminating {}", (Object)procNode);
        state.terminate();
        int tasksTerminated = procNode.terminate();
        this.getSchedulingAgent((Connectable)procNode).incrementMaxThreadCount(tasksTerminated);
        try {
            Set additionalUrls = procNode.getAdditionalClasspathResources(procNode.getPropertyDescriptors());
            this.flowController.getReloadComponent().reload(procNode, procNode.getProcessor().getClass().getName(), procNode.getBundleCoordinate(), additionalUrls);
        }
        catch (ProcessorInstantiationException e) {
            LOG.error("Failed to replace instance of Processor for {} when terminating Processor", (Object)procNode);
        }
        LOG.info("Successfully terminated {} with {} active threads", (Object)procNode, (Object)tasksTerminated);
    }

    public void notifyPrimaryNodeStateChange(ProcessorNode processor, PrimaryNodeState primaryNodeState) {
        LifecycleState lifecycleState = this.getLifecycleState(processor, false);
        processor.notifyPrimaryNodeChanged(primaryNodeState, lifecycleState);
    }

    public void notifyPrimaryNodeStateChange(ReportingTaskNode taskNode, PrimaryNodeState primaryNodeState) {
        LifecycleState lifecycleState = this.getLifecycleState(taskNode, false);
        taskNode.notifyPrimaryNodeChanged(primaryNodeState, lifecycleState);
    }

    public void notifyPrimaryNodeStateChange(ControllerServiceNode service, PrimaryNodeState primaryNodeState) {
        service.notifyPrimaryNodeChanged(primaryNodeState);
    }

    public void onProcessorRemoved(ProcessorNode procNode) {
        this.lifecycleStates.remove(procNode);
    }

    public void onPortRemoved(Port port) {
        this.lifecycleStates.remove(port);
    }

    public void onFunnelRemoved(Funnel funnel) {
        this.lifecycleStates.remove(funnel);
    }

    public void onReportingTaskRemoved(ReportingTaskNode reportingTask) {
        this.lifecycleStates.remove(reportingTask);
    }

    public void yield(ProcessorNode procNode) {
    }

    public void registerEvent(Connectable worker) {
        this.getSchedulingAgent(worker).onEvent(worker);
    }

    public int getActiveThreadCount(Object scheduled) {
        return this.getLifecycleState(scheduled, false).getActiveThreadCount();
    }

    public void startPort(Port port) {
        if (!port.isValid()) {
            throw new IllegalStateException("Port " + port.getIdentifier() + " is not in a valid state");
        }
        port.onSchedulingStart();
        this.startConnectable((Connectable)port);
    }

    public void startFunnel(Funnel funnel) {
        this.startConnectable((Connectable)funnel);
        funnel.setScheduledState(ScheduledState.RUNNING);
    }

    public void stopPort(Port port) {
        this.stopConnectable((Connectable)port);
        port.shutdown();
    }

    public void stopFunnel(Funnel funnel) {
        this.stopConnectable((Connectable)funnel);
        funnel.setScheduledState(ScheduledState.STOPPED);
    }

    private synchronized void startConnectable(Connectable connectable) {
        if (connectable.getScheduledState() == ScheduledState.DISABLED) {
            throw new IllegalStateException(connectable.getIdentifier() + " is disabled, so it cannot be started");
        }
        LifecycleState lifecycleState = this.getLifecycleState(Objects.requireNonNull(connectable), true);
        if (lifecycleState.isScheduled()) {
            return;
        }
        int activeThreads = lifecycleState.getActiveThreadCount();
        if (activeThreads > 0) {
            throw new IllegalStateException("Port cannot be scheduled to run until its last " + activeThreads + " threads finish");
        }
        lifecycleState.clearTerminationFlag();
        this.getSchedulingAgent(connectable).schedule(connectable, lifecycleState);
        lifecycleState.setScheduled(true);
    }

    private synchronized void stopConnectable(Connectable connectable) {
        LifecycleState state = this.getLifecycleState(Objects.requireNonNull(connectable), false);
        if (!state.isScheduled()) {
            return;
        }
        state.setScheduled(false);
        this.getSchedulingAgent(connectable).unschedule(connectable, state);
        if (!state.isScheduled() && state.getActiveThreadCount() == 0 && state.mustCallOnStoppedMethods()) {
            ConnectableProcessContext processContext = new ConnectableProcessContext(connectable, this.flowController.getEncryptor(), this.getStateManager(connectable.getIdentifier()));
            try (NarCloseable x = NarCloseable.withComponentNarLoader((ExtensionManager)this.flowController.getExtensionManager(), connectable.getClass(), (String)connectable.getIdentifier());){
                ReflectionUtils.quietlyInvokeMethodsWithAnnotation(OnStopped.class, (Object)connectable, (Object[])new Object[]{processContext});
            }
        }
    }

    public synchronized void enableFunnel(Funnel funnel) {
        if (funnel.getScheduledState() != ScheduledState.DISABLED) {
            throw new IllegalStateException("Funnel cannot be enabled because it is not disabled");
        }
        funnel.setScheduledState(ScheduledState.STOPPED);
    }

    public synchronized void disableFunnel(Funnel funnel) {
        if (funnel.getScheduledState() != ScheduledState.STOPPED) {
            throw new IllegalStateException("Funnel cannot be disabled because its state its state is set to " + funnel.getScheduledState());
        }
        funnel.setScheduledState(ScheduledState.DISABLED);
    }

    public synchronized void disablePort(Port port) {
        if (port.getScheduledState() != ScheduledState.STOPPED) {
            throw new IllegalStateException("Port cannot be disabled because its state is set to " + port.getScheduledState());
        }
        if (!(port instanceof AbstractPort)) {
            throw new IllegalArgumentException();
        }
        ((AbstractPort)port).disable();
    }

    public synchronized void enablePort(Port port) {
        if (port.getScheduledState() != ScheduledState.DISABLED) {
            throw new IllegalStateException("Funnel cannot be enabled because it is not disabled");
        }
        if (!(port instanceof AbstractPort)) {
            throw new IllegalArgumentException();
        }
        ((AbstractPort)port).enable();
    }

    public synchronized void enableProcessor(ProcessorNode procNode) {
        procNode.enable();
    }

    public synchronized void disableProcessor(ProcessorNode procNode) {
        procNode.disable();
    }

    public synchronized void enableReportingTask(ReportingTaskNode taskNode) {
        if (taskNode.getScheduledState() != ScheduledState.DISABLED) {
            throw new IllegalStateException("Reporting Task cannot be enabled because it is not disabled");
        }
        taskNode.setScheduledState(ScheduledState.STOPPED);
    }

    public synchronized void disableReportingTask(ReportingTaskNode taskNode) {
        if (taskNode.getScheduledState() != ScheduledState.STOPPED) {
            throw new IllegalStateException("Reporting Task cannot be disabled because its state is set to " + taskNode.getScheduledState() + " but transition to DISABLED state is allowed only from the STOPPED state");
        }
        taskNode.setScheduledState(ScheduledState.DISABLED);
    }

    public boolean isScheduled(Object scheduled) {
        LifecycleState lifecycleState = (LifecycleState)this.lifecycleStates.get(scheduled);
        return lifecycleState == null ? false : lifecycleState.isScheduled();
    }

    private LifecycleState getLifecycleState(Object schedulable, boolean replaceTerminatedState) {
        LifecycleState lifecycleState;
        block2: {
            LifecycleState newLifecycleState;
            while (true) {
                if ((lifecycleState = (LifecycleState)this.lifecycleStates.get(schedulable)) == null) {
                    lifecycleState = new LifecycleState();
                    LifecycleState existing = this.lifecycleStates.putIfAbsent(schedulable, lifecycleState);
                    if (existing != null) continue;
                    break block2;
                }
                if (!replaceTerminatedState || !lifecycleState.isTerminated()) break block2;
                newLifecycleState = new LifecycleState();
                boolean replaced = this.lifecycleStates.replace(schedulable, lifecycleState, newLifecycleState);
                if (replaced) break;
            }
            lifecycleState = newLifecycleState;
        }
        return lifecycleState;
    }

    public CompletableFuture<Void> enableControllerService(ControllerServiceNode service) {
        LOG.info("Enabling " + service);
        return service.enable(this.componentLifeCycleThreadPool, this.administrativeYieldMillis);
    }

    public CompletableFuture<Void> disableControllerService(ControllerServiceNode service) {
        LOG.info("Disabling {}", (Object)service);
        return service.disable(this.componentLifeCycleThreadPool);
    }

    public CompletableFuture<Void> disableControllerServices(List<ControllerServiceNode> services) {
        if (services == null || services.isEmpty()) {
            return CompletableFuture.completedFuture(null);
        }
        CompletableFuture<Void> future = null;
        if (!Objects.requireNonNull(services).isEmpty()) {
            for (ControllerServiceNode controllerServiceNode : services) {
                CompletableFuture<Void> serviceFuture = this.disableControllerService(controllerServiceNode);
                if (future == null) {
                    future = serviceFuture;
                    continue;
                }
                future = CompletableFuture.allOf(future, serviceFuture);
            }
        }
        return future;
    }
}

